package org.eaglei.ui.gwt.instance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FlowPanel;

public class MaterializedInversePropRenderer implements Renderer {

	EIInstance eiInstance;
	FlowPanel materializedPropertiesPanel;
	private final InstanceChangeListener listener;

	private static final Logger log = Logger.getLogger( "MaterializedInversePropertyRenderer" );

	public static final InstanceServiceRemoteAsync instanceService = GWT.create( InstanceServiceRemote.class );

	public MaterializedInversePropRenderer(EIInstance eiInstance, FlowPanel materializedPropertiesPanel, InstanceChangeListener listener) {
		this.eiInstance = eiInstance;
		this.materializedPropertiesPanel = materializedPropertiesPanel;
		this.listener = listener;
		renderProperties();
	}

	@Override
	public void renderProperties() {
		drawMaterializedInverseProperties();
	}

	// Unlike all other renderers, do NOT draw one widget per property. Instead, group all the materialized inverse
	// properties of the same type into a single widget.
	private void drawMaterializedInverseProperties() {

		final Map<EIEntity, List<EIInstanceMinimal>> materializedInverseProperties = eiInstance.getMaterializedInverseProperties();
		final Map<EIEntity, Set<EIInstanceMinimal>> instanceTypeMap = new HashMap<EIEntity, Set<EIInstanceMinimal>>();

		for (EIEntity entity : materializedInverseProperties.keySet()) {
			log.finer( "handling property " + entity.getLabel() );
			List<EIInstanceMinimal> entityInverses = materializedInverseProperties.get( entity );
			for (EIInstanceMinimal eiInstanceMinimal : entityInverses) {
				log.finer( "property " + entity.getLabel() + " had type " + eiInstanceMinimal.getDataModelRootSuperClass() );
				if ( instanceTypeMap.containsKey( eiInstanceMinimal.getDataModelRootSuperClass() ) ) {
					Set<EIInstanceMinimal> instanceList = instanceTypeMap.get( eiInstanceMinimal.getDataModelRootSuperClass() );
					if ( instanceList != null ) {
						instanceList.add( eiInstanceMinimal );
					}
				} else {
					Set<EIInstanceMinimal> instanceList = new HashSet<EIInstanceMinimal>();
					instanceList.add( eiInstanceMinimal );
					instanceTypeMap.put( eiInstanceMinimal.getDataModelRootSuperClass(), instanceList );
				}
			}
		}

		List<EIEntity> representedTypes = new ArrayList<EIEntity>( instanceTypeMap.keySet() );
		Collections.sort( representedTypes );
		for (final EIEntity instanceType : representedTypes) {
			MaterializedPropertyWidget materializedPropertyWidget = new MaterializedPropertyWidget( eiInstance, instanceType, new ArrayList<EIInstanceMinimal>(instanceTypeMap.get( instanceType )), materializedPropertiesPanel, listener );
			materializedPropertiesPanel.add( materializedPropertyWidget );
		}
	}

}
