package org.eaglei.ui.gwt.instance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Logger;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.ui.gwt.UIConstants;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.instance.widgets.EIInstancePreviewLink;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.SearchInstanceWidgetUtils;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;

public class MaterializedPropertyWidget extends Composite {

	private FlowPanel mainPanel;
	List<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
	FlowPanel materializedPanel;
	EIInstance eiInstance;
	private final InstanceChangeListener listener;

	private static final Logger log = Logger.getLogger( "MaterializedPropertyWidget" );
	private int currentIndex;

	public static final InstanceServiceRemoteAsync instanceService = GWT.create( InstanceServiceRemote.class );

	private static final int INVERSE_PROPERTIES_COUNT = 10;

	public MaterializedPropertyWidget(EIInstance eiInstance, EIEntity propertyEntity, List<EIInstanceMinimal> eiInstanceMinimalList, FlowPanel mainPanel, InstanceChangeListener listener) {
		instanceList = eiInstanceMinimalList;
		this.mainPanel = mainPanel;
		materializedPanel = new FlowPanel();
		this.listener = listener;
		this.eiInstance = eiInstance;
		initWidget( materializedPanel );
		setup();
	}

	private void setup() {
		final Map<EIEntity, List<EIInstanceMinimal>> instanceTypeMap = new HashMap<EIEntity, List<EIInstanceMinimal>>();
		for (final EIInstanceMinimal eiInstanceMinimal : instanceList) {
			if ( instanceTypeMap.containsKey( eiInstanceMinimal.getDataModelRootSuperClass() ) ) {
				List<EIInstanceMinimal> instanceList = instanceTypeMap.get( eiInstanceMinimal.getDataModelRootSuperClass() );
				if ( instanceList != null ) {
					instanceList.add( eiInstanceMinimal );
				}
			} else {
				List<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
				instanceList.add( eiInstanceMinimal );
				instanceTypeMap.put( eiInstanceMinimal.getDataModelRootSuperClass(), instanceList );
			}
		}

		for (final EIEntity instanceType : instanceTypeMap.keySet()) {
			String label = UIConstants.topLevelTypePlurals.get( instanceType.getLabel() );
			if ( label == null ) {
				log.warning( "no plural for " + instanceType.getLabel() );
				label = instanceType.getLabel();
			}
			DisclosurePanel typePanel = new DisclosurePanel( label );
			typePanel.setStyleName( "inversePanel" );
			final FlowPanel innerPanel = new FlowPanel();
			materializedPanel.add( typePanel );
			List<EIInstanceMinimal> instanceList = instanceTypeMap.get( instanceType );
			Collections.sort( instanceList, new Comparator<EIInstanceMinimal>() {
				@Override
				public int compare(EIInstanceMinimal instance1, EIInstanceMinimal instance2) {
					return ( instance1.getInstanceLabel().compareToIgnoreCase( instance2.getInstanceLabel() ) );
				}
			} );
			List<EIInstanceMinimal> firstPageList = getFirstPage( instanceList );

			displayResults( firstPageList, innerPanel, instanceTypeMap, instanceType );
			typePanel.setContent( innerPanel );

		}
	}

	private void addNextLink(final Map<EIEntity, List<EIInstanceMinimal>> instanceTypeMap, final EIEntity instanceType, final FlowPanel innerPanel) {
		if ( getCurrentIndex() < instanceTypeMap.get( instanceType ).size() ) {
			Image next = new Image( "images/pagination-rightarrow.png" );
			next.setStyleName( "nextLink" );
			innerPanel.add( next );
			next.addClickHandler( new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					List<EIInstanceMinimal> instanceList = instanceTypeMap.get( instanceType );

					List<EIInstanceMinimal> nextPageList = getNextPage( instanceList );

					displayResults( nextPageList, innerPanel, instanceTypeMap, instanceType );
				}
			} );
		} else {
			Image next = new Image( "images/pagination-rightarrow-disabled.png" );
			next.setStyleName( "nextLink" );
			innerPanel.add( next );
		}
	}

	private void addPrevLink(final Map<EIEntity, List<EIInstanceMinimal>> instanceTypeMap, final EIEntity instanceType, final FlowPanel innerPanel) {
		if ( getCurrentIndex() > INVERSE_PROPERTIES_COUNT ) {
			Image prev = new Image( "images/pagination-leftarrow.png" );
			prev.setStyleName( "prevLink" );
			innerPanel.add( prev );
			prev.addClickHandler( new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					List<EIInstanceMinimal> instanceList = instanceTypeMap.get( instanceType );

					List<EIInstanceMinimal> prevPageList = getPrevPage( instanceList );
					displayResults( prevPageList, innerPanel, instanceTypeMap, instanceType );
				}
			} );
		} else {
			Image prev = new Image( "images/pagination-leftarrow-disabled.png" );
			prev.setStyleName( "prevLink" );
			innerPanel.add( prev );
		}
	}

	private void displayResults(final List<EIInstanceMinimal> eiInstanceMinimalList, final FlowPanel innerPanel, final Map<EIEntity, List<EIInstanceMinimal>> instanceTypeMap, final EIEntity instanceType) {
		innerPanel.clear();
		final ListIterator<EIInstanceMinimal> li = eiInstanceMinimalList.listIterator();
		while ( li.hasNext() ) {
			final EIInstanceMinimal instance = li.next();
			final int indx = li.nextIndex();
			ClientModelManager.INSTANCE.isModelClassURI( instance.getInstanceURI(), new AsyncCallback<Boolean>() {
				@Override
				public void onFailure(Throwable caught) {
					// log.error( "there is async error in org.eaglei.datatools.client.ui.ViewFormsPanel#draObjectProperty when calling isModelClassURI(EIURI) Async method " );
				}

				@Override
				public void onSuccess(Boolean result) {

					if ( result ) {
						Label propertyValue = new Label( instance.getInstanceLabel() );
						// propertyValueLabel.setTitle( mapTermToDefinition.get( propertyValue.getURI() ) );
						innerPanel.add( propertyValue );

					} else {
						final String displayValue = InstanceWidgetUtils.formatText( instance.getInstanceLabel() );
						final EIInstancePreviewLink a = SearchInstanceWidgetUtils.createPreviewLink( displayValue, instanceService, instance.getEntity(), listener );
						innerPanel.add( a );
					}
					Scheduler.get().scheduleDeferred( new ScheduledCommand() {

						@Override
						public void execute() {
							if ( instanceTypeMap.get( instanceType ).size() > 10 ) {
								if ( indx == eiInstanceMinimalList.size() ) { // Last item in the list
									addPrevLink( instanceTypeMap, instanceType, innerPanel );
									addNextLink( instanceTypeMap, instanceType, innerPanel );
								}
							}
						}
					} );

				}
			} );
		}
	}

	public int getCurrentIndex() {
		return currentIndex;
	}

	public List<EIInstanceMinimal> getFirstPage(List<EIInstanceMinimal> instanceMinimalList) {
		return iterateFrom( 0, instanceMinimalList );
	}

	public List<EIInstanceMinimal> getNextPage(List<EIInstanceMinimal> instanceMinimalList) {
		return iterateFrom( getCurrentIndex(), instanceMinimalList );
	}

	public List<EIInstanceMinimal> getPrevPage(List<EIInstanceMinimal> instanceMinimalList) {
		int newStart = getCurrentIndex() - INVERSE_PROPERTIES_COUNT; // current index is the end, so our start right now is INV_PROP_COUNT before that
		if ( getCurrentIndex() % INVERSE_PROPERTIES_COUNT != 0 ) { // if we're on the last page with an irregular number
			newStart = getCurrentIndex() - ( getCurrentIndex() % INVERSE_PROPERTIES_COUNT ); // then the current start is just that extra chunk
		}
		newStart = newStart - INVERSE_PROPERTIES_COUNT; // Wherever we used to start, go back a page.
		return iterateFrom( newStart, instanceMinimalList );
	}

	private List<EIInstanceMinimal> iterateFrom(final int startIndex, List<EIInstanceMinimal> instanceList) {
		final int totalSize = instanceList.size();

		int endIndex = startIndex + INVERSE_PROPERTIES_COUNT;
		currentIndex = endIndex;
		if ( endIndex > totalSize ) {
			endIndex = totalSize;
			currentIndex = totalSize;
		}

		return instanceList.subList( startIndex, endIndex );
	}

}
