package org.eaglei.ui.gwt.instance;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.ui.gwt.SearchApplicationContext;
import org.eaglei.ui.gwt.UIConstants;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;

public class ReferencedBySidebarComponent extends Composite {
  
    protected FlowPanel outerPanel = new FlowPanel();
    protected FlowPanel linksPanel = new FlowPanel();

    public ReferencedBySidebarComponent() {
        initWidget(outerPanel); 
        setStyleName("referencedBySidebarComponent");
        
        Label title = new Label("Related Resources");
        outerPanel.add(title);
        title.setStyleName("title");
        outerPanel.add(linksPanel);
        linksPanel.setStyleName("referencesPanel");
        
        setVisible(false);
    }
    
    @Override
    public void setWidth(String width) {
        super.setWidth(width);
    }

    public void setReferences(Map<EIEntity, List<EIInstanceMinimal>> listReferences) { 
        setVisible(false);
        if (listReferences == null || listReferences.size() == 0) {
            return;
        }
        linksPanel.clear();
        
        List<EIEntity> instanceTypes = new LinkedList<EIEntity>(listReferences.keySet());
        Collections.sort(instanceTypes);
        for (final EIEntity instanceType : instanceTypes) {
        	String rootTypeString = UIConstants.topLevelTypePlurals.containsKey(instanceType.getLabel()) ? UIConstants.topLevelTypePlurals.get(instanceType.getLabel()) : instanceType.getLabel();
        	Label rootTypeLabel = new Label(rootTypeString);
        	rootTypeLabel.setStyleName( "relatedResourcesGroupTitle" );
        	linksPanel.add(rootTypeLabel);
        	List<EIInstanceMinimal> references = listReferences.get( instanceType );
        	Collections.sort( references );
        	for(EIInstanceMinimal eiInstanceMinimal: references) {
	            Hyperlink instanceLink = new Hyperlink(InstanceWidgetUtils.formatText( eiInstanceMinimal.getInstanceLabel() ), 
	                    SearchApplicationContext.INSTANCE_PAGE_TOKEN + "uri=" +  eiInstanceMinimal.getInstanceURI().toString());
	            linksPanel.add(instanceLink);
	            instanceLink.addStyleName("link");
        	}
        }
        setVisible(true);
    }
}
