package org.eaglei.ui.gwt.instance;

import static org.eaglei.ui.gwt.UIConstants.RESOURCE_HAS_STUBS;
import static org.eaglei.ui.gwt.UIConstants.RESOURCE_IS_STUB;
import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.RDFS_LABEL_ENTITY;
import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.RDF_TYPE_ENTITY;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIOntConstants;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassesInGroupCallback;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.instance.widgets.EIInstancePreviewLink;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;
import org.eaglei.ui.gwt.instance.widgets.SearchInstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.SearchLabelValuesWidget;
import org.eaglei.ui.gwt.security.SessionContext;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class SearchOntologyPropViewRenderer extends OntologyPropertiesRenderer {
	private static final String NO_INFORMATION_FOR_RESOURCE = "The resource has no information associated with it.";

	private final InstanceChangeListener listener;

	private static final Logger log = Logger.getLogger( "SearchOntologyPropViewRenderer" );
	Map<EIURI, String> mapTermToDefinition = new HashMap<EIURI, String>();

	public static final InstanceServiceRemoteAsync instanceService = GWT.create( InstanceServiceRemote.class );

	public SearchOntologyPropViewRenderer(EIInstance eiInstance, FlowPanel ontologyPanel, InstanceChangeListener listener) {
		super( eiInstance, ontologyPanel );
		this.listener = listener;
	}

	private void getTerms() {
		instanceService.getToolTips( SessionContext.getSessionId(), eiInstance.getInstanceURI(), new AsyncCallback<Map<EIURI, String>>() {
			@Override
			public void onFailure(Throwable caught) {
				log.log( Level.INFO, "Error retrieving tool tips" );
			}

			@Override
			public void onSuccess(Map<EIURI, String> resultMap) {
				mapTermToDefinition = resultMap;
				finishSetup();
			}

		} );

	}

	@Override
	protected void drawDataProperty(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final Set<String> propertyValues) {
		final LabelValuesWidget widget = new LabelValuesWidget( propertyEntity, propertyDefinition, isRequired );
		ontologyPanel.add( widget );
		for (final String value : propertyValues) {
			widget.add( handleReadOnlyTextProperty( value ) );
		}
	}

	@Override
	protected void drawObjectProperty(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final Set<EIEntity> propertyValues) {
		if ( eiInstance.isPropertyValueAnEmbeddedInstance( propertyEntity ) ) {
			for (final EIEntity propertyValue : propertyValues) {
				if ( isObjectValueToIgnore( propertyValue ) ) {
					continue;
				}
				EIEmbeddedResourceViewWidgetSearch embeddedWidget = new EIEmbeddedResourceViewWidgetSearch( eiInstance.getEmbeddedInstance( propertyValue ), propertyEntity, propertyDefinition, listener );
				ontologyPanel.add( embeddedWidget );
			}
		} else {
			if ( propertyValues.size() == 0 ) {
				return;
			}
			final LabelValuesWidget widget = new LabelValuesWidget( propertyEntity, propertyDefinition, isRequired );
			boolean hadValue = false;
			for (final EIEntity propertyValue : propertyValues) {
				if ( isObjectValueToIgnore( propertyValue ) ) {
					continue;
				}
				hadValue = true;
				final String displayValue = eiInstance.isPropertyValueAStub( propertyEntity, propertyValue ) ? "* " + propertyValue.getLabel() : propertyValue.getLabel();
				ClientModelManager.INSTANCE.isModelClassURI( propertyValue.getURI(), new AsyncCallback<Boolean>() {
					@Override
					public void onFailure(Throwable caught) {
						// log.error( "there is async error in org.eaglei.datatools.client.ui.ViewFormsPanel#draObjectProperty when calling isModelClassURI(EIURI) Async method " );
					}

					@Override
					public void onSuccess(Boolean result) {

						if ( result ) {
							HorizontalPanel valuePanel = new HorizontalPanel();
							widget.add( valuePanel );
							Label propertyValueLabel = new Label( displayValue ); 
							valuePanel.add( propertyValueLabel); 
							if(mapTermToDefinition!=null && (!mapTermToDefinition.get( propertyValue.getURI() ).equals( "null" ) && !mapTermToDefinition.get( propertyValue.getURI() ).equals( "" ))) {
								
								final Image toolTipImage = new Image("images/information.png");
								toolTipImage.setStyleName( "iconInformation" );
								final DecoratedPopupPanel simplePopup = new DecoratedPopupPanel(true);
								toolTipImage.addMouseOverHandler( new MouseOverHandler() {
									@Override
									public void onMouseOver(MouseOverEvent event) {
										showToolTip( propertyValue, simplePopup, event );
										
									}
								});
								
								toolTipImage.addMouseOutHandler( new MouseOutHandler() {
									
									@Override
									public void onMouseOut(MouseOutEvent event) { 
										 if(simplePopup.isShowing())
									        simplePopup.hide();
									}
								});
								valuePanel.add( toolTipImage); 
							} 
							
						} else { 
							final EIInstancePreviewLink a = SearchInstanceWidgetUtils.createPreviewLink( displayValue, instanceService, propertyValue, listener );			
							widget.add(a);
						}
					}
				} );
				if ( hadValue ) {
					ontologyPanel.add( widget );
				}
			}
		}

	}

	private void showToolTip(final EIEntity propertyValue, final DecoratedPopupPanel simplePopup, GwtEvent event) {
		simplePopup.setStyleName( "fakeTooltip" );
		simplePopup.setWidget(new HTML(mapTermToDefinition.get( propertyValue.getURI() )));
		Widget source = (Widget) event.getSource();
        int left = source.getAbsoluteLeft() + 10;
        int top = source.getAbsoluteTop() + 10;
        simplePopup.setPopupPosition(left, top);
        // Show the popup
        if(!simplePopup.isShowing())
        	simplePopup.show();
	}
	
	// TODO: the final comparison is a fix for SEARCH-312; EIInstanceFactory sets the label to the URI if it's missing
	private boolean isObjectValueToIgnore(final EIEntity propertyValue) {
		return propertyValue == null || propertyValue == EIEntity.NULL_ENTITY || propertyValue.getLabel().equals( EIEntity.NULL_ENTITY.getLabel() ) || propertyValue.getLabel().equals( propertyValue.getURI().toString() );
	}

	protected Widget handleReadOnlyTextProperty(final String value) {
		if ( value.startsWith( "www" ) || value.startsWith( "http" ) ) {
			// For values that have external URIs
			return new Anchor( InstanceWidgetUtils.formatText( value ), InstanceWidgetUtils.formatText( value ), "_blank" );
		} else {
			final HTML valueField = new HTML( InstanceWidgetUtils.formatText( InstanceWidgetUtils.insertBreaks( value ) ) );
			valueField.setStyleName( "formLabelValue" );
			return valueField;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.client.ui.OntologyPropertiesRenderer#getDataTypeEntities()
	 */
	@Override
	public Collection<EIEntity> getDataTypeEntities() {
		return eiInstance.getDatatypeProperties().keySet();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.client.ui.OntologyPropertiesRenderer#getObjectTypeEntities()
	 */
	@Override
	public Collection<EIEntity> getObjectTypeEntities() {
		return eiInstance.getObjectProperties().keySet();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.client.ui.OntologyPropertiesRenderer#addFormTitle(java.lang.String)
	 */
	@Override
	public void addFormTitle(String type) {
		if ( eiInstance.isEmbeddedInstance() ) {
			return;
		}
		HTML stubsMessage = null;
		if ( eiInstance.hasStubs() ) {
			stubsMessage = new HTML( RESOURCE_HAS_STUBS );

		} else if ( eiInstance.isStub() ) {
			stubsMessage = new HTML( RESOURCE_IS_STUB );
		}
		if ( stubsMessage != null ) {
			stubsMessage.setStyleName( "StubMessage" );
			ontologyPanel.add( stubsMessage );
		}

		final String shortName = InstanceWidgetUtils.getNodeNameFromURL( eiInstance.getInstanceURI().toString() );

		final String university = InstanceWidgetUtils.getUniversity( eiInstance.getInstanceURI().toString() );
		log.fine( "short name = " + shortName + "; university = " + university + "; logo = " + "images/logo_" + shortName + "-small.png" );
		if ( university != null ) {
			FlowPanel logoPanel = new FlowPanel();
			logoPanel.setStyleName("logoPanel");
			final Image logo = new Image();
			logo.setUrl( "images/logo_" + shortName + "-small.png" );
			logo.setStyleName("logoPanelLogoImage");
			logoPanel.add( logo );
			HTML universityName = new HTML( university );
			universityName.setStyleName("logoPanelSchoolName");
			logoPanel.add( universityName );
			ontologyPanel.add(logoPanel);
		}

	}

	@Override
	public void fetchConstants() {
		if ( eiInstance.hasEmbeddedInstances() ) {
			ClientModelManager.INSTANCE.getClassesInGroup( EIOntConstants.CG_EMBEDDED_CLASS, new ClassesInGroupCallback() {
				@Override
				public void onSuccess(final List<EIClass> result) {
					getTerms();
				}

			} );
		} else {
			getTerms();
		}
	}

	@Override
	protected void addNameProperty(final String labelPrefix) {
		if ( eiInstance.isEmbeddedInstance() ) {
			final EIEntity namePropEntity = EIEntity.create( RDFS_LABEL_ENTITY.getURI(), InstanceWidgetUtils.getExtendedPropertyLabel( labelPrefix, RDFS_LABEL_ENTITY.getLabel(), true ) );
			drawDataProperty( namePropEntity, "", true, makeSetFromSingle( eiInstance.getInstanceLabel() ) );
		} else {
			SearchLabelValuesWidget searchLabelWidget = new SearchLabelValuesWidget( ontologyPanel );
			searchLabelWidget.add( eiInstance.getInstanceLabel(), "instanceTitle", "" );
		}
	}

	@Override
	protected void addTypeProperty(final String labelPrefix) {
		if ( eiInstance.isEmbeddedInstance() ) {
			final EIEntity typePropEntity = EIEntity.create( RDF_TYPE_ENTITY.getURI(), InstanceWidgetUtils.getExtendedPropertyLabel( labelPrefix, RDF_TYPE_ENTITY.getLabel(), true ) );
			drawObjectProperty( typePropEntity, "", true, makeSetFromSingleEntity( eiInstance.getInstanceType() ) );
		} else {
			SearchLabelValuesWidget searchLabelWidget = new SearchLabelValuesWidget( ontologyPanel );
		//	Window.alert( "test"+ mapTermToDefinition!=null?mapTermToDefinition.get( eiInstance.getInstanceType().getURI()):"");
			String title = mapTermToDefinition==null?"":mapTermToDefinition.get( eiInstance.getInstanceType().getURI());
			searchLabelWidget.add( eiInstance.getInstanceType().getLabel(), "instanceType", title );
		}
	}
}
