package org.eaglei.ui.gwt.instance.widgets;

import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.missingTooltips;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import org.eaglei.model.EIEntity;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Label;

public class InstanceWidgetUtils {

	private static Logger log = Logger.getLogger( "InstanceWidgetUtils" );
	/**
	 * 
	 * @param propertyEntity
	 * @return
	 */
	public static Label createLabel(final EIEntity propertyEntity, final String definition, final boolean isRequired) {
		if ( propertyEntity == null || propertyEntity == EIEntity.NULL_ENTITY ) {
			return InstanceWidgetUtils.createLabel( "", definition, isRequired );
		}
		if ( missingTooltips.containsKey( propertyEntity ) ) {
			return InstanceWidgetUtils.createLabel( propertyEntity.getLabel(), missingTooltips.get( propertyEntity ), isRequired );
		}
		return InstanceWidgetUtils.createLabel( propertyEntity.getLabel(), definition, isRequired );
	}

	// FIXME see if this doesn't screw up other capitalization
	public static Label createLabel(final String label, final String definition, final boolean isRequired) {
		Label propertyLabel;
		if ( label == null || "".equals( label ) ) {
			propertyLabel = new Label( label );
		} else {
			propertyLabel = new Label( capitalizeFirst( label ) );
		}
		
		if ( isRequired ) {
			propertyLabel.setStyleName( "formLabelRequired" );
		} else {
			propertyLabel.setStyleName( "formLabel" );
		}

		if ( definition != null && !"".equals( definition ) && !"NO DEFINITION".equals( definition ) ) {
			propertyLabel.setTitle( definition );
		}
		return propertyLabel;
	}

	/* utilites for url making for search,glossary and help links */
	public static String getGlossaryURL() {
		final String url = GWT.getHostPageBaseURL();
		final String node = getNodeNameFromURL();
		if ( node != null ) {
			final String searchUrl = url.replace( node + ".", "search." ).replace( "/institution/", "" ).replace( "/datatools/", "" ) + "/model/";
			return searchUrl;
		} else {
			return null;
		}
	}

	public static String getNodeNameFromURL() {
		final String url = GWT.getHostPageBaseURL();
		return getNodeNameFromURL( url );
	}

	public static String getNodeNameFromURL(final String url) {
		int startIndex = -1;
		final int endIndex = url.indexOf( ".eagle-i.net" );
		if ( url.indexOf( "." ) > 0 && url.indexOf( "." ) < endIndex ) {
			startIndex = url.indexOf( "." ) + 1;
		} else {
			startIndex = url.indexOf( "//" ) + 2;
		}
		if ( endIndex == -1 || startIndex == -1 ) {
			return null;
		} else {
			final String node = url.substring( startIndex, endIndex );
			return node;
		}
	}
	
	public static String getUniversity(String instanceUri) {
		Map<String, String> shortNameToFullNameMap = new HashMap<String, String>() {
			private static final long serialVersionUID = 1L;

			{
				put( "harvard", "Harvard University" );
				put( "upr", "University Of Puerto Rico Medical Sciences Campus" );
				put( "msm", "Morehouse School of Medicine" );
				put( "jsu", "Jackson State University" );
				put( "hawaii", "University of Hawaii at Manoa" );
				put( "ohsu", "Oregon Health & Science University" );
				put( "dartmouth", "Dartmouth College" );
				put( "montana", "Montana State University" );
				put( "alaska", "University of Alaska Fairbanks" );
			}
		};

		String nodeName = getNodeNameFromURL( instanceUri );
		if ( nodeName != null && shortNameToFullNameMap.containsKey( nodeName ) ) {
			return shortNameToFullNameMap.get( nodeName );
		}

		return null;
	}

	public static String capitalizeFirst(final String original) {
		final char first = original.charAt( 0 );
		return Character.toUpperCase( first ) + original.substring( 1 );
	}

	/**
	 * Some field values that are retrieved from the repo have extra bit of data attached. This method eliminates the unwanted data in the value.
	 * 
	 * @return formatted value String
	 */
	public static String formatText(final String value) {
		if ( value.indexOf( "^" ) > 0 ) {
			return value.substring( 0, value.indexOf( "^" ) );
		}
		return value;
	}

	public static String getExtendedPropertyLabel(final String typeLabel, final String propertyName, final boolean isRequired) {
		// return capitalizeFirst(typeLabel) + " " + lowerCaseFirst(propertyName);
		// Title case is now preferred; the propertyName should be in capital case in the ontology
		return capitalizeFirst( typeLabel ) + " " + propertyName + (isRequired ? "*" : "");
	}

	public static String insertBreaks(String value) {
		return value.replaceAll( "(\r\n|\r|\n|\n\r)", "<br/>" );
	}
}
