package org.eaglei.ui.gwt.instance.widgets;

import org.eaglei.model.EIEntity;
import org.eaglei.ui.gwt.SearchApplicationContext;
import org.eaglei.ui.gwt.instance.InstanceChangeListener;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;

public class SearchInstanceWidgetUtils {
	public static EIInstancePreviewLink createPreviewLink(final String displayValue, final InstanceServiceRemoteAsync instanceService, final EIEntity propertyValue, final InstanceChangeListener listener ) {
		 final EIInstancePreviewLink a = new EIInstancePreviewLink( InstanceWidgetUtils.formatText( displayValue ), instanceService, propertyValue );

		a.addClickHandler( new ClickHandler() {
			@Override
			public void onClick(final ClickEvent arg0) {
				//log.fine( "listener changing instance to " + propertyValue.getURI() );
				History.newItem( SearchApplicationContext.INSTANCE_PAGE_TOKEN + "uri=" + propertyValue.getURI().toString() );
				listener.onInstanceChanged( propertyValue.getURI() );
			}

		} );
		
		return a;
	}

}
