package org.eaglei.ui.gwt.search;

import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchRequest.Term;
import org.eaglei.search.provider.SearchRequest.TypeBinding;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.suggest.DataSuggestBox;
import org.eaglei.ui.gwt.suggest.DataSuggestOracle;
import org.eaglei.ui.gwt.suggest.AbstractSearchBox.SearchHandler;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;

public class DataSuggestSearchBar extends Composite implements SearchContext.SearchListener {
	
	private static final boolean STICKY_SIDEBAR = false;

    DataSuggestBox termBox;
    Image searchButton;

    public DataSuggestSearchBar() {
    	this(true);
    }

    public DataSuggestSearchBar(boolean hasResourceSelect) {
        FlowPanel outer = new FlowPanel();
        initWidget(outer);
        
        DataSuggestOracle suggestOracle = new DataSuggestOracle();
        termBox = new DataSuggestBox(suggestOracle);
        outer.add(termBox);
        termBox.addStyleName("searchBoxResults");
        
        searchButton = new Image("images/button-search3.png");
        searchButton.setSize("130px", "38px");
        outer.add(searchButton);
        searchButton.setStyleName("buttonPadding");

    	//outer.add(searchButton);
        searchButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                String query = termBox.getText();
                if (query.equals(termBox.getLastSetText())) {
                	// No-op on search button click if the text hasn't 
                	// changed at all from what it was last set to.
                	return;
                }
                SearchRequest.Term term;
                if (query.length() == 0) {
                    term = null;
                } else {
                    term = new SearchRequest.Term(query);
                }
                executeSearch(term, null, false);
            }
        });

        termBox.addSearchHandler(new SearchHandler() {

            @Override
            public void performSearch(Term term, TypeBinding binding, boolean isSuggestSelect) {
                executeSearch(term, binding, isSuggestSelect);
            }
            
        }, true, true);
        
        termBox.setDefaultText();
        
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            setSearchRequest(SearchContext.INSTANCE.getCurrentRequest());
        }
        
        SearchContext.INSTANCE.addListener(this);
        
    }
    
    private void executeSearch(Term term, TypeBinding binding, boolean isSuggestSelect) {
        SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
        SearchRequest newRequest;
        if (STICKY_SIDEBAR) {
	        if (previousRequest != null) {
	            // TODO: somewhat inefficient way to create a clone
	            newRequest = new SearchRequest(previousRequest.toURLParams());
	            newRequest.setStartIndex(0);
	        } else {
	            newRequest = new SearchRequest();
	        }
	        newRequest.setTerm(term);
	        // Keep current type binding,
	        // unless a specific binding is selected from the suggest list.
	        if (isSuggestSelect && binding != null) {
	        	newRequest.setBinding(binding);
	        }
        } else {
            newRequest = new SearchRequest();        	
	        newRequest.setTerm(term);
        	newRequest.setBinding(binding);
        }
        SearchContext.INSTANCE.search(newRequest);
    }
    
    public void sizeToParent(int maxWidth) {
        int termBoxWidth = maxWidth - 130;  // search button

        termBox.setWidth(termBoxWidth + "px");        
    }
    
    private void setSearchRequest(SearchRequest request) {
        if (request != null && request.getTerm() != null) {
            termBox.setText(request.getTerm().getQuery());
        } else {
            termBox.setDefaultText();
        }
    }
    
    @Override
    public void onFailure(SearchRequest request, String message) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (request == null) {
            return;
        }
        
        if (!isAttached()) {
            return;
        }
         
        // A UI component in the interface has initiated a search.
        // Write the current term box content into the SearchRequest before it is executed.
        String query = termBox.getText();
        // TODO check for URI in the SearchRequest
        if (request.getTerm() == null || request.getTerm().getQuery().length() == 0) {
            if (query.length() > 0) {
                request.setTerm(new SearchRequest.Term(query));
            }
        } else if (request.getTerm() != null && request.getTerm().getQuery().length() > 0) {
            if (!request.getTerm().getQuery().equals(query)) {
                if (query.length() > 0) {
                    request.setTerm(new SearchRequest.Term(query));
                } else {
                    request.setTerm(null);
                }
            }
        }
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        setSearchRequest(request);
    }
    
    @Override
    public void onResults(ClientSearchResultSet results) {
    }
    
}
