package org.eaglei.ui.gwt.search.results;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchRequest.TypeBinding;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

public class FilterPanel extends Composite{
    private static final Logger log = Logger.getLogger( "FilterPanel" );
	
    static class DatatypePropertyInfo {
        EIEntity property;
        String valueDefaultText;
    }
    
    static class PropertyFilter extends HorizontalPanel {
        PropertyFilter(String label) {
            add(new Label(label));
            setStyleName("propertyPanel");
        }
    }
    
    static class DatatypePropertyFilter extends PropertyFilter {
        
        private EIURI propertyURI;
        private TextBox valueTextBox;
        private String defaultText;
        
        DatatypePropertyFilter(String label, EIURI propertyURI, final String defaultText) {
            super(label);
            this.propertyURI = propertyURI;
            this.defaultText = defaultText;
            valueTextBox = new TextBox();
            valueTextBox.setStyleName("formText");
            add(valueTextBox);
            
            valueTextBox.setText(defaultText);
            valueTextBox.addStyleDependentName("default");
            valueTextBox.addFocusHandler(new FocusHandler() {
                public void onFocus(FocusEvent event) {
                    if (defaultText.equals(valueTextBox.getText())) {
                        setText("");
                    }
                }
            });
        }
        
        public void setText(String text) {
            valueTextBox.setText(text);
            valueTextBox.removeStyleDependentName("default");
        }
        
        EIURI getPropertyURI() {
            return this.propertyURI;
        }
        
        String getValue() {
            String text = valueTextBox.getText().trim();
            if (text.equals(defaultText)) {
                return "";
            } else {
                return text;
            }
        }
    }
        
    static class TypePropertyFilter extends PropertyFilter {

        private final TypeChooser<OntologyDropdown> subTypeChooser;
        private EIClass currentRootClass;

        TypePropertyFilter() {
            super("Type:");
            subTypeChooser = new TypeChooser<OntologyDropdown>(new OntologyDropdown());
            subTypeChooser.setTextBoxStyle("formText");
            add(subTypeChooser);
            
            // Initialize to null
            currentRootClass = null;
            subTypeChooser.setClass(currentRootClass, false);
        }
        
        private void setClass(EIClass rootTypeClass, EIEntity selectedTypeEntity) {
            if ((currentRootClass == null && rootTypeClass != null) 
                    || (currentRootClass != null && ! currentRootClass.equals(rootTypeClass))) {
                // Handle change in root class
                subTypeChooser.setClass(rootTypeClass, false);
                currentRootClass = rootTypeClass;
            }
            
            // Handle selected type
            if (rootTypeClass != null && selectedTypeEntity != null
                    && rootTypeClass.getEntity().getURI().equals(selectedTypeEntity.getURI())) {
                // If selected entity is same as root class,
                // treat it as a null value.
                subTypeChooser.setSelectedEntity(null);
            } else {
                subTypeChooser.setSelectedEntity(selectedTypeEntity);
            }
        }
        
        private EIURI getSelectedType() {
            return subTypeChooser.getSelectedURI();
        }
    }
	
	interface Binder extends UiBinder<Widget, FilterPanel> {
    }

	private static final Binder binder = GWT.create(Binder.class);

	@UiField
	HorizontalPanel filterListPanel;
	
	private TypePropertyFilter typeFilter;
    private EIClass currentRootClass;
	
	public FilterPanel() {
		 initWidget(binder.createAndBindUi(this));
		 typeFilter = new TypePropertyFilter();
		 filterListPanel.add(typeFilter);
	}
	
	public EIURI getResourceType() {
	    return currentRootClass.getEntity().getURI();
	}
	
    public void setResourceType(final EIURI rootTypeURI, final EIEntity selectedTypeEntity) {
        if (rootTypeURI == null) {
            setResourceType((EIClass) null, selectedTypeEntity);
        } else {
            ClientModelManager.INSTANCE.getClass(rootTypeURI, new ClassCallback() {
                
                @Override
                public void onSuccess(EIClass result) {
                    // TODO do we need to worry about a new selection being
                    // made during async?
                    // Do we even need async?  Can we assume the category
                    // class is already in cache?
                    setResourceType(result, selectedTypeEntity);
                }
            });
        }
    }
    
	private void setResourceType(EIClass rootTypeClass, EIEntity selectedTypeEntity) {
        typeFilter.setClass(rootTypeClass, selectedTypeEntity);
        if ((currentRootClass == null && rootTypeClass != null) 
                || (currentRootClass != null && ! currentRootClass.equals(rootTypeClass))) {
            updateSearchFilters(rootTypeClass);
        }
        currentRootClass = rootTypeClass;
	}
	
	public void addFilters(SearchRequest request) {
	    // Update the type binding based on current type property filter setting
	    EIURI selectedURI = typeFilter.getSelectedType();
	    TypeBinding binding = null;
	    if (selectedURI != null) {
	        binding = new TypeBinding(selectedURI);
	    } else if (currentRootClass != null) {
	        binding = new TypeBinding(currentRootClass.getEntity().getURI());
	    }
	    
	    // Add any non-empty property values
	    if (binding != null) {
	        for (int i=1; i<filterListPanel.getWidgetCount(); i++) {
	            DatatypePropertyFilter propFilter = 
	                (DatatypePropertyFilter) filterListPanel.getWidget(i);
	            EIURI propURI = propFilter.getPropertyURI();
	            String value = propFilter.getValue();
	            if (value.length() > 0) {
	                binding.addDataTypeProperty(propURI, value);
	            }
	        }
	    }
	    
	    request.setBinding(binding);
	}
	
	private static Map<EIURI, List<DatatypePropertyInfo>> FILTER_PROPERTY_MAP = null;
	
	private void updateSearchFilters(EIClass rootTypeClass) {
	    for (int i=filterListPanel.getWidgetCount()-1; i>0; i--) {
	        filterListPanel.remove(i);
	    }
	    
        if (rootTypeClass == null) {
            // Currently no extra filter props for All Resources
            return;
        }
        
        if (FILTER_PROPERTY_MAP == null) {
            // Only initialize the map when first needed.
            initFilterMap();
        }
        
	    List<DatatypePropertyInfo> propEntityList = FILTER_PROPERTY_MAP.get(rootTypeClass.getEntity().getURI());
	    if (propEntityList != null) {
	        for (DatatypePropertyInfo pInfo : propEntityList) {
	            filterListPanel.add(new DatatypePropertyFilter(pInfo.property.getLabel() + ":", pInfo.property.getURI(), pInfo.valueDefaultText));
	        }
	    }
	}
	
	private void initFilterMap() {
        ArrayList<DatatypePropertyInfo> propInfoList;
	    FILTER_PROPERTY_MAP = new HashMap<EIURI, List<DatatypePropertyInfo>>();
	    
	    DatatypePropertyInfo propInfo;
        EIEntity locationProperty = EIEntity.create(EIURI.create("http://www.obofoundry.org/ro/ro.owl#located_in"), "Lab");
        DatatypePropertyInfo locationPropertyInfo = new DatatypePropertyInfo();
        locationPropertyInfo.property = locationProperty;
        locationPropertyInfo.valueDefaultText = "Laboratory Name";
        EIEntity manufacturerProperty = EIEntity.create(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000034"), "Manufacturer");
        DatatypePropertyInfo manufacturerPropertyInfo = new DatatypePropertyInfo();
        manufacturerPropertyInfo.property = manufacturerProperty;
        manufacturerPropertyInfo.valueDefaultText = "Manufacturer Name";
	    
        // Organism
	    EIURI type = EIURI.create("http://purl.obolibrary.org/obo/OBI_0100026"); 
	    propInfoList = new ArrayList<DatatypePropertyInfo>();
	    //   Location
        propInfoList.add(locationPropertyInfo);
        //   Disease Modeled
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000233"), "Models");
        propInfo.valueDefaultText = "Disease Name";
        propInfoList.add(propInfo);
	    FILTER_PROPERTY_MAP.put(type, propInfoList);
        
        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000006"); // Reagent
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfoList.add(locationPropertyInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        
        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000004"); // Instrument
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfoList.add(locationPropertyInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        
        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000005"); // Service
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        /*propEntityList.add(EIEntity.create(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000029"), "Provides access to"));*/
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        
        type = EIURI.create("http://purl.obolibrary.org/obo/OBI_0000272"); // Protocol
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        
        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000015"); // Human Study
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create(EIURI.create("http://eagle-i.org/ont/data/Ctcondition"), "Condition");
        propInfo.valueDefaultText = "Condition Name";
        propInfoList.add(propInfo);
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create(EIURI.create("http://eagle-i.org/ont/data/Ctintervention"), "Intervention");
        propInfo.valueDefaultText = "Intervention Name";
        propInfoList.add(propInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        
        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000071"); // Software
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000070"), "Lab");
        propInfo.valueDefaultText = "Laboratory Name";
        propInfoList.add(propInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);
        
	}
	
}
