package org.eaglei.ui.gwt.search.results;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.SearchRequest.Term;
import org.eaglei.ui.gwt.search.results.NavBar.NavListener;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

public class InnerNavBar extends Composite {
    @UiTemplate("InnerNavBar.ui.xml")
    interface Binder extends UiBinder<Widget, InnerNavBar> {
    }

    private static final Binder binder = GWT.create(Binder.class);
    private NavListener listener;

    // Static list of institutions
    private Map<EIURI, String> mapInstURIToLabel = null;
    
    private static final String SEPARATOR = " - "; 

    @UiField
    Element countLabel;
    @UiField
    Anchor previousButton;
    @UiField
    Anchor nextButton;
    @UiField
    SpanElement breadcrumbSpan;

    public InnerNavBar() {
        initWidget(binder.createAndBindUi(this));
        previousButton.addMouseOverHandler(new MouseOverHandler() {
            
            @Override
            public void onMouseOver(MouseOverEvent event) {
                previousButton.addStyleDependentName("hovering");
            }
        });
        previousButton.addMouseOutHandler(new MouseOutHandler() {
            
            @Override
            public void onMouseOut(MouseOutEvent event) {
                previousButton.removeStyleDependentName("hovering");
            }
        });
        nextButton.addMouseOverHandler(new MouseOverHandler() {
            
            @Override
            public void onMouseOver(MouseOverEvent event) {
                nextButton.addStyleDependentName("hovering");
            }
        });
        nextButton.addMouseOutHandler(new MouseOutHandler() {
            
            @Override
            public void onMouseOut(MouseOutEvent event) {
                nextButton.removeStyleDependentName("hovering");
            }
        });
        initInstitutionList();
    }
    
    public void addNavListener(NavListener listener) {
        this.listener = listener;
    }

    public void update(ClientSearchResultSet results) {
    	SearchResultSet resultSet = results.getResultSet();
    	int startIndex = resultSet.getStartIndex();
    	int count = resultSet.getTotalCount();
        int max = resultSet.getStartIndex() + ResourcesGrid.PAGE_SIZE;
        if (max > count) {
            max = count;
        }
        
        setVisibility(previousButton, startIndex != 0);
        setVisibility(nextButton, startIndex + SearchRequest.DEFAULT_PAGE_SIZE < count);

        if (count == 0) {
            countLabel.setInnerText("");
        } else {
            countLabel.setInnerText("" + (startIndex + 1) + " - " + max + " of " + count);    	
        }
        updateBreadCrumbs(results);
    }

    private void updateBreadCrumbs(ClientSearchResultSet results) {
		StringBuilder crumbBuilder = new StringBuilder();
		boolean first = true;
		EIURI instUri = results.getResultSet().getRequest().getProviderInstitution();
		if (instUri != null) {
			crumbBuilder.append(mapInstURIToLabel.get(instUri));
			first = false;
		}
		String providerLabel = results.getResultSet().getRequest().getProviderTypeLabel();
		if (providerLabel != null) {
			if (!first) {
				crumbBuilder.append(SEPARATOR);
			}
			crumbBuilder.append(providerLabel);
			first = false;
		}
		EIEntity entity = results.getBindingEntity();
		if (entity != null) {
			if (!first) {
				crumbBuilder.append(SEPARATOR);
			}
			crumbBuilder.append(entity.getLabel());
			first = false;
		}
		Term term = results.getResultSet().getRequest().getTerm();
		if (term != null) {
			if (!first) {
				crumbBuilder.append(SEPARATOR);
			}
			crumbBuilder.append("\"" + term.getQuery() + "\"");
		}
		breadcrumbSpan.setInnerText(crumbBuilder.toString());
	}

	@UiHandler("previousButton")
    void onNewerClicked(ClickEvent event) {
        listener.onPreviousPage();
    }

    @UiHandler("nextButton")
    void onOlderClicked(ClickEvent event) {
        listener.onNextPage();
    }

    private void setVisibility(Widget widget, boolean visible) {
        widget.setVisible(visible);
        //widget.getElement().getStyle().setVisibility(
        //        visible ? Visibility.VISIBLE : Visibility.HIDDEN);
    }
    
    private void initInstitutionList() {
        SearchServiceRemoteAsync searchService = GWT.create(SearchServiceRemote.class);
        searchService.getInstitutions(new AsyncCallback<List<EIEntity>>() {
            
            @Override
            public void onSuccess(List<EIEntity> result) {
                mapInstURIToLabel = new HashMap<EIURI, String>(result.size()); 
                for (EIEntity entity : result) {
                    mapInstURIToLabel.put(entity.getURI(), entity.getLabel());
                }
            }
            
            @Override
            public void onFailure(Throwable caught) {
            }
        });
    }
}
