package org.eaglei.ui.gwt.search.results;

import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

/**
 * A simple widget representing prev/next page navigation.
 */
public class NavBar extends Composite {
    @UiTemplate("NavBar.ui.xml")
    interface Binder extends UiBinder<Widget, NavBar> {
    }
    
    public interface NavListener {
        void onPreviousPage();
        void onNextPage();
    }
    
    private static final Binder binder = GWT.create(Binder.class);

    @UiField
    InnerNavBar innerNavBar;

    public NavBar() {
        initWidget(binder.createAndBindUi(this));
    }
    
    public void addNavListener(NavListener listener) {
        this.innerNavBar.addNavListener(listener); 
    }
    
    public void update(ClientSearchResultSet results) {
    	innerNavBar.update( results );
    }
}
