package org.eaglei.ui.gwt.search.results;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchRequest.DataSet;
import org.eaglei.search.provider.SearchRequest.TypeBinding;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class SidebarFilterPanel extends Composite implements SearchContext.SearchListener {

    public static class DatatypePropertyInfo {
        EIEntity property;
        String valueDefaultText;
    }
    
    static class InstitutionPropertyFilter extends AbstractInstitutionPropertyFilter {
    	
    	@Override
        protected void fetchInstitutionList() {
            SearchServiceRemoteAsync searchService = GWT.create(SearchServiceRemote.class);
            searchService.getInstitutions(new AsyncCallback<List<EIEntity>>() {
                
                @Override
                public void onSuccess(List<EIEntity> result) {
                    initInstitutionList(result);
                }
                
                @Override
                public void onFailure(Throwable caught) {
                }
            });
        }

    }

    static class DatatypePropertyFilter extends PropertyFilter {

        private EIURI propertyURI;
        private TextBox valueTextBox;
        private String defaultText;

        DatatypePropertyFilter(String label, EIURI propertyURI, final String defaultText) {
            super(label);
            this.propertyURI = propertyURI;
            this.defaultText = defaultText;
            valueTextBox = new TextBox();
            add(valueTextBox);
            valueTextBox.setStyleName("valueText");
            valueTextBox.addStyleName("value");

            valueTextBox.setText(defaultText);
            valueTextBox.addStyleDependentName("default");
            valueTextBox.addFocusHandler(new FocusHandler() {
                public void onFocus(FocusEvent event) {
                    if (defaultText.equals(valueTextBox.getText())) {
                        setText("");
                    }
                }
            });
            
            valueTextBox.addKeyUpHandler(new KeyUpHandler() {
                public void onKeyUp(KeyUpEvent event) {
                    if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
                        executeSearch();
                    }
                }
            });
        }

        public void setText(String text) {
            valueTextBox.setText(text);
            valueTextBox.removeStyleDependentName("default");
        }

        EIURI getPropertyURI() {
            return this.propertyURI;
        }

        String getValue() {
            String text = valueTextBox.getText().trim();
            if (text.equals(defaultText)) {
                return "";
            } else {
                return text;
            }
        }
        
        private void executeSearch() {
            SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
            SearchRequest newRequest;
            if (previousRequest != null) {
                // TODO: somewhat inefficient way to create a clone
                newRequest = new SearchRequest(previousRequest.toURLParams());
                newRequest.setStartIndex(0);
            } else {
                newRequest = new SearchRequest();
            }
            TypeBinding binding = newRequest.getBinding();
            if (binding == null) {
                // assert?
                return;
            }
            addProperty(binding);
            SearchContext.INSTANCE.search(newRequest);
        }
        
        void addProperty(TypeBinding binding) {
            EIURI propURI = getPropertyURI();
            // Currently don't support multiple values,
            // so wack any previous value
            binding.getDataTypeProperties().remove(propURI);
            String value = getValue();
            if (value.length() > 0) {
                binding.addDataTypeProperty(propURI, value);
            }
        }
    }

    /*
    static class TypePropertyFilter extends PropertyFilter {

        private final TypeChooser<OntologyDropdown> subTypeChooser;
        private EIClass currentRootClass;

        TypePropertyFilter() {
            super("Type:");
            subTypeChooser = new TypeChooser<OntologyDropdown>(new OntologyDropdown());
            subTypeChooser.setTextBoxStyle("formText");
            add(subTypeChooser);

            // Initialize to null
            currentRootClass = null;
            subTypeChooser.setClass(currentRootClass, false);
        }

        private void setClass(EIClass rootTypeClass, EIEntity selectedTypeEntity) {
            if ((currentRootClass == null && rootTypeClass != null)
                    || (currentRootClass != null && !currentRootClass.equals(rootTypeClass))) {
                // Handle change in root class
                subTypeChooser.setClass(rootTypeClass, false);
                currentRootClass = rootTypeClass;
            }

            // Handle selected type
            if (rootTypeClass != null && selectedTypeEntity != null
                    && rootTypeClass.getEntity().getURI().equals(selectedTypeEntity.getURI())) {
                // If selected entity is same as root class,
                // treat it as a null value.
                subTypeChooser.setSelectedEntity(null);
            } else {
                subTypeChooser.setSelectedEntity(selectedTypeEntity);
            }
        }

        private EIURI getSelectedType() {
            return subTypeChooser.getSelectedURI();
        }
    }
    */

    interface Binder extends UiBinder<Widget, SidebarFilterPanel> {
    }

    //private static final Binder binder = GWT.create(Binder.class);

    //@UiField
    VerticalPanel filterListPanel = new VerticalPanel();

    private int typeFilterStartIndex;
    private EIClass currentRootClass;
    private SearchRequest currentRequest = null;

    public SidebarFilterPanel() {
        //initWidget(binder.createAndBindUi(this));
        initWidget(filterListPanel);
        setStyleName("filterSidebarComponent");

        typeFilterStartIndex = 0;
        
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            setSearchRequest(SearchContext.INSTANCE.getCurrentRequest());
        }
        
        SearchContext.INSTANCE.addListener(this);
    }

    public EIURI getResourceType() {
        return currentRootClass.getEntity().getURI();
    }

    private void setResourceType(final EIURI rootTypeURI, final EIEntity selectedTypeEntity) {
        if (rootTypeURI == null) {
            setResourceType((EIClass) null, selectedTypeEntity);
        } else {
            ClientModelManager.INSTANCE.getClass(rootTypeURI, new ClassCallback() {

                @Override
                public void onSuccess(EIClass result) {
                    // TODO do we need to worry about a new selection being
                    // made during async?
                    // Do we even need async? Can we assume the category
                    // class is already in cache?
                    setResourceType(result, selectedTypeEntity);
                }
            });
        }
    }

    private void setResourceType(EIClass rootTypeClass, EIEntity selectedTypeEntity) {
        //typeFilter.setClass(rootTypeClass, selectedTypeEntity);
        if ((currentRootClass == null && rootTypeClass != null)
                || (currentRootClass != null && !currentRootClass.equals(rootTypeClass))) {
            updateTypeFilters(rootTypeClass);
        }
        currentRootClass = rootTypeClass;
    }

    private static Map<EIURI, List<DatatypePropertyInfo>> FILTER_PROPERTY_MAP = null;

    private void updateTypeFilters(EIClass rootTypeClass) {
        for (int i = filterListPanel.getWidgetCount() - 1; i >= typeFilterStartIndex; i--) {
            filterListPanel.remove(i);
        }

        if (rootTypeClass == null) {
            // Currently no extra filter props for All Resources
            return;
        }

        if (FILTER_PROPERTY_MAP == null) {
            // Only initialize the map when first needed.
            initFilterMap();
        }

        List<DatatypePropertyInfo> propEntityList = FILTER_PROPERTY_MAP.get(rootTypeClass
                .getEntity().getURI());
        if (propEntityList != null) {
            for (DatatypePropertyInfo pInfo : propEntityList) {
                filterListPanel.add(new DatatypePropertyFilter(pInfo.property.getLabel(),
                        pInfo.property.getURI(), pInfo.valueDefaultText));
            }
        }
    }

    private void initFilterMap() {
        ArrayList<DatatypePropertyInfo> propInfoList;
        FILTER_PROPERTY_MAP = new HashMap<EIURI, List<DatatypePropertyInfo>>();

        DatatypePropertyInfo propInfo;
        EIEntity locationProperty = EIEntity.create(EIURI
                .create("http://www.obofoundry.org/ro/ro.owl#located_in"), "Laboratory");
        DatatypePropertyInfo locationPropertyInfo = new DatatypePropertyInfo();
        locationPropertyInfo.property = locationProperty;
        locationPropertyInfo.valueDefaultText = "Laboratory Name";
        EIEntity manufacturerProperty = EIEntity.create(EIURI
                .create("http://purl.obolibrary.org/obo/ERO_0000034"), "Manufacturer");
        DatatypePropertyInfo manufacturerPropertyInfo = new DatatypePropertyInfo();
        manufacturerPropertyInfo.property = manufacturerProperty;
        manufacturerPropertyInfo.valueDefaultText = "Manufacturer Name";

        // Organism
        EIURI type = EIURI.create("http://purl.obolibrary.org/obo/OBI_0100026");
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        // Location
        propInfoList.add(locationPropertyInfo);
        // Disease Modeled
        /*
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create(EIURI
                .create("http://purl.obolibrary.org/obo/ERO_0000233"), "Models");
        propInfo.valueDefaultText = "Disease Name";
        propInfoList.add(propInfo);
        */
        FILTER_PROPERTY_MAP.put(type, propInfoList);

        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000006"); // Reagent
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfoList.add(locationPropertyInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);

        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000004"); // Instrument
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfoList.add(locationPropertyInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);

        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000005"); // Service
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create(
                EIURI.create("http://purl.obolibrary.org/obo/ERO_0000390"), "Laboratory");
        propInfo.valueDefaultText = "Laboratory Name";
        propInfoList.add(propInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);

        type = EIURI.create("http://purl.obolibrary.org/obo/OBI_0000272"); // Protocol
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create(
                EIURI.create("http://purl.obolibrary.org/obo/ERO_0000070"), "Laboratory");
        propInfo.valueDefaultText = "Laboratory Name";
        propInfoList.add(propInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);

        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000015"); // Human
                                                                           // Study
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create(
                EIURI.create("http://eagle-i.org/ont/data/human_study_performed_by"), "Laboratory");
        propInfo.valueDefaultText = "Laboratory Name";
        propInfoList.add(propInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);

        type = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000071"); // Software
        propInfoList = new ArrayList<DatatypePropertyInfo>();
        propInfo = new DatatypePropertyInfo();
        propInfo.property = EIEntity.create(EIURI
                .create("http://purl.obolibrary.org/obo/ERO_0000070"), "Laboratory");
        propInfo.valueDefaultText = "Laboratory Name";
        propInfoList.add(propInfo);
        propInfoList.add(manufacturerPropertyInfo);
        FILTER_PROPERTY_MAP.put(type, propInfoList);

    }

    @Override
    public void onFailure(SearchRequest request, String message) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (!isAttached()) {
            return;
        }
        
        // Write settings into the search request.
        // Set type filters
        TypeBinding binding = request.getBinding();
        if (binding != null) {
            if (binding.getDataTypeProperties() != null) {
                binding.getDataTypeProperties().clear();
            }
            // Check that the request binding type matches the type we are currently displaying
            if (currentRootClass != null && binding.getType().equals(currentRootClass.getEntity().getURI())) {
                for (int i = typeFilterStartIndex; i < filterListPanel.getWidgetCount(); i++) {
                    DatatypePropertyFilter propFilter = (DatatypePropertyFilter) filterListPanel
                            .getWidget(i);
                    propFilter.addProperty(binding);
                }
            }
        }
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        setSearchRequest(request);
    }
    
    @Override
    public void onResults(ClientSearchResultSet results) {
        setResourceType(results.getBindingCategoryURI(), results.getBindingEntity());
    }

    private void setSearchRequest(SearchRequest request) {
        // If the type category type has changed, then update filter panel controls.
        EIURI typeCategoryURI = (request != null && request.getBinding() != null) ? request.getBinding().getType() : null;
        // Display a null property value for type
        setResourceType(typeCategoryURI, null);
        currentRequest = request;
    }
    

}
