package org.eaglei.ui.gwt.search.results.grid;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;

public abstract class GridRow extends FlowPanel {
	protected final int RESOURCE_NAME_INDEX = 0;
	protected final int RESOURCE_SNIPPIT_INDEX = 1;
	protected Widget[] rowContentWidgets;
	private Widget resourceNameWidget;
	private Widget resourceDescriptionWidget;

	protected abstract int[] getDisplayOrder();
	
	protected void setContent(Widget[] widgets,int[] displayOrder) {
		clear();
		for (int index : displayOrder) {
			add( widgets[index] );
		}
	}

	protected void updateRowContent(Widget widget, int index) {
		rowContentWidgets[index] = resourceNameWidget;
		setContent( rowContentWidgets,getDisplayOrder() );
	}
	
	public void setResourceNameWidget(Widget resourceNameWidget) {
		this.resourceNameWidget = resourceNameWidget;
		updateRowContent( resourceNameWidget,RESOURCE_NAME_INDEX);
	}

	public void setResourceSnippitWidget(Widget resourceDescriptionWidget) {
		this.resourceDescriptionWidget = resourceDescriptionWidget;
		updateRowContent( resourceDescriptionWidget, RESOURCE_SNIPPIT_INDEX );
	}
}
