/**
 * 
 */
package org.eaglei.ui.gwt.search.results.grid;

import com.google.gwt.user.client.ui.Widget;

/**
 * @author "Sravan Cheriyala"
 * Started Mar 16, 2011
 */
public class PubMedGridRow extends GridRow {

	private final int CONTENT_SIZE = 4;

	private final int RESOURCE_JOURNAL_LIST = 2;
	private final int RESOURCE_DATE = 3;

	private int[] displayOrder = { RESOURCE_NAME_INDEX, 
	 		                       RESOURCE_SNIPPIT_INDEX, 
		 		                   RESOURCE_JOURNAL_LIST, 
		 		                   RESOURCE_DATE, };
	
	private Widget resourceJournalWidget;
	private Widget resourceDateWidget;

	public PubMedGridRow(Widget[] widgets) {
		rowContentWidgets = widgets;
		setContent( rowContentWidgets,getDisplayOrder()  );
	}

	public PubMedGridRow() {
		rowContentWidgets = new Widget[CONTENT_SIZE];
	}


	public void setResourceJournalWidget(Widget resourceJournalWidget) {
		this.resourceJournalWidget = resourceJournalWidget;
		updateRowContent(resourceJournalWidget,RESOURCE_JOURNAL_LIST);
	}

	public void setResourceDateWidget(Widget resourceDateWidget) {
		this.resourceDateWidget = resourceDateWidget;
		updateRowContent(resourceJournalWidget,RESOURCE_DATE );
	}

	public int[] getDisplayOrder()
	{
		return displayOrder;
	}
	
}
