package org.eaglei.ui.gwt.search.results.grid;

import java.util.HashMap;
import java.util.Map;

import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchRequest.DataSet;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.results.renderers.DataSetRenderer;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.results.NavBar;

import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class ResourcesGrid extends FlexTable implements NavBar.NavListener {

	public static class CellPanel extends VerticalPanel {

		CellPanel() {
			setStyleName( "resultsTableCell" );
			setSpacing( 0 );
		}

		void setContent(Widget primary, Widget secondary) {
			clear();
			add( primary );
			primary.addStyleName( "primary" );
			if ( secondary != null ) {
				add( secondary );
				secondary.setStyleName( "secondary" );
			}
		}
	}
	
	



	private static final int PAGE_SIZE = SearchRequest.DEFAULT_PAGE_SIZE;
	// private static final int NAV_BAR_ROW = 0;
	private static final int HEADER_ROW = 0;
	private static final int STATUS_ROW = 1;
	private static final int PROGRESS_ROW = 2;
	private static final int FIRST_RESULT_ROW = 3;

	private final Map<DataSet, DataSetRenderer> mapDSToRenderer = new HashMap<DataSet, DataSetRenderer>();;
	public ClientSearchResultSet currentResults;
	private DataSetRenderer currentRenderer;
	private final NavBar navBar;
	private Label status;

	@UiConstructor
	public ResourcesGrid(NavBar navBar) {
		// Header columns
		setStyleName( "listGrid" );
		this.navBar = navBar;
		navBar.addNavListener( this );
		status = new Label();
		
	//	addRow(GridRow.STATUS_ROW);
	//	addRow(GridRow.PROGRESS_ROW);
		setWidget( STATUS_ROW, 0, status );
		setWidget( PROGRESS_ROW, 0, new Image( ApplicationResources.INSTANCE.loading() ) );
	}

	
	
	public ClientSearchResultSet getCurrentResults() {
		return this.currentResults;
	}

	public void addRenderer(DataSetRenderer renderer) {
		this.mapDSToRenderer.put( renderer.getDataset(), renderer );
	}

	public void displaySearchPending() {
		currentResults = null;
		RowFormatter rf = getRowFormatter();
		navBar.setVisible( false );
		rf.setVisible( STATUS_ROW, false );
		rf.setVisible( PROGRESS_ROW, true );
		for (int i = getRowCount() - 1; i >= FIRST_RESULT_ROW; i--) {
			removeRow( i );
		}
	}

	public void displayStatusMessage(String message) {
		status.setText( message );
		currentResults = null;
		RowFormatter rf = getRowFormatter();
		navBar.setVisible( false );
		rf.setVisible( STATUS_ROW, true );
		rf.setVisible( PROGRESS_ROW, false );
		for (int i = getRowCount() - 1; i >= FIRST_RESULT_ROW; i--) {
			removeRow( i );
		}
	}


	public void addRow(GridRow row) {
		add( row );
	}

	public void displaySearchResults(ClientSearchResultSet results) {
		if ( results.getResultSet().getResults().size() == 0 ) {
			displayStatusMessage( "No results found." );
			return;
		}

		RowFormatter rf = getRowFormatter();

		if ( currentRenderer == null || currentRenderer.getDataset() != results.getResultSet().getRequest().getDataset() ) {
			currentRenderer = mapDSToRenderer.get( results.getResultSet().getRequest().getDataset() );
		
		}

		currentResults = results;
		rf.setVisible( PROGRESS_ROW, false );

		// Update the nav bar.
		navBar.update( results );
		navBar.setVisible( true );

		// Add the results
		rf.setVisible( STATUS_ROW, false );
		int row = FIRST_RESULT_ROW;
		DataSet dataset = results.getResultSet().getRequest().getDataset();
		for (SearchResult result : results.getResultSet().getResults()) {
			currentRenderer.createInstanceRow( row++, dataset, result );
		}

	}

	@Override
	public void onPreviousPage() {
		// Move back a page.
		int startIndex = currentResults.getResultSet().getStartIndex() - PAGE_SIZE;
		assert ( startIndex >= 0 ) : "paged beyond the start of the result list";
		executeNewPageSearch( startIndex );
	}

	@Override
	public void onNextPage() {
		// Move forward a page.
		int startIndex = currentResults.getResultSet().getStartIndex() + PAGE_SIZE;
		assert ( startIndex < currentResults.getResultSet().getTotalCount() ) : "paged beyond the end of the result list";
		executeNewPageSearch( startIndex );
	}

	private void executeNewPageSearch(int startIndex) {
		SearchRequest newRequest = new SearchRequest(currentResults.getResultSet().getRequest().toURLParams());
		newRequest.setStartIndex( startIndex );
		SearchContext.INSTANCE.search( newRequest );
	}

}
