/**
 * 
 */
package org.eaglei.ui.gwt.search.results.renderers;

import java.util.Set;

import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchRequest.DataSet;
import org.eaglei.ui.gwt.SearchApplicationContext;
import org.eaglei.ui.gwt.search.results.grid.ResourcesGrid;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author "Sravan Cheriyala" 
 * Started Mar 16, 2011
 */
public abstract class DataSetRenderer {

	protected DataSet dataset;
	protected ResourcesGrid resultsTable;

	public abstract void createInstanceRow(int row, DataSet dataset, SearchResult searchResult);

	public DataSet getDataset() {
		return this.dataset;
	}

	
	protected  Widget getResourceNameLink(SearchResult searchResult) {
		// Name cell
		Widget instanceLink;
		if ( dataset == DataSet.EI_RESOURCES ) {
			instanceLink = new Hyperlink( searchResult.getEntity().getLabel(), SearchApplicationContext.INSTANCE_PAGE_TOKEN + "uri=" + searchResult.getEntity().getURI().toString() );
		} else {
			instanceLink = new Anchor( searchResult.getEntity().getLabel(), searchResult.getEntity().getURI().toString() );
			( (Anchor)instanceLink ).setTarget( "_blank" ); // display in new tab
		}
		return instanceLink;
	}

	protected Widget getSnippit(SearchResult searchResult) {
		HTML snippit = new HTML();
		if ( searchResult.getHighlight() != null ) {
			snippit = new HTML( searchResult.getHighlight() );
			return snippit;
		} else {
			return snippit;
		}

	}
	protected FlowPanel makeLabelFromSet(Set<String> labelSet) {

		FlowPanel organismPanel = new FlowPanel();

		for (String organism : labelSet) {
			Label orgLabel = new Label( organism );
			organismPanel.add( orgLabel );
			break;
		}
		return organismPanel;
	}

}
