/**
 * 
 */
package org.eaglei.ui.gwt.search.results.renderers;

import java.util.Set;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchRequest.DataSet;
import org.eaglei.ui.gwt.search.results.grid.EagleIGridRow;
import org.eaglei.ui.gwt.search.results.grid.EtrezGeneGridRow;
import org.eaglei.ui.gwt.search.results.grid.ResourcesGrid;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author "Sravan Cheriyala" Started Mar 16, 2011
 */
public class EtrezGeneDataSetRenderer extends DataSetRenderer {

	private static final EIURI ORGANISM_URI = EIURI.create( "organism" );
	private static final EIURI AKA_URI = EIURI.create( "aka" );

	public EtrezGeneDataSetRenderer(ResourcesGrid resultsTable, DataSet dataset) {
		this.resultsTable = resultsTable;
		this.dataset = dataset;
	}

	@Override
	public void createInstanceRow(int row, DataSet dataset, SearchResult searchResult) {
		int col = 0;

		// Name cell
		Widget instanceLink = getResourceNameLink( searchResult );
		HTML snippit = (HTML)getSnippit( searchResult );

		// Organism cell
		Set<String> organismList = searchResult.getDataTypeProperty( ORGANISM_URI );
		FlowPanel organismPanel = makeLabelFromSet( organismList );

		// aka cell
		Set<String> akaList = searchResult.getDataTypeProperty( AKA_URI );
		FlowPanel akaPanel = makeLabelFromSet( akaList );

		EtrezGeneGridRow gridRow = new EtrezGeneGridRow();
		gridRow.setResourceNameWidget( instanceLink );
		gridRow.setResourceSnippitWidget( snippit );
		gridRow.setResourceOrganismWidget( organismPanel );
		gridRow.setResourceAkaWidget( akaPanel );

		resultsTable.addRow( gridRow );

	}

}
