/**
 * 
 */
package org.eaglei.ui.gwt.search.results.renderers;

import java.util.Set;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchRequest.DataSet;
import org.eaglei.ui.gwt.search.results.grid.NIFGridRow;
import org.eaglei.ui.gwt.search.results.grid.PubMedGridRow;
import org.eaglei.ui.gwt.search.results.grid.ResourcesGrid;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author "Sravan Cheriyala" Started Mar 16, 2011
 */
public class PubMedDataSetRenderer extends DataSetRenderer {

	private static final EIURI JOURNAL_URI = EIURI.create( "journal" );
	private static final EIURI DATE_URI = EIURI.create( "date" );

	public PubMedDataSetRenderer(ResourcesGrid resultsTable, DataSet dataset) {
		this.resultsTable = resultsTable;
		this.dataset = dataset;
	}

	@Override
	public void createInstanceRow(int row, DataSet dataset, SearchResult searchResult) {
		int col = 0;

		// Name cell
		Widget instanceLink = getResourceNameLink( searchResult );
		HTML snippit = (HTML)getSnippit( searchResult );

		// Journal cell
		Set<String> journalList = searchResult.getDataTypeProperty( JOURNAL_URI );
		FlowPanel journalPanel = makeLabelFromSet( journalList );

		// Date cell
		Set<String> dateList = searchResult.getDataTypeProperty( DATE_URI );
		FlowPanel datePanel = makeLabelFromSet( dateList );

		PubMedGridRow gridRow = new PubMedGridRow();
		gridRow.setResourceNameWidget( instanceLink );
		gridRow.setResourceSnippitWidget( snippit );
		gridRow.setResourceJournalWidget( journalPanel );
		gridRow.setResourceDateWidget( datePanel );

		resultsTable.addRow( gridRow );

	}

}
