package org.eaglei.ui.gwt.search.rpc;

import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.rpc.LoggedException;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("search")
public interface SearchServiceRemote extends RemoteService {

    List<EIEntity> getInstitutions() throws InvalidSessionIdException, LoggedException;
    
    /**
     * Executes the specified search request and returns a SearchResultSet.
     * 
     * @param sessionId
     * @param request The search request.
     * @return Set of search results. Will be empty before init has been called.
     */
    // Should sessionId be part of SearchRequest?
    ClientSearchResultSet search(String sessionId, SearchRequest request) throws InvalidSessionIdException, LoggedException;
 
    SearchCounts count(String sessionId, SearchCountRequest request) throws InvalidSessionIdException, LoggedException;

    ClassCountResult getResourceCounts(String sessionId, SearchRequest request) throws InvalidSessionIdException, LoggedException;

    ClassCountResult getProviderTypeCounts(String sessionId, SearchRequest request) throws InvalidSessionIdException, LoggedException;

    List<EIClass> getTopLevelSearchCategories() throws LoggedException;

}
