package org.eaglei.ui.gwt.search.sidebar;

import java.util.List;
import java.util.SortedSet;
import java.util.logging.Logger;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.CountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchRequest.TypeBinding;
import org.eaglei.ui.gwt.search.SearchContext;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Panel;

public abstract class AbstractClassCountNavigatorPanel extends AbstractCountNavigatorPanel {

	protected SearchRequest currentRequest;
	
	private static final String outerStyleName = "resourceList";
	private static final String ALL_RESOURCES_STYLE = "allResources";
	private static final String ALL_RESOURCES_SELECTED_STYLE = "allResourcesSelected";
	private static final String DEFAULT_RESOURCE_STYLE = "resourceWrapper";
	private static final String TOP_RESOURCE_STYLE = "topResource";
	private static final String DEFAULT_RESOURCE_LINK_STYLE = "resourceTitle";
	private static final String TOP_RESOURCE_LINK_STYLE = "topResourceTitle";

	private static final Logger log = Logger.getLogger( "AbstractClassCountNavigatorPanel" );
	
	protected AbstractClassCountNavigatorPanel() {
		super();
	}

	public void setClassCountResult(ClassCountResult result) {
		currentRequest = result.getSearchRequest();
		displayResult( result );
	}

	private void displayResult(ClassCountResult c) {
		log.finer( "displaying new result" );
		outer.clear();
		outer.setStyleName( outerStyleName );

		Panel allPanel = null;
		// The All label
		allPanel = addDiv( outer, "" );
		allPanel.setStyleName( ALL_RESOURCES_STYLE );
		if (c.getEntity() == null) {
			addLabel( allPanel, getAllLinkLabel(), ALL_RESOURCES_SELECTED_STYLE );
		} else {
			addLink( allPanel, getAllLinkLabel(), null, "link", false, false );
		}
		
		Panel latestPanel = outer;
		String divStyleName = TOP_RESOURCE_STYLE;
		String linkStyleName = TOP_RESOURCE_LINK_STYLE;
		// Super class list
		List<CountResult> superClassCounts = c.getSuperClassCounts();
		if ( superClassCounts != null && superClassCounts.size() > 0 ) {
			for (CountResult superClass : superClassCounts) {
				// Supers
				Panel newDiv = addDiv( latestPanel, divStyleName );
				addAncestorLink( newDiv, linkStyleName, divStyleName, superClass );
				latestPanel = newDiv;
				divStyleName = DEFAULT_RESOURCE_STYLE;
				linkStyleName = DEFAULT_RESOURCE_LINK_STYLE;
			}
		} 
		// The target class
		if ( c.getEntity() != null ) {
			Panel newDiv = addDiv( latestPanel, divStyleName );
			addLink( newDiv, c.getClassCount(), linkStyleName, divStyleName, true );
			latestPanel = newDiv;
			divStyleName = DEFAULT_RESOURCE_STYLE;
			linkStyleName = DEFAULT_RESOURCE_LINK_STYLE;
		}
		// Sub class list
		SortedSet<CountResult> subClassCounts = c.getSubClassCounts();
		if ( subClassCounts != null && subClassCounts.size() > 0 ) {
			Panel newDiv = addDiv( latestPanel, divStyleName );
			latestPanel = newDiv;
			for (CountResult child : subClassCounts) {
				addSubClassLink( latestPanel, linkStyleName, divStyleName, child ); // or is this the defaults?
			}
		}
	}

	@Override
	protected void onEntityClick(final EIURI typeBindingURI) {
		SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
		SearchRequest newRequest;
		if ( previousRequest != null ) {
			// TODO: somewhat inefficient way to create a clone
			newRequest = new SearchRequest( previousRequest.toURLParams() );
			newRequest.setStartIndex( 0 );
		} else {
			newRequest = new SearchRequest();
		}
		// Clears any current property filters
		if ( typeBindingURI == null ) {
			newRequest.setBinding( null );
		} else {
			newRequest.setBinding( new TypeBinding( typeBindingURI ) );
		}
		SearchContext.INSTANCE.search( newRequest );
	}

	private Panel addDiv(Panel container, String styleName) {
		FlowPanel newDiv = new FlowPanel();
		newDiv.setStyleName( styleName );
		container.add( newDiv );
		return newDiv;
	}
}
