package org.eaglei.ui.gwt.search.sidebar;

import java.util.List;
import java.util.SortedSet;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntConstants;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.CountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchRequest.ResourceProvider;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.UIConstants;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.SearchContext.SearchListener;
import org.eaglei.ui.gwt.search.results.AbstractInstitutionPropertyFilter;
import org.eaglei.ui.gwt.search.results.PropertyFilter;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.suggest.DataSuggestBox;
import org.eaglei.ui.gwt.suggest.DataSuggestOracle;
import org.eaglei.ui.gwt.suggest.AbstractSearchBox.SearchHandler;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;

public class ResourceProviderSidebarComponent extends AbstractSidebarComponent implements SearchListener {
    
    class InstitutionFilter extends AbstractInstitutionPropertyFilter {

        InstitutionFilter() {
            super(null);
        }
        
        protected String getDefaultItem() {
            return "All Institutions";
        }
        
    	@Override
        protected void fetchInstitutionList() {
            SearchServiceRemoteAsync searchService = GWT.create(SearchServiceRemote.class);
            searchService.getInstitutions(new AsyncCallback<List<EIEntity>>() {
                
                @Override
                public void onSuccess(List<EIEntity> result) {
                    initInstitutionList(result);
                }
                
                @Override
                public void onFailure(Throwable caught) {
                }
            });
        }

    }
    
    class ProviderTypeFilter extends PropertyFilter {

        protected final VerticalPanel outer = new VerticalPanel();
        private Image loadingImage = new Image(ApplicationResources.INSTANCE.loadingSmall());
        //private Map<EIEntity,CheckBox> mapEntityToCheckBox = new HashMap<EIEntity,CheckBox>();

        protected ProviderTypeFilter() {
            super(null);
            add(outer);
        }
        
        public void setClassCountResult(ClassCountResult c) {
            outer.clear();
            //mapEntityToCheckBox.clear();
            EIURI providerType = c.getSearchRequest().getProviderType();
            for (CountResult r : c.getSubClassCounts()) {
            	final EIEntity entity = r.getEntity();
            	CheckBox checkBox = new CheckBox(UIConstants.topLevelOrganizationTypePlurals.get( entity.getLabel() ) + " (" + r.getCount() + ")");
            	checkBox.setValue(entity.getURI().equals(providerType), false);
            	checkBox.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
					@Override
					public void onValueChange(ValueChangeEvent<Boolean> event) {
						//for (EIEntity e : mapEntityToCheckBox.keySet()) {
						//	if (!e.equals(entity)) {
						//		mapEntityToCheckBox.get(e).setValue(false, false);
						//	}
						//}
						executeSearch(event.getValue() ? entity : null);
					}
				});
            	//mapEntityToCheckBox.put(entity, checkBox);
            	outer.add(checkBox);
            }
        }
        
        public void setRequestPending() {
            outer.clear();
            outer.add(loadingImage);
        }
        
        private void executeSearch(EIEntity providerEntity) {
            SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
            SearchRequest newRequest;
            if (previousRequest != null) {
                // TODO: somewhat inefficient way to create a clone
                newRequest = new SearchRequest(previousRequest.toURLParams());
                newRequest.setStartIndex(0);
            } else {
                newRequest = new SearchRequest();
            }
            newRequest.setProviderType(providerEntity!=null?providerEntity.getURI():null);
            newRequest.setProviderTypeLabel(providerEntity!=null?providerEntity.getLabel():null);
            SearchContext.INSTANCE.search(newRequest);
        }
        
    }

    static class LaboratorySuggestBox extends DataSuggestBox {

		public LaboratorySuggestBox(DataSuggestOracle oracle) {
			super(oracle);
		}
    	
		@Override
		public String getDefaultText() {
	        return "Resource Location Name";
		}

    }
    
    /*
    class LaboratoryFilter extends PropertyFilter {

        private DataSuggestOracle suggestOracle;
        private LaboratorySuggestBox suggestBox;
        //private EIURI currentInstitution;
        private EIURI currentLaboratory;
        
        LaboratoryFilter() {
            //super("Laboratory");
            super(null);
            
            CheckBox c;
            c = new CheckBox("Center");
            add(c);
            c.setStyleName("sidebarCheckbox");
            c = new CheckBox("Core Laboratory");
            add(c);
            c.setStyleName("sidebarCheckbox");
            c = new CheckBox("Technology Transfer Office");
            add(c);
            c.setStyleName("sidebarCheckbox");
            
            suggestOracle = new DataSuggestOracle();
            suggestBox = new LaboratorySuggestBox(suggestOracle);
            add(suggestBox);
            
        	suggestOracle.setClass(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000001"));
        	suggestOracle.setProperty(EIOntConstants.PG_RELATED_RESOURCE_PROVIDER);
        	suggestBox.addSearchHandler(new SearchHandler() {

				@Override
				public void performSearch(String query, String uri) {
                    if (uri == null) {
                        currentLaboratory = null;
                        suggestBox.setDefaultText();
                    } else {
                        currentLaboratory = EIURI.create(uri);
                    }
		            SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
		            SearchRequest newRequest;
		            if (previousRequest != null) {
		                // TODO: somewhat inefficient way to create a clone
		                newRequest = new SearchRequest(previousRequest.toURLParams());
		                newRequest.setStartIndex(0);
		            } else {
		                newRequest = new SearchRequest();
		            }
		            onRequestCreate(newRequest);
		            SearchContext.INSTANCE.search(newRequest);
				}
        		
        	}, true, true);
        }
        
        public void setSearchRequest(SearchRequest request) {
        	//currentInstitution = request.getLocation().getInstitution();
        	//suggestOracle.setResourceProviderInstitution(currentInstitution);
        	if (request.getProvider() == null || request.getProvider().getURI() == null) {
        		suggestBox.setDefaultText();
        	} else {
        		// TODO probably should look up lab name, check if it's set
        	}
        }
        
        public void onRequestCreate(SearchRequest request) {
            if (currentLaboratory == null) {
                request.setProvider(null);
            } else {
                request.setProvider(new ResourceProvider(currentLaboratory, null, null));
            }
        }
    }
    */

    private InstitutionFilter institutionFilter;
    private ProviderTypeFilter providerTypeFilter;
    //private LaboratoryFilter laboratoryFilter;
	//private SearchRequest currentRequest;
    private ClassCountResult currentCountResult = null;

    public ResourceProviderSidebarComponent() {
        super("Resource Location");
        if (!ApplicationContext.IS_INSTITUTION) {
        	institutionFilter = new InstitutionFilter();
        	main.add(institutionFilter);
        }
        //laboratoryFilter = new LaboratoryFilter();
        //main.add(laboratoryFilter);
        
        providerTypeFilter = new ProviderTypeFilter();
        main.add(providerTypeFilter);
        
        SearchContext.INSTANCE.addListener(this);
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            onRequestPending(SearchContext.INSTANCE.getCurrentRequest(), false);
        }
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            onResults(SearchContext.INSTANCE.getCurrentResults());
        }       
    }
    
    public void setInstitutions(SortedSet<EIEntity> institutions) {
        
    }
    
    public void setSearchRequest(SearchRequest request) {
        //currentRequest = request;
    	if (institutionFilter != null) {
    		institutionFilter.setSearchRequest(request);
    	}
        //laboratoryFilter.setSearchRequest(request);
    }
    
    public void setRequestPending() {
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (!isAttached()) {
            return;
        }
        //laboratoryFilter.onRequestCreate(request);
        //if (institutionFilter != null) {
        //	institutionFilter.onRequestCreate(request);
        //}
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        setSearchRequest(request);
        getProviderTypeCounts(request);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        setSearchRequest(results.getResultSet().getRequest());
        if (currentCountResult != null) {
            // The count response arrived before the result set.
            if (!results.getResultSet().getRequest().equals(currentCountResult.getSearchRequest())) {
                // Unexpected. Cached counts request doesn't match result set request.
                // Maybe a new result set is about to arrive?
                return;
            }
        	providerTypeFilter.setClassCountResult(currentCountResult);
        }
    }

    
    private void getProviderTypeCounts(final SearchRequest searchRequest) {
    	providerTypeFilter.setRequestPending();
        if (searchRequest == null) {
            return;
        }
        if (searchRequest.getDataset() != SearchRequest.DataSet.EI_RESOURCES) {
            return;
        }
        // Putting in deferred command to ensure that the result list request
        // gets executed first.  And the UI has a chance to go to display progress.
        Scheduler.get().scheduleDeferred( new ScheduledCommand() {
            @Override
            public void execute() {
                SearchContext.searchService.getProviderTypeCounts(SessionContext.getSessionId(), searchRequest,
                        new AsyncCallback<ClassCountResult>() {

                            public void onFailure(Throwable caught) {
                                if (caught instanceof InvalidSessionIdException) {
                                    SessionContext.INSTANCE.logOut();
                                    return;
                                }
                            }

                            public void onSuccess(ClassCountResult result) {
                                if (SearchContext.INSTANCE.getCurrentRequest() == null
                                        || !SearchContext.INSTANCE.getCurrentRequest().equals(
                                                result.getSearchRequest())) {
                                    // Old request. no-op.
                                    return;
                                }
                                // Stash the current count response
                                currentCountResult = result;
                                if (SearchContext.INSTANCE.getCurrentResults() != null) {
                                	providerTypeFilter.setClassCountResult(currentCountResult);
                                }
                            }

                        });
            }
            
        });
    }

}
