package org.eaglei.ui.gwt.security.rpc;


import java.util.List;

import org.eaglei.model.EIEntity;
import org.eaglei.security.Session;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.rpc.LoggedException;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("security")
public interface SecurityServiceRemote extends RemoteService {

    List<EIEntity> getInstitutions() throws InvalidSessionIdException, LoggedException;
    
    Session logIn(String institutionId, String username, String password) throws LoggedException;

    void logOut(String sessionId);

    Session getSession(String sessionId);
}
