/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.io.nio.SslConnection;
import org.eclipse.jetty.npn.NextProtoNego;
import org.eclipse.jetty.spdy.AsyncConnectionFactory;
import org.eclipse.jetty.spdy.ByteBufferPool;
import org.eclipse.jetty.spdy.Controller;
import org.eclipse.jetty.spdy.EmptyAsyncConnection;
import org.eclipse.jetty.spdy.IdleListener;
import org.eclipse.jetty.spdy.Promise;
import org.eclipse.jetty.spdy.SPDYAsyncConnection;
import org.eclipse.jetty.spdy.StandardByteBufferPool;
import org.eclipse.jetty.spdy.StandardCompressionFactory;
import org.eclipse.jetty.spdy.StandardSession;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.SessionFrameListener;
import org.eclipse.jetty.spdy.generator.Generator;
import org.eclipse.jetty.spdy.parser.Parser;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class SPDYClient {
    private final Map<String, AsyncConnectionFactory> factories = new ConcurrentHashMap<String, AsyncConnectionFactory>();
    private final short version;
    private final Factory factory;
    private SocketAddress bindAddress;
    private long maxIdleTime;

    protected SPDYClient(short version, Factory factory) {
        this.version = version;
        this.factory = factory;
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public Future<Session> connect(InetSocketAddress address, SessionFrameListener listener) throws IOException {
        if (!this.factory.isStarted()) {
            throw new IllegalStateException(Factory.class.getSimpleName() + " is not started");
        }
        SocketChannel channel = SocketChannel.open();
        if (this.bindAddress != null) {
            channel.bind(this.bindAddress);
        }
        channel.socket().setTcpNoDelay(true);
        channel.configureBlocking(false);
        SessionPromise result = new SessionPromise(this, listener);
        channel.connect(address);
        this.factory.selector.register(channel, (Object)result);
        return result;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    protected String selectProtocol(List<String> serverProtocols) {
        if (serverProtocols == null) {
            return "spdy/2";
        }
        for (String serverProtocol : serverProtocols) {
            for (String protocol : this.factories.keySet()) {
                if (!serverProtocol.equals(protocol)) continue;
                return protocol;
            }
            String protocol = this.factory.selectProtocol(serverProtocols);
            if (protocol == null) continue;
            return protocol;
        }
        return null;
    }

    public AsyncConnectionFactory getAsyncConnectionFactory(String protocol) {
        for (Map.Entry<String, AsyncConnectionFactory> entry : this.factories.entrySet()) {
            if (!protocol.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        for (Map.Entry<String, AsyncConnectionFactory> entry : this.factory.factories.entrySet()) {
            if (!protocol.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public void putAsyncConnectionFactory(String protocol, AsyncConnectionFactory factory) {
        this.factories.put(protocol, factory);
    }

    public AsyncConnectionFactory removeAsyncConnectionFactory(String protocol) {
        return this.factories.remove(protocol);
    }

    protected SSLEngine newSSLEngine(SslContextFactory sslContextFactory, SocketChannel channel) {
        String peerHost = channel.socket().getInetAddress().getHostAddress();
        int peerPort = channel.socket().getPort();
        SSLEngine engine = sslContextFactory.newSslEngine(peerHost, peerPort);
        engine.setUseClientMode(true);
        return engine;
    }

    private static class ClientSPDYAsyncConnectionFactory
    implements AsyncConnectionFactory {
        private ClientSPDYAsyncConnectionFactory() {
        }

        @Override
        public AsyncConnection newAsyncConnection(SocketChannel channel, AsyncEndPoint endPoint, Object attachment) {
            SessionPromise sessionPromise = (SessionPromise)((Object)attachment);
            Factory factory = sessionPromise.client.factory;
            StandardCompressionFactory compressionFactory = new StandardCompressionFactory();
            Parser parser = new Parser(compressionFactory.newDecompressor());
            Generator generator = new Generator(factory.bufferPool, compressionFactory.newCompressor());
            ClientSPDYAsyncConnection connection = new ClientSPDYAsyncConnection(endPoint, factory.bufferPool, parser, factory);
            endPoint.setConnection((Connection)connection);
            StandardSession session = new StandardSession(sessionPromise.client.version, factory.bufferPool, factory.threadPool, factory.scheduler, (Controller)connection, (IdleListener)connection, 1, sessionPromise.listener, generator);
            parser.addListener((Parser.Listener)session);
            sessionPromise.completed(session);
            connection.setSession((Session)session);
            factory.sessionOpened((Session)session);
            return connection;
        }

        private class ClientSPDYAsyncConnection
        extends SPDYAsyncConnection {
            private final Factory factory;

            public ClientSPDYAsyncConnection(AsyncEndPoint endPoint, ByteBufferPool bufferPool, Parser parser, Factory factory) {
                super(endPoint, bufferPool, parser);
                this.factory = factory;
            }

            @Override
            public void onClose() {
                super.onClose();
                this.factory.sessionClosed(this.getSession());
            }
        }
    }

    private static class SessionPromise
    extends Promise<Session> {
        private final SPDYClient client;
        private final SessionFrameListener listener;

        private SessionPromise(SPDYClient client, SessionFrameListener listener) {
            this.client = client;
            this.listener = listener;
        }
    }

    public static class Factory
    extends AggregateLifeCycle {
        private final Map<String, AsyncConnectionFactory> factories = new ConcurrentHashMap<String, AsyncConnectionFactory>();
        private final Queue<Session> sessions = new ConcurrentLinkedQueue<Session>();
        private final ByteBufferPool bufferPool = new StandardByteBufferPool();
        private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        private final Executor threadPool;
        private final SslContextFactory sslContextFactory;
        private final SelectorManager selector;

        public Factory() {
            this(null, null);
        }

        public Factory(SslContextFactory sslContextFactory) {
            this(null, sslContextFactory);
        }

        public Factory(Executor threadPool) {
            this(threadPool, null);
        }

        public Factory(Executor threadPool, SslContextFactory sslContextFactory) {
            if (threadPool == null) {
                threadPool = new QueuedThreadPool();
            }
            this.threadPool = threadPool;
            this.addBean(threadPool);
            this.sslContextFactory = sslContextFactory;
            if (sslContextFactory != null) {
                this.addBean(sslContextFactory);
            }
            this.selector = new ClientSelectorManager();
            this.addBean(this.selector);
            this.factories.put("spdy/2", new ClientSPDYAsyncConnectionFactory());
        }

        public SPDYClient newSPDYClient(short version) {
            return new SPDYClient(version, this);
        }

        protected void doStop() throws Exception {
            this.closeConnections();
            super.doStop();
        }

        protected String selectProtocol(List<String> serverProtocols) {
            for (String serverProtocol : serverProtocols) {
                for (String protocol : this.factories.keySet()) {
                    if (!serverProtocol.equals(protocol)) continue;
                    return protocol;
                }
            }
            return null;
        }

        private boolean sessionOpened(Session session) {
            return this.isRunning() && this.sessions.offer(session);
        }

        private boolean sessionClosed(Session session) {
            return this.isRunning() && this.sessions.remove(session);
        }

        private void closeConnections() {
            for (Session session : this.sessions) {
                session.goAway();
            }
            this.sessions.clear();
        }

        protected Collection<Session> getSessions() {
            return Collections.unmodifiableCollection(this.sessions);
        }

        private class ClientSelectorManager
        extends SelectorManager {
            private ClientSelectorManager() {
            }

            public boolean dispatch(Runnable task) {
                try {
                    Factory.this.threadPool.execute(task);
                    return true;
                }
                catch (RejectedExecutionException x) {
                    return false;
                }
            }

            protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
                SessionPromise attachment = (SessionPromise)((Object)key.attachment());
                long maxIdleTime = attachment.client.getMaxIdleTime();
                if (maxIdleTime < 0L) {
                    maxIdleTime = this.getMaxIdleTime();
                }
                SelectChannelEndPoint result = new SelectChannelEndPoint(channel, selectSet, key, (int)maxIdleTime);
                AsyncConnection connection = this.newConnection(channel, (AsyncEndPoint)result, (Object)attachment);
                result.setConnection((Connection)connection);
                return result;
            }

            protected void endPointOpened(SelectChannelEndPoint endpoint) {
            }

            protected void endPointUpgraded(ConnectedEndPoint endpoint, Connection oldConnection) {
            }

            protected void endPointClosed(SelectChannelEndPoint endpoint) {
                endpoint.getConnection().onClose();
            }

            public AsyncConnection newConnection(final SocketChannel channel, AsyncEndPoint endPoint, Object attachment) {
                SessionPromise sessionPromise = (SessionPromise)((Object)attachment);
                final SPDYClient client = sessionPromise.client;
                try {
                    if (Factory.this.sslContextFactory != null) {
                        final AtomicReference<AsyncEndPoint> sslEndPointRef = new AtomicReference<AsyncEndPoint>();
                        final AtomicReference<Object> attachmentRef = new AtomicReference<Object>(attachment);
                        SSLEngine engine = client.newSSLEngine(Factory.this.sslContextFactory, channel);
                        SslConnection sslConnection = new SslConnection(engine, (EndPoint)endPoint){

                            public void onClose() {
                                sslEndPointRef.set(null);
                                attachmentRef.set(null);
                                super.onClose();
                            }
                        };
                        endPoint.setConnection((Connection)sslConnection);
                        AsyncEndPoint sslEndPoint = sslConnection.getSslEndPoint();
                        sslEndPointRef.set(sslEndPoint);
                        NextProtoNego.put((SSLEngine)engine, (NextProtoNego.Provider)new NextProtoNego.ClientProvider(){

                            public boolean supports() {
                                return true;
                            }

                            public void unsupported() {
                                ClientSPDYAsyncConnectionFactory connectionFactory = new ClientSPDYAsyncConnectionFactory();
                                AsyncEndPoint sslEndPoint = (AsyncEndPoint)sslEndPointRef.get();
                                AsyncConnection connection = connectionFactory.newAsyncConnection(channel, sslEndPoint, attachmentRef.get());
                                sslEndPoint.setConnection((Connection)connection);
                            }

                            public String selectProtocol(List<String> protocols) {
                                String protocol = client.selectProtocol(protocols);
                                if (protocol == null) {
                                    return null;
                                }
                                AsyncConnectionFactory connectionFactory = client.getAsyncConnectionFactory(protocol);
                                AsyncEndPoint sslEndPoint = (AsyncEndPoint)sslEndPointRef.get();
                                AsyncConnection connection = connectionFactory.newAsyncConnection(channel, sslEndPoint, attachmentRef.get());
                                sslEndPoint.setConnection((Connection)connection);
                                return protocol;
                            }
                        });
                        EmptyAsyncConnection connection = new EmptyAsyncConnection(sslEndPoint);
                        sslEndPoint.setConnection((Connection)connection);
                        this.startHandshake(engine);
                        return sslConnection;
                    }
                    ClientSPDYAsyncConnectionFactory connectionFactory = new ClientSPDYAsyncConnectionFactory();
                    AsyncConnection connection = connectionFactory.newAsyncConnection(channel, endPoint, attachment);
                    endPoint.setConnection((Connection)connection);
                    return connection;
                }
                catch (RuntimeException x) {
                    sessionPromise.failed(x);
                    throw x;
                }
            }

            private void startHandshake(SSLEngine engine) {
                try {
                    engine.beginHandshake();
                }
                catch (SSLException x) {
                    throw new RuntimeException(x);
                }
            }
        }
    }
}

