/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

public class DigestAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(DigestAuthenticator.class);
    SecureRandom _random = new SecureRandom();
    private long _maxNonceAgeMs = 60000L;
    private ConcurrentMap<String, Nonce> _nonceCount = new ConcurrentHashMap<String, Nonce>();
    private Queue<Nonce> _nonceQueue = new ConcurrentLinkedQueue<Nonce>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        super.setConfiguration(configuration);
        String mna = configuration.getInitParameter("maxNonceAge");
        if (mna != null) {
            DigestAuthenticator digestAuthenticator = this;
            synchronized (digestAuthenticator) {
                this._maxNonceAgeMs = Long.valueOf(mna);
            }
        }
    }

    public synchronized void setMaxNonceAge(long maxNonceAgeInMillis) {
        this._maxNonceAgeMs = maxNonceAgeInMillis;
    }

    @Override
    public String getAuthMethod() {
        return "DIGEST";
    }

    @Override
    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }

    @Override
    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        if (!mandatory) {
            return this._deferred;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String credentials = request.getHeader("Authorization");
        try {
            boolean stale = false;
            if (credentials != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Credentials: " + credentials, new Object[0]);
                }
                QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(credentials, "=, ", true, false);
                Digest digest = new Digest(request.getMethod());
                String last = null;
                String name = null;
                block7: while (tokenizer.hasMoreTokens()) {
                    String tok = tokenizer.nextToken();
                    char c = tok.length() == 1 ? tok.charAt(0) : (char)'\u0000';
                    switch (c) {
                        case '=': {
                            name = last;
                            last = tok;
                            continue block7;
                        }
                        case ',': {
                            name = null;
                            continue block7;
                        }
                        case ' ': {
                            continue block7;
                        }
                    }
                    last = tok;
                    if (name == null) continue;
                    if ("username".equalsIgnoreCase(name)) {
                        digest.username = tok;
                    } else if ("realm".equalsIgnoreCase(name)) {
                        digest.realm = tok;
                    } else if ("nonce".equalsIgnoreCase(name)) {
                        digest.nonce = tok;
                    } else if ("nc".equalsIgnoreCase(name)) {
                        digest.nc = tok;
                    } else if ("cnonce".equalsIgnoreCase(name)) {
                        digest.cnonce = tok;
                    } else if ("qop".equalsIgnoreCase(name)) {
                        digest.qop = tok;
                    } else if ("uri".equalsIgnoreCase(name)) {
                        digest.uri = tok;
                    } else if ("response".equalsIgnoreCase(name)) {
                        digest.response = tok;
                    }
                    name = null;
                }
                int n = this.checkNonce(digest, (Request)request);
                if (n > 0) {
                    UserIdentity user = this._loginService.login(digest.username, (Object)digest);
                    if (user != null) {
                        this.renewSessionOnAuthentication(request, response);
                        return new UserAuthentication(this.getAuthMethod(), user);
                    }
                } else if (n == 0) {
                    stale = true;
                }
            }
            if (!DeferredAuthentication.isDeferred(response)) {
                String domain = request.getContextPath();
                if (domain == null) {
                    domain = "/";
                }
                response.setHeader("WWW-Authenticate", "Digest realm=\"" + this._loginService.getName() + "\", domain=\"" + domain + "\", nonce=\"" + this.newNonce((Request)request) + "\", algorithm=MD5, qop=\"auth\"," + " stale=" + stale);
                response.sendError(401);
                return Authentication.SEND_CONTINUE;
            }
            return Authentication.UNAUTHENTICATED;
        }
        catch (IOException e) {
            throw new ServerAuthException(e);
        }
    }

    public String newNonce(Request request) {
        byte[] nounce;
        Nonce nonce;
        do {
            nounce = new byte[24];
            this._random.nextBytes(nounce);
        } while (this._nonceCount.putIfAbsent(nonce._nonce, nonce = new Nonce(new String(B64Code.encode((byte[])nounce)), request.getTimeStamp())) != null);
        this._nonceQueue.add(nonce);
        return nonce._nonce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkNonce(Digest digest, Request request) {
        long expired;
        DigestAuthenticator digestAuthenticator = this;
        synchronized (digestAuthenticator) {
            expired = request.getTimeStamp() - this._maxNonceAgeMs;
        }
        Nonce nonce = this._nonceQueue.peek();
        while (nonce != null && nonce._ts < expired) {
            this._nonceQueue.remove(nonce);
            this._nonceCount.remove(nonce._nonce);
            nonce = this._nonceQueue.peek();
        }
        try {
            nonce = (Nonce)this._nonceCount.get(digest.nonce);
            if (nonce == null) {
                return 0;
            }
            long count = Long.parseLong(digest.nc, 16);
            if (count > Integer.MAX_VALUE) {
                return 0;
            }
            int old = nonce._nc.get();
            while (!nonce._nc.compareAndSet(old, (int)count)) {
                old = nonce._nc.get();
            }
            if (count <= (long)old) {
                return -1;
            }
            return 1;
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
            return -1;
        }
    }

    private static class Digest
    extends Credential {
        private static final long serialVersionUID = -2484639019549527724L;
        final String method;
        String username = "";
        String realm = "";
        String nonce = "";
        String nc = "";
        String cnonce = "";
        String qop = "";
        String uri = "";
        String response = "";

        Digest(String m) {
            this.method = m;
        }

        public boolean check(Object credentials) {
            if (credentials instanceof char[]) {
                credentials = new String((char[])credentials);
            }
            String password = credentials instanceof String ? (String)credentials : credentials.toString();
            try {
                byte[] ha1;
                MessageDigest md = MessageDigest.getInstance("MD5");
                if (credentials instanceof Credential.MD5) {
                    ha1 = ((Credential.MD5)credentials).getDigest();
                } else {
                    md.update(this.username.getBytes("ISO-8859-1"));
                    md.update((byte)58);
                    md.update(this.realm.getBytes("ISO-8859-1"));
                    md.update((byte)58);
                    md.update(password.getBytes("ISO-8859-1"));
                    ha1 = md.digest();
                }
                md.reset();
                md.update(this.method.getBytes("ISO-8859-1"));
                md.update((byte)58);
                md.update(this.uri.getBytes("ISO-8859-1"));
                byte[] ha2 = md.digest();
                md.update(TypeUtil.toString((byte[])ha1, (int)16).getBytes("ISO-8859-1"));
                md.update((byte)58);
                md.update(this.nonce.getBytes("ISO-8859-1"));
                md.update((byte)58);
                md.update(this.nc.getBytes("ISO-8859-1"));
                md.update((byte)58);
                md.update(this.cnonce.getBytes("ISO-8859-1"));
                md.update((byte)58);
                md.update(this.qop.getBytes("ISO-8859-1"));
                md.update((byte)58);
                md.update(TypeUtil.toString((byte[])ha2, (int)16).getBytes("ISO-8859-1"));
                byte[] digest = md.digest();
                return TypeUtil.toString((byte[])digest, (int)16).equalsIgnoreCase(this.response);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return false;
            }
        }

        public String toString() {
            return this.username + "," + this.response;
        }
    }

    private static class Nonce {
        final String _nonce;
        final long _ts;
        AtomicInteger _nc = new AtomicInteger();

        public Nonce(String nonce, long ts) {
            this._nonce = nonce;
            this._ts = ts;
        }
    }
}

