/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.nio.ByteBuffer;
import java.nio.channels.InterruptedByTimeoutException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.spdy.ByteBufferPool;
import org.eclipse.jetty.spdy.Controller;
import org.eclipse.jetty.spdy.ISession;
import org.eclipse.jetty.spdy.IStream;
import org.eclipse.jetty.spdy.IdleListener;
import org.eclipse.jetty.spdy.Promise;
import org.eclipse.jetty.spdy.SessionException;
import org.eclipse.jetty.spdy.StandardStream;
import org.eclipse.jetty.spdy.StreamException;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.GoAwayInfo;
import org.eclipse.jetty.spdy.api.Handler;
import org.eclipse.jetty.spdy.api.PingInfo;
import org.eclipse.jetty.spdy.api.RstInfo;
import org.eclipse.jetty.spdy.api.SPDYException;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.SessionFrameListener;
import org.eclipse.jetty.spdy.api.SessionStatus;
import org.eclipse.jetty.spdy.api.Settings;
import org.eclipse.jetty.spdy.api.SettingsInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.ControlFrameType;
import org.eclipse.jetty.spdy.frames.DataFrame;
import org.eclipse.jetty.spdy.frames.GoAwayFrame;
import org.eclipse.jetty.spdy.frames.HeadersFrame;
import org.eclipse.jetty.spdy.frames.PingFrame;
import org.eclipse.jetty.spdy.frames.RstStreamFrame;
import org.eclipse.jetty.spdy.frames.SettingsFrame;
import org.eclipse.jetty.spdy.frames.SynReplyFrame;
import org.eclipse.jetty.spdy.frames.SynStreamFrame;
import org.eclipse.jetty.spdy.frames.WindowUpdateFrame;
import org.eclipse.jetty.spdy.generator.Generator;
import org.eclipse.jetty.spdy.parser.Parser;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class StandardSession
implements ISession,
Parser.Listener,
Handler<FrameBytes> {
    private static final Logger logger = Log.getLogger(Session.class);
    private static final ThreadLocal<Integer> handlerInvocations = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private final List<Session.Listener> listeners = new CopyOnWriteArrayList<Session.Listener>();
    private final ConcurrentMap<Integer, IStream> streams = new ConcurrentHashMap<Integer, IStream>();
    private final LinkedList<FrameBytes> queue = new LinkedList();
    private final ByteBufferPool bufferPool;
    private final Executor threadPool;
    private final ScheduledExecutorService scheduler;
    private final short version;
    private final Controller<FrameBytes> controller;
    private final IdleListener idleListener;
    private final AtomicInteger streamIds;
    private final AtomicInteger pingIds;
    private final SessionFrameListener listener;
    private final Generator generator;
    private final AtomicBoolean goAwaySent = new AtomicBoolean();
    private final AtomicBoolean goAwayReceived = new AtomicBoolean();
    private final AtomicInteger lastStreamId = new AtomicInteger();
    private boolean flushing;
    private volatile int windowSize = 65536;

    public StandardSession(short version, ByteBufferPool bufferPool, Executor threadPool, ScheduledExecutorService scheduler, Controller<FrameBytes> controller, IdleListener idleListener, int initialStreamId, SessionFrameListener listener, Generator generator) {
        this.version = version;
        this.bufferPool = bufferPool;
        this.threadPool = threadPool;
        this.scheduler = scheduler;
        this.controller = controller;
        this.idleListener = idleListener;
        this.streamIds = new AtomicInteger(initialStreamId);
        this.pingIds = new AtomicInteger(initialStreamId);
        this.listener = listener;
        this.generator = generator;
    }

    @Override
    public short getVersion() {
        return this.version;
    }

    @Override
    public void addListener(Session.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Session.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Future<Stream> syn(SynInfo synInfo, StreamFrameListener listener) {
        Promise<Stream> result = new Promise<Stream>();
        this.syn(synInfo, listener, 0L, TimeUnit.MILLISECONDS, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syn(SynInfo synInfo, StreamFrameListener listener, long timeout, TimeUnit unit, Handler<Stream> handler) {
        StandardSession standardSession = this;
        synchronized (standardSession) {
            if (synInfo.isUnidirectional()) {
                throw new UnsupportedOperationException();
            }
            int streamId = this.streamIds.getAndAdd(2);
            SynStreamFrame synStream = new SynStreamFrame(this.version, synInfo.getFlags(), streamId, 0, synInfo.getPriority(), synInfo.getHeaders());
            IStream stream = this.createStream(synStream, listener);
            this.control(stream, synStream, timeout, unit, handler, stream);
        }
    }

    @Override
    public Future<Void> rst(RstInfo rstInfo) {
        Promise<Void> result = new Promise<Void>();
        this.rst(rstInfo, 0L, TimeUnit.MILLISECONDS, result);
        return result;
    }

    @Override
    public void rst(RstInfo rstInfo, long timeout, TimeUnit unit, Handler<Void> handler) {
        if (this.goAwaySent.get()) {
            this.complete(handler, null);
        } else {
            int streamId = rstInfo.getStreamId();
            IStream stream = (IStream)this.streams.get(streamId);
            if (stream != null) {
                this.removeStream(stream);
            }
            RstStreamFrame frame = new RstStreamFrame(this.version, streamId, rstInfo.getStreamStatus().getCode(this.version));
            this.control(null, frame, timeout, unit, handler, null);
        }
    }

    @Override
    public Future<Void> settings(SettingsInfo settingsInfo) {
        Promise<Void> result = new Promise<Void>();
        this.settings(settingsInfo, 0L, TimeUnit.MILLISECONDS, result);
        return result;
    }

    @Override
    public void settings(SettingsInfo settingsInfo, long timeout, TimeUnit unit, Handler<Void> handler) {
        SettingsFrame frame = new SettingsFrame(this.version, settingsInfo.getFlags(), settingsInfo.getSettings());
        this.control(null, frame, timeout, unit, handler, null);
    }

    @Override
    public Future<PingInfo> ping() {
        Promise<PingInfo> result = new Promise<PingInfo>();
        this.ping(0L, TimeUnit.MILLISECONDS, result);
        return result;
    }

    @Override
    public void ping(long timeout, TimeUnit unit, Handler<PingInfo> handler) {
        int pingId = this.pingIds.getAndAdd(2);
        PingInfo pingInfo = new PingInfo(pingId);
        PingFrame frame = new PingFrame(this.version, pingId);
        this.control(null, frame, timeout, unit, handler, pingInfo);
    }

    @Override
    public Future<Void> goAway() {
        return this.goAway(SessionStatus.OK);
    }

    private Future<Void> goAway(SessionStatus sessionStatus) {
        Promise<Void> result = new Promise<Void>();
        this.goAway(sessionStatus, 0L, TimeUnit.MILLISECONDS, result);
        return result;
    }

    @Override
    public void goAway(long timeout, TimeUnit unit, Handler<Void> handler) {
        this.goAway(SessionStatus.OK, timeout, unit, handler);
    }

    private void goAway(SessionStatus sessionStatus, long timeout, TimeUnit unit, Handler<Void> handler) {
        if (this.goAwaySent.compareAndSet(false, true) && !this.goAwayReceived.get()) {
            GoAwayFrame frame = new GoAwayFrame(this.version, this.lastStreamId.get(), sessionStatus.getCode());
            this.control(null, frame, timeout, unit, handler, null);
            return;
        }
        this.complete(handler, null);
    }

    @Override
    public Set<Stream> getStreams() {
        HashSet<Stream> result = new HashSet<Stream>();
        result.addAll(this.streams.values());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onControlFrame(ControlFrame frame) {
        this.notifyIdle(this.idleListener, false);
        try {
            logger.debug("Processing {}", new Object[]{frame});
            if (this.goAwaySent.get()) {
                logger.debug("Skipped processing of {}", new Object[]{frame});
                return;
            }
            switch (frame.getType()) {
                case SYN_STREAM: {
                    this.onSyn((SynStreamFrame)frame);
                    return;
                }
                case SYN_REPLY: {
                    this.onReply((SynReplyFrame)frame);
                    return;
                }
                case RST_STREAM: {
                    this.onRst((RstStreamFrame)frame);
                    return;
                }
                case SETTINGS: {
                    this.onSettings((SettingsFrame)frame);
                    return;
                }
                case NOOP: {
                    return;
                }
                case PING: {
                    this.onPing((PingFrame)frame);
                    return;
                }
                case GO_AWAY: {
                    this.onGoAway((GoAwayFrame)frame);
                    return;
                }
                case HEADERS: {
                    this.onHeaders((HeadersFrame)frame);
                    return;
                }
                case WINDOW_UPDATE: {
                    this.onWindowUpdate((WindowUpdateFrame)frame);
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.notifyIdle(this.idleListener, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataFrame(DataFrame frame, ByteBuffer data) {
        this.notifyIdle(this.idleListener, false);
        try {
            logger.debug("Processing {}, {} data bytes", new Object[]{frame, data.remaining()});
            if (this.goAwaySent.get()) {
                logger.debug("Skipped processing of {}", new Object[]{frame});
                return;
            }
            int streamId = frame.getStreamId();
            IStream stream = (IStream)this.streams.get(streamId);
            if (stream == null) {
                RstInfo rstInfo = new RstInfo(streamId, StreamStatus.INVALID_STREAM);
                logger.debug("Unknown stream {}", new Object[]{rstInfo});
                this.rst(rstInfo);
            } else {
                this.processData(stream, frame, data);
            }
        }
        finally {
            this.notifyIdle(this.idleListener, true);
        }
    }

    private void notifyIdle(IdleListener listener, boolean idle) {
        if (listener != null) {
            listener.onIdle(idle);
        }
    }

    private void processData(IStream stream, DataFrame frame, ByteBuffer data) {
        stream.process(frame, data);
        this.updateLastStreamId(stream);
        if (stream.isClosed()) {
            this.removeStream(stream);
        }
    }

    @Override
    public void onStreamException(StreamException x) {
        this.notifyOnException(this.listener, x);
        this.rst(new RstInfo(x.getStreamId(), x.getStreamStatus()));
    }

    @Override
    public void onSessionException(SessionException x) {
        Throwable cause = x.getCause();
        this.notifyOnException(this.listener, cause == null ? x : cause);
        this.goAway(x.getSessionStatus());
    }

    private void onSyn(SynStreamFrame frame) {
        IStream stream = this.newStream(frame);
        stream.updateCloseState(frame.isClose(), false);
        logger.debug("Opening {}", new Object[]{stream});
        int streamId = frame.getStreamId();
        IStream existing = this.streams.putIfAbsent(streamId, stream);
        if (existing != null) {
            RstInfo rstInfo = new RstInfo(streamId, StreamStatus.PROTOCOL_ERROR);
            logger.debug("Duplicate stream, {}", new Object[]{rstInfo});
            this.rst(rstInfo);
        } else {
            this.processSyn(this.listener, stream, frame);
        }
    }

    private void processSyn(SessionFrameListener listener, IStream stream, SynStreamFrame frame) {
        stream.process(frame);
        SynInfo synInfo = new SynInfo(frame.getHeaders(), frame.isClose(), frame.isUnidirectional(), frame.getAssociatedStreamId(), frame.getPriority());
        StreamFrameListener streamListener = this.notifyOnSyn(listener, stream, synInfo);
        stream.setStreamFrameListener(streamListener);
        this.flush();
        if (stream.isClosed()) {
            this.removeStream(stream);
        }
    }

    private IStream createStream(SynStreamFrame synStream, StreamFrameListener listener) {
        IStream stream = this.newStream(synStream);
        stream.updateCloseState(synStream.isClose(), true);
        stream.setStreamFrameListener(listener);
        if (this.streams.putIfAbsent(synStream.getStreamId(), stream) != null) {
            throw new IllegalStateException();
        }
        logger.debug("Created {}", new Object[]{stream});
        this.notifyStreamCreated(stream);
        return stream;
    }

    private IStream newStream(SynStreamFrame frame) {
        return new StandardStream(frame, this, this.windowSize);
    }

    private void notifyStreamCreated(IStream stream) {
        for (Session.Listener listener : this.listeners) {
            if (!(listener instanceof Session.StreamListener)) continue;
            try {
                ((Session.StreamListener)listener).onStreamCreated(stream);
            }
            catch (Exception x) {
                logger.info("Exception while notifying listener " + listener, (Throwable)x);
            }
        }
    }

    private void removeStream(IStream stream) {
        IStream removed = (IStream)this.streams.remove(stream.getId());
        if (removed != null) {
            assert (removed == stream);
            logger.debug("Removed {}", new Object[]{stream});
            this.notifyStreamClosed(stream);
        }
    }

    private void notifyStreamClosed(IStream stream) {
        for (Session.Listener listener : this.listeners) {
            if (!(listener instanceof Session.StreamListener)) continue;
            try {
                ((Session.StreamListener)listener).onStreamClosed(stream);
            }
            catch (Exception x) {
                logger.info("Exception while notifying listener " + listener, (Throwable)x);
            }
        }
    }

    private void onReply(SynReplyFrame frame) {
        int streamId = frame.getStreamId();
        IStream stream = (IStream)this.streams.get(streamId);
        if (stream == null) {
            RstInfo rstInfo = new RstInfo(streamId, StreamStatus.INVALID_STREAM);
            logger.debug("Unknown stream {}", new Object[]{rstInfo});
            this.rst(rstInfo);
        } else {
            this.processReply(stream, frame);
        }
    }

    private void processReply(IStream stream, SynReplyFrame frame) {
        stream.process(frame);
        if (stream.isClosed()) {
            this.removeStream(stream);
        }
    }

    private void onRst(RstStreamFrame frame) {
        IStream stream = (IStream)this.streams.get(frame.getStreamId());
        if (stream != null) {
            stream.process(frame);
        }
        RstInfo rstInfo = new RstInfo(frame.getStreamId(), StreamStatus.from(frame.getVersion(), frame.getStatusCode()));
        this.notifyOnRst(this.listener, rstInfo);
        this.flush();
        if (stream != null) {
            this.removeStream(stream);
        }
    }

    private void onSettings(SettingsFrame frame) {
        Settings.Setting windowSizeSetting = frame.getSettings().get(Settings.ID.INITIAL_WINDOW_SIZE);
        if (windowSizeSetting != null) {
            int prevWindowSize = this.windowSize;
            this.windowSize = windowSizeSetting.value();
            for (IStream stream : this.streams.values()) {
                stream.updateWindowSize(this.windowSize - prevWindowSize);
            }
            logger.debug("Updated window size to {}", new Object[]{this.windowSize});
        }
        SettingsInfo settingsInfo = new SettingsInfo(frame.getSettings(), frame.isClearPersisted());
        this.notifyOnSettings(this.listener, settingsInfo);
        this.flush();
    }

    private void onPing(PingFrame frame) {
        int pingId = frame.getPingId();
        if (pingId % 2 == this.pingIds.get() % 2) {
            PingInfo pingInfo = new PingInfo(frame.getPingId());
            this.notifyOnPing(this.listener, pingInfo);
            this.flush();
        } else {
            this.control(null, frame, 0L, TimeUnit.MILLISECONDS, null, null);
        }
    }

    private void onGoAway(GoAwayFrame frame) {
        if (this.goAwayReceived.compareAndSet(false, true)) {
            GoAwayInfo goAwayInfo = new GoAwayInfo(frame.getLastStreamId(), SessionStatus.from(frame.getStatusCode()));
            this.notifyOnGoAway(this.listener, goAwayInfo);
            this.flush();
            this.close();
        }
    }

    private void onHeaders(HeadersFrame frame) {
        int streamId = frame.getStreamId();
        IStream stream = (IStream)this.streams.get(streamId);
        if (stream == null) {
            RstInfo rstInfo = new RstInfo(streamId, StreamStatus.INVALID_STREAM);
            logger.debug("Unknown stream, {}", new Object[]{rstInfo});
            this.rst(rstInfo);
        } else {
            this.processHeaders(stream, frame);
        }
    }

    private void processHeaders(IStream stream, HeadersFrame frame) {
        stream.process(frame);
        if (stream.isClosed()) {
            this.removeStream(stream);
        }
    }

    private void onWindowUpdate(WindowUpdateFrame frame) {
        int streamId = frame.getStreamId();
        IStream stream = (IStream)this.streams.get(streamId);
        if (stream != null) {
            stream.process(frame);
        }
    }

    protected void close() {
        if (this.controller != null) {
            this.controller.close(false);
        }
    }

    private void notifyOnException(SessionFrameListener listener, Throwable x) {
        try {
            if (listener != null) {
                logger.debug("Invoking callback with {} on listener {}", new Object[]{x, listener});
                listener.onException(x);
            }
        }
        catch (Exception xx) {
            logger.info("Exception while notifying listener " + listener, (Throwable)xx);
        }
    }

    private StreamFrameListener notifyOnSyn(SessionFrameListener listener, Stream stream, SynInfo synInfo) {
        try {
            if (listener != null) {
                logger.debug("Invoking callback with {} on listener {}", new Object[]{synInfo, listener});
                return listener.onSyn(stream, synInfo);
            }
        }
        catch (Exception x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
        }
        return null;
    }

    private void notifyOnRst(SessionFrameListener listener, RstInfo rstInfo) {
        try {
            if (listener != null) {
                logger.debug("Invoking callback with {} on listener {}", new Object[]{rstInfo, listener});
                listener.onRst(this, rstInfo);
            }
        }
        catch (Exception x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    private void notifyOnSettings(SessionFrameListener listener, SettingsInfo settingsInfo) {
        try {
            if (listener != null) {
                logger.debug("Invoking callback with {} on listener {}", new Object[]{settingsInfo, listener});
                listener.onSettings(this, settingsInfo);
            }
        }
        catch (Exception x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    private void notifyOnPing(SessionFrameListener listener, PingInfo pingInfo) {
        try {
            if (listener != null) {
                logger.debug("Invoking callback with {} on listener {}", new Object[]{pingInfo, listener});
                listener.onPing(this, pingInfo);
            }
        }
        catch (Exception x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    private void notifyOnGoAway(SessionFrameListener listener, GoAwayInfo goAwayInfo) {
        try {
            if (listener != null) {
                logger.debug("Invoking callback with {} on listener {}", new Object[]{goAwayInfo, listener});
                listener.onGoAway(this, goAwayInfo);
            }
        }
        catch (Exception x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C> void control(IStream stream, ControlFrame frame, long timeout, TimeUnit unit, Handler<C> handler, C context) {
        try {
            if (stream != null) {
                this.updateLastStreamId(stream);
            }
            StandardSession standardSession = this;
            synchronized (standardSession) {
                ByteBuffer buffer = this.generator.control(frame);
                logger.debug("Queuing {} on {}", new Object[]{frame, stream});
                ControlFrameBytes frameBytes = new ControlFrameBytes(stream, handler, context, frame, buffer);
                if (timeout > 0L) {
                    frameBytes.task = this.scheduler.schedule(frameBytes, timeout, unit);
                }
                if (ControlFrameType.PING == frame.getType()) {
                    this.prepend(frameBytes);
                } else {
                    this.append(frameBytes);
                }
            }
            this.flush();
        }
        catch (Throwable x) {
            this.notifyHandlerFailed(handler, x);
        }
    }

    private void updateLastStreamId(IStream stream) {
        int streamId = stream.getId();
        if (stream.isClosed() && streamId % 2 != this.streamIds.get() % 2) {
            int oldValue = this.lastStreamId.get();
            while (streamId > oldValue && !this.lastStreamId.compareAndSet(oldValue, streamId)) {
                oldValue = this.lastStreamId.get();
            }
        }
    }

    @Override
    public <C> void data(IStream stream, DataInfo dataInfo, long timeout, TimeUnit unit, Handler<C> handler, C context) {
        logger.debug("Queuing {} on {}", new Object[]{dataInfo, stream});
        DataFrameBytes frameBytes = new DataFrameBytes(stream, handler, context, dataInfo);
        if (timeout > 0L) {
            frameBytes.task = this.scheduler.schedule(frameBytes, timeout, unit);
        }
        this.append(frameBytes);
        this.flush();
    }

    private void execute(Runnable task) {
        this.threadPool.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        FrameBytes frameBytes = null;
        ByteBuffer buffer = null;
        LinkedList<FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.flushing || this.queue.isEmpty()) {
                return;
            }
            HashSet<IStream> stalledStreams = null;
            for (int i = 0; i < this.queue.size(); ++i) {
                frameBytes = this.queue.get(i);
                if (stalledStreams != null && stalledStreams.contains(frameBytes.getStream())) continue;
                buffer = frameBytes.getByteBuffer();
                if (buffer != null) {
                    this.queue.remove(i);
                    break;
                }
                if (stalledStreams == null) {
                    stalledStreams = new HashSet<IStream>();
                }
                stalledStreams.add(frameBytes.getStream());
                logger.debug("Flush stalled for {}, {} frame(s) in queue", new Object[]{frameBytes, this.queue.size()});
            }
            if (buffer == null) {
                return;
            }
            this.flushing = true;
            logger.debug("Flushing {}, {} frame(s) in queue", new Object[]{frameBytes, this.queue.size()});
        }
        this.write(buffer, this, frameBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(FrameBytes frameBytes) {
        LinkedList<FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            FrameBytes element;
            int index;
            for (index = this.queue.size(); index > 0 && (element = this.queue.get(index - 1)).compareTo(frameBytes) < 0; --index) {
            }
            this.queue.add(index, frameBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepend(FrameBytes frameBytes) {
        LinkedList<FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            FrameBytes element;
            int index;
            for (index = 0; index < this.queue.size() && (element = this.queue.get(index)).compareTo(frameBytes) > 0; ++index) {
            }
            this.queue.add(index, frameBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(FrameBytes frameBytes) {
        LinkedList<FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            logger.debug("Completed write of {}, {} frame(s) in queue", new Object[]{frameBytes, this.queue.size()});
            this.flushing = false;
        }
        frameBytes.complete();
    }

    @Override
    public void failed(Throwable x) {
        throw new SPDYException(x);
    }

    protected void write(ByteBuffer buffer, Handler<FrameBytes> handler, FrameBytes frameBytes) {
        if (this.controller != null) {
            logger.debug("Writing {} frame bytes of {}", new Object[]{buffer.remaining(), frameBytes});
            this.controller.write(buffer, handler, frameBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C> void complete(final Handler<C> handler, final C context) {
        Integer invocations = handlerInvocations.get();
        if (invocations >= 4) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        StandardSession.this.notifyHandlerCompleted(handler, context);
                    }
                    StandardSession.this.flush();
                }
            });
        } else {
            handlerInvocations.set(invocations + 1);
            try {
                if (handler != null) {
                    this.notifyHandlerCompleted(handler, context);
                }
                this.flush();
            }
            finally {
                handlerInvocations.set(invocations);
            }
        }
    }

    private <C> void notifyHandlerCompleted(Handler<C> handler, C context) {
        try {
            handler.completed(context);
        }
        catch (Exception x) {
            logger.info("Exception while notifying handler " + handler, (Throwable)x);
        }
    }

    private void notifyHandlerFailed(Handler handler, Throwable x) {
        try {
            if (handler != null) {
                handler.failed(x);
            }
        }
        catch (Exception xx) {
            logger.info("Exception while notifying handler " + handler, (Throwable)xx);
        }
    }

    private class DataFrameBytes<C>
    extends AbstractFrameBytes<C> {
        private final DataInfo dataInfo;
        private int size;
        private volatile ByteBuffer buffer;

        private DataFrameBytes(IStream stream, Handler<C> handler, C context, DataInfo dataInfo) {
            super(stream, handler, context);
            this.dataInfo = dataInfo;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            try {
                IStream stream = this.getStream();
                int windowSize = stream.getWindowSize();
                if (windowSize <= 0) {
                    return null;
                }
                this.size = this.dataInfo.available();
                if (this.size > windowSize) {
                    this.size = windowSize;
                }
                this.buffer = StandardSession.this.generator.data(stream.getId(), this.size, this.dataInfo);
                return this.buffer;
            }
            catch (Throwable x) {
                this.fail(x);
                return null;
            }
        }

        @Override
        public void complete() {
            StandardSession.this.bufferPool.release(this.buffer);
            IStream stream = this.getStream();
            stream.updateWindowSize(-this.size);
            if (this.dataInfo.available() > 0) {
                StandardSession.this.prepend(this);
            } else {
                super.complete();
                stream.updateCloseState(this.dataInfo.isClose(), true);
                if (stream.isClosed()) {
                    StandardSession.this.removeStream(stream);
                }
            }
        }

        public String toString() {
            return String.format("DATA bytes @%x available=%d consumed=%d on %s", this.dataInfo.hashCode(), this.dataInfo.available(), this.dataInfo.consumed(), this.getStream());
        }
    }

    private class ControlFrameBytes<C>
    extends AbstractFrameBytes<C> {
        private final ControlFrame frame;
        private final ByteBuffer buffer;

        private ControlFrameBytes(IStream stream, Handler<C> handler, C context, ControlFrame frame, ByteBuffer buffer) {
            super(stream, handler, context);
            this.frame = frame;
            this.buffer = buffer;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            return this.buffer;
        }

        @Override
        public void complete() {
            StandardSession.this.bufferPool.release(this.buffer);
            super.complete();
            if (this.frame.getType() == ControlFrameType.GO_AWAY) {
                StandardSession.this.close();
            }
        }

        public String toString() {
            return this.frame.toString();
        }
    }

    private abstract class AbstractFrameBytes<C>
    implements FrameBytes,
    Runnable {
        private final IStream stream;
        private final Handler<C> handler;
        private final C context;
        protected volatile ScheduledFuture<?> task;

        protected AbstractFrameBytes(IStream stream, Handler<C> handler, C context) {
            this.stream = stream;
            this.handler = handler;
            this.context = context;
        }

        @Override
        public IStream getStream() {
            return this.stream;
        }

        @Override
        public int compareTo(FrameBytes that) {
            return that.getStream().getPriority() - this.getStream().getPriority();
        }

        @Override
        public void complete() {
            ScheduledFuture<?> task = this.task;
            if (task != null) {
                task.cancel(false);
            }
            StandardSession.this.complete(this.handler, this.context);
        }

        protected void fail(Throwable x) {
            StandardSession.this.notifyHandlerFailed(this.handler, x);
        }

        @Override
        public void run() {
            StandardSession.this.close();
            this.fail(new InterruptedByTimeoutException());
        }
    }

    public static interface FrameBytes
    extends Comparable<FrameBytes> {
        public IStream getStream();

        public ByteBuffer getByteBuffer();

        public void complete();
    }
}

