/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.spdy.ISession;
import org.eclipse.jetty.spdy.IStream;
import org.eclipse.jetty.spdy.Promise;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.Handler;
import org.eclipse.jetty.spdy.api.HeadersInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.RstInfo;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.DataFrame;
import org.eclipse.jetty.spdy.frames.HeadersFrame;
import org.eclipse.jetty.spdy.frames.SynReplyFrame;
import org.eclipse.jetty.spdy.frames.SynStreamFrame;
import org.eclipse.jetty.spdy.frames.WindowUpdateFrame;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class StandardStream
implements IStream {
    private static final Logger logger = Log.getLogger(Stream.class);
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final SynStreamFrame frame;
    private final ISession session;
    private final AtomicInteger windowSize;
    private volatile StreamFrameListener listener;
    private volatile OpenState openState = OpenState.SYN_SENT;
    private volatile CloseState closeState = CloseState.OPENED;

    public StandardStream(SynStreamFrame frame, ISession session, int windowSize) {
        this.frame = frame;
        this.session = session;
        this.windowSize = new AtomicInteger(windowSize);
    }

    @Override
    public int getId() {
        return this.frame.getStreamId();
    }

    @Override
    public byte getPriority() {
        return this.frame.getPriority();
    }

    @Override
    public int getWindowSize() {
        return this.windowSize.get();
    }

    @Override
    public void updateWindowSize(int delta) {
        int size = this.windowSize.addAndGet(delta);
        logger.debug("Updated window size by {}, new window size {}", new Object[]{delta, size});
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public boolean isHalfClosed() {
        CloseState closeState = this.closeState;
        return closeState == CloseState.LOCALLY_CLOSED || closeState == CloseState.REMOTELY_CLOSED || closeState == CloseState.CLOSED;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    @Override
    public void setStreamFrameListener(StreamFrameListener listener) {
        this.listener = listener;
    }

    @Override
    public void updateCloseState(boolean close, boolean local) {
        if (close) {
            switch (this.closeState) {
                case OPENED: {
                    this.closeState = local ? CloseState.LOCALLY_CLOSED : CloseState.REMOTELY_CLOSED;
                    break;
                }
                case LOCALLY_CLOSED: {
                    if (local) {
                        throw new IllegalStateException();
                    }
                    this.closeState = CloseState.CLOSED;
                    break;
                }
                case REMOTELY_CLOSED: {
                    if (local) {
                        this.closeState = CloseState.CLOSED;
                        break;
                    }
                    throw new IllegalStateException();
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Override
    public void process(ControlFrame frame) {
        switch (frame.getType()) {
            case SYN_STREAM: {
                this.openState = OpenState.SYN_RECV;
                break;
            }
            case SYN_REPLY: {
                this.openState = OpenState.REPLY_RECV;
                SynReplyFrame synReply = (SynReplyFrame)frame;
                this.updateCloseState(synReply.isClose(), false);
                ReplyInfo replyInfo = new ReplyInfo(synReply.getHeaders(), synReply.isClose());
                this.notifyOnReply(replyInfo);
                break;
            }
            case HEADERS: {
                HeadersFrame headers = (HeadersFrame)frame;
                this.updateCloseState(headers.isClose(), false);
                HeadersInfo headersInfo = new HeadersInfo(headers.getHeaders(), headers.isClose(), headers.isResetCompression());
                this.notifyOnHeaders(headersInfo);
                break;
            }
            case WINDOW_UPDATE: {
                WindowUpdateFrame windowUpdate = (WindowUpdateFrame)frame;
                this.updateWindowSize(windowUpdate.getWindowDelta());
                break;
            }
            case RST_STREAM: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.session.flush();
    }

    @Override
    public void process(DataFrame frame, ByteBuffer data) {
        if (!this.canReceive()) {
            this.session.rst(new RstInfo(this.getId(), StreamStatus.PROTOCOL_ERROR));
            return;
        }
        this.updateCloseState(frame.isClose(), false);
        ByteBufferDataInfo dataInfo = new ByteBufferDataInfo(data, frame.isClose(), frame.isCompress()){

            @Override
            public void consume(int delta) {
                super.consume(delta);
                if (this.consumed() == this.length() && !StandardStream.this.isClosed()) {
                    StandardStream.this.windowUpdate(this.length());
                }
            }
        };
        this.notifyOnData(dataInfo);
        this.session.flush();
    }

    private void windowUpdate(int delta) {
        if (delta > 0) {
            WindowUpdateFrame windowUpdateFrame = new WindowUpdateFrame(this.session.getVersion(), this.getId(), delta);
            this.session.control(this, windowUpdateFrame, 0L, TimeUnit.MILLISECONDS, null, null);
        }
    }

    private void notifyOnReply(ReplyInfo replyInfo) {
        StreamFrameListener listener = this.listener;
        try {
            if (listener != null) {
                logger.debug("Invoking reply callback with {} on listener {}", new Object[]{replyInfo, listener});
                listener.onReply(this, replyInfo);
            }
        }
        catch (Exception x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    private void notifyOnHeaders(HeadersInfo headersInfo) {
        StreamFrameListener listener = this.listener;
        try {
            if (listener != null) {
                logger.debug("Invoking headers callback with {} on listener {}", new Object[]{this.frame, listener});
                listener.onHeaders(this, headersInfo);
            }
        }
        catch (Exception x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    private void notifyOnData(DataInfo dataInfo) {
        StreamFrameListener listener = this.listener;
        try {
            if (listener != null) {
                logger.debug("Invoking data callback with {} on listener {}", new Object[]{dataInfo, listener});
                listener.onData(this, dataInfo);
                logger.debug("Invoked data callback with {} on listener {}", new Object[]{dataInfo, listener});
            }
        }
        catch (Exception x) {
            logger.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    @Override
    public Future<Void> reply(ReplyInfo replyInfo) {
        Promise<Void> result = new Promise<Void>();
        this.reply(replyInfo, 0L, TimeUnit.MILLISECONDS, result);
        return result;
    }

    @Override
    public void reply(ReplyInfo replyInfo, long timeout, TimeUnit unit, Handler<Void> handler) {
        this.openState = OpenState.REPLY_SENT;
        this.updateCloseState(replyInfo.isClose(), true);
        SynReplyFrame frame = new SynReplyFrame(this.session.getVersion(), replyInfo.getFlags(), this.getId(), replyInfo.getHeaders());
        this.session.control(this, frame, timeout, unit, handler, null);
    }

    @Override
    public Future<Void> data(DataInfo dataInfo) {
        Promise<Void> result = new Promise<Void>();
        this.data(dataInfo, 0L, TimeUnit.MILLISECONDS, result);
        return result;
    }

    @Override
    public void data(DataInfo dataInfo, long timeout, TimeUnit unit, Handler<Void> handler) {
        if (!this.canSend()) {
            this.session.rst(new RstInfo(this.getId(), StreamStatus.PROTOCOL_ERROR));
            throw new IllegalStateException("Protocol violation: cannot send a DATA frame before a SYN_REPLY frame");
        }
        if (this.isLocallyClosed()) {
            this.session.rst(new RstInfo(this.getId(), StreamStatus.PROTOCOL_ERROR));
            throw new IllegalStateException("Protocol violation: cannot send a DATA frame on a closed stream");
        }
        this.session.data(this, dataInfo, timeout, unit, handler, null);
    }

    @Override
    public Future<Void> headers(HeadersInfo headersInfo) {
        Promise<Void> result = new Promise<Void>();
        this.headers(headersInfo, 0L, TimeUnit.MILLISECONDS, result);
        return result;
    }

    @Override
    public void headers(HeadersInfo headersInfo, long timeout, TimeUnit unit, Handler<Void> handler) {
        if (!this.canSend()) {
            this.session.rst(new RstInfo(this.getId(), StreamStatus.PROTOCOL_ERROR));
            throw new IllegalStateException("Protocol violation: cannot send a HEADERS frame before a SYN_REPLY frame");
        }
        if (this.isLocallyClosed()) {
            this.session.rst(new RstInfo(this.getId(), StreamStatus.PROTOCOL_ERROR));
            throw new IllegalStateException("Protocol violation: cannot send a HEADERS frame on a closed stream");
        }
        this.updateCloseState(headersInfo.isClose(), true);
        HeadersFrame frame = new HeadersFrame(this.session.getVersion(), headersInfo.getFlags(), this.getId(), headersInfo.getHeaders());
        this.session.control(this, frame, timeout, unit, handler, null);
    }

    @Override
    public boolean isClosed() {
        return this.closeState == CloseState.CLOSED;
    }

    private boolean isLocallyClosed() {
        CloseState closeState = this.closeState;
        return closeState == CloseState.LOCALLY_CLOSED || closeState == CloseState.CLOSED;
    }

    public String toString() {
        return String.format("stream=%d v%d %s", new Object[]{this.getId(), this.session.getVersion(), this.closeState});
    }

    private boolean canSend() {
        OpenState openState = this.openState;
        return openState == OpenState.SYN_SENT || openState == OpenState.REPLY_RECV || openState == OpenState.REPLY_SENT;
    }

    private boolean canReceive() {
        OpenState openState = this.openState;
        return openState == OpenState.SYN_RECV || openState == OpenState.REPLY_RECV || openState == OpenState.REPLY_SENT;
    }

    private static enum CloseState {
        OPENED,
        LOCALLY_CLOSED,
        REMOTELY_CLOSED,
        CLOSED;

    }

    private static enum OpenState {
        SYN_SENT,
        SYN_RECV,
        REPLY_SENT,
        REPLY_RECV;

    }
}

