/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.api;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.api.DataInfo;

public class BytesDataInfo
extends DataInfo {
    private byte[] bytes;
    private int offset;

    public BytesDataInfo(byte[] bytes, boolean close) {
        this(bytes, close, false);
    }

    public BytesDataInfo(byte[] bytes, boolean close, boolean compress) {
        super(close, compress);
        this.bytes = bytes;
    }

    @Override
    public int length() {
        return this.bytes.length;
    }

    @Override
    public int available() {
        return this.length() - this.offset;
    }

    @Override
    public int readInto(ByteBuffer output) {
        int space = output.remaining();
        int length = Math.min(this.available(), space);
        output.put(this.bytes, this.offset, length);
        this.offset += length;
        return length;
    }
}

