/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.api;

import org.eclipse.jetty.spdy.api.Headers;

public class SynInfo {
    public static final byte FLAG_CLOSE = 1;
    public static final byte FLAG_UNIDIRECTIONAL = 2;
    private final boolean close;
    private final boolean unidirectional;
    private final int associatedStreamId;
    private final byte priority;
    private final Headers headers;

    public SynInfo(boolean close) {
        this(new Headers(), close);
    }

    public SynInfo(Headers headers, boolean close) {
        this(headers, close, false, 0, 0);
    }

    public SynInfo(Headers headers, boolean close, boolean unidirectional, int associatedStreamId, byte priority) {
        this.close = close;
        this.unidirectional = unidirectional;
        this.associatedStreamId = associatedStreamId;
        this.priority = priority;
        this.headers = headers;
    }

    public boolean isClose() {
        return this.close;
    }

    public boolean isUnidirectional() {
        return this.unidirectional;
    }

    public int getAssociatedStreamId() {
        return this.associatedStreamId;
    }

    public byte getPriority() {
        return this.priority;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public byte getFlags() {
        byte flags = this.isClose() ? (byte)1 : 0;
        flags = (byte)(flags + (this.isUnidirectional() ? 2 : 0));
        return flags;
    }

    public String toString() {
        return String.format("SYN close=%b headers=%s", this.close, this.headers);
    }
}

