/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.ByteBufferPool;
import org.eclipse.jetty.spdy.SessionException;
import org.eclipse.jetty.spdy.api.SessionStatus;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.HeadersFrame;
import org.eclipse.jetty.spdy.generator.ControlFrameGenerator;
import org.eclipse.jetty.spdy.generator.HeadersBlockGenerator;

public class HeadersGenerator
extends ControlFrameGenerator {
    private final HeadersBlockGenerator headersBlockGenerator;

    public HeadersGenerator(ByteBufferPool bufferPool, HeadersBlockGenerator headersBlockGenerator) {
        super(bufferPool);
        this.headersBlockGenerator = headersBlockGenerator;
    }

    @Override
    public ByteBuffer generate(ControlFrame frame) {
        int frameBodyLength = 4;
        HeadersFrame headers = (HeadersFrame)frame;
        short version = headers.getVersion();
        ByteBuffer headersBuffer = this.headersBlockGenerator.generate(version, headers.getHeaders());
        int frameLength = frameBodyLength + headersBuffer.remaining();
        if (frameLength > 0xFFFFFF) {
            throw new SessionException(SessionStatus.PROTOCOL_ERROR, "Too many headers");
        }
        int totalLength = 8 + frameLength;
        ByteBuffer buffer = this.getByteBufferPool().acquire(totalLength, true);
        this.generateControlFrameHeader(headers, frameLength, buffer);
        buffer.putInt(headers.getStreamId() & Integer.MAX_VALUE);
        buffer.put(headersBuffer);
        buffer.flip();
        return buffer;
    }
}

