/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.http;

import java.io.IOException;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.spdy.AsyncConnectionFactory;
import org.eclipse.jetty.spdy.SPDYServerConnector;
import org.eclipse.jetty.spdy.http.ServerHTTPAsyncConnectionFactory;
import org.eclipse.jetty.spdy.http.ServerHTTPSPDYAsyncConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HTTPSPDYServerConnector
extends SPDYServerConnector {
    private final AsyncConnectionFactory defaultConnectionFactory = new ServerHTTPAsyncConnectionFactory((Connector)this);

    public HTTPSPDYServerConnector() {
        this(null);
    }

    public HTTPSPDYServerConnector(SslContextFactory sslContextFactory) {
        super(null, sslContextFactory);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.putAsyncConnectionFactory("spdy/2", (AsyncConnectionFactory)new ServerHTTPSPDYAsyncConnectionFactory(2, this.getByteBufferPool(), this.getExecutor(), this.getScheduler(), (Connector)this));
        this.putAsyncConnectionFactory("http/1.1", new ServerHTTPAsyncConnectionFactory((Connector)this));
    }

    protected AsyncConnectionFactory getDefaultAsyncConnectionFactory() {
        return this.defaultConnectionFactory;
    }

    public void customize(EndPoint endPoint, Request request) throws IOException {
        super.customize(endPoint, request);
        if (this.getSslContextFactory() != null) {
            request.setScheme("https");
        }
    }

    public boolean isConfidential(Request request) {
        if (this.getSslContextFactory() != null) {
            int confidentialPort = this.getConfidentialPort();
            return confidentialPort == 0 || confidentialPort == request.getServerPort();
        }
        return super.isConfidential(request);
    }

    public boolean isIntegral(Request request) {
        if (this.getSslContextFactory() != null) {
            int integralPort = this.getIntegralPort();
            return integralPort == 0 || integralPort == request.getServerPort();
        }
        return super.isIntegral(request);
    }
}

