/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.NIOBuffer;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.spdy.SPDYAsyncConnection;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.Headers;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ServerHTTPSPDYAsyncConnection
extends AbstractHttpConnection
implements AsyncConnection {
    private static final Logger logger = Log.getLogger(ServerHTTPSPDYAsyncConnection.class);
    private static final ByteBuffer ZERO_BYTES = ByteBuffer.allocate(0);
    private static final DataInfo END_OF_CONTENT = new ByteBufferDataInfo(ZERO_BYTES, true);
    private final Queue<Runnable> tasks = new LinkedList<Runnable>();
    private final BlockingQueue<DataInfo> dataInfos = new LinkedBlockingQueue<DataInfo>();
    private final SPDYAsyncConnection connection;
    private final Stream stream;
    private Headers headers;
    private DataInfo dataInfo;
    private NIOBuffer buffer;
    private volatile State state = State.INITIAL;
    private boolean dispatched;

    public ServerHTTPSPDYAsyncConnection(Connector connector, AsyncEndPoint endPoint, Server server, SPDYAsyncConnection connection, Stream stream) {
        super(connector, (EndPoint)endPoint, server);
        this.connection = connection;
        this.stream = stream;
        this.getParser().setPersistent(true);
    }

    protected HttpParser newHttpParser(Buffers requestBuffers, EndPoint endPoint, HttpParser.EventHandler requestHandler) {
        return new HTTPSPDYParser(requestBuffers, endPoint);
    }

    protected HttpGenerator newHttpGenerator(Buffers responseBuffers, EndPoint endPoint) {
        return new HTTPSPDYGenerator(responseBuffers, endPoint);
    }

    public AsyncEndPoint getEndPoint() {
        return (AsyncEndPoint)super.getEndPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(Runnable task) {
        Queue<Runnable> queue = this.tasks;
        synchronized (queue) {
            logger.debug("Posting task {}", new Object[]{task});
            this.tasks.offer(task);
            this.dispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch() {
        Queue<Runnable> queue = this.tasks;
        synchronized (queue) {
            if (this.dispatched) {
                return;
            }
            final Runnable task = this.tasks.poll();
            if (task != null) {
                this.dispatched = true;
                logger.debug("Dispatching task {}", new Object[]{task});
                this.getServer().getThreadPool().dispatch(new Runnable(){

                    @Override
                    public void run() {
                        logger.debug("Executing task {}", new Object[]{task});
                        task.run();
                        logger.debug("Completing task {}", new Object[]{task});
                        ServerHTTPSPDYAsyncConnection.this.dispatched = false;
                        ServerHTTPSPDYAsyncConnection.this.dispatch();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection handle() {
        ServerHTTPSPDYAsyncConnection.setCurrentConnection((AbstractHttpConnection)this);
        try {
            ServerHTTPSPDYAsyncConnection buffer;
            switch (this.state) {
                case INITIAL: {
                    break;
                }
                case REQUEST: {
                    Headers.Header method = this.headers.get("method");
                    Headers.Header uri = this.headers.get("url");
                    Headers.Header version = this.headers.get("version");
                    if (method == null || uri == null || version == null) {
                        throw new HttpException(400);
                    }
                    String m = method.value();
                    String u = uri.value();
                    String v = version.value();
                    logger.debug("HTTP > {} {} {}", new Object[]{m, u, v});
                    this.startRequest((Buffer)new ByteArrayBuffer(m), (Buffer)new ByteArrayBuffer(u), (Buffer)new ByteArrayBuffer(v));
                    this.updateState(State.HEADERS);
                    this.handle();
                    break;
                }
                case HEADERS: {
                    block29: for (Headers.Header header : this.headers) {
                        String name;
                        switch (name = header.name()) {
                            case "method": 
                            case "version": 
                            case "url": {
                                continue block29;
                            }
                            case "connection": 
                            case "keep-alive": 
                            case "proxy-connection": 
                            case "transfer-encoding": {
                                continue block29;
                            }
                        }
                        String value = header.value();
                        logger.debug("HTTP > {}: {}", new Object[]{name, value});
                        this.parsedHeader((Buffer)new ByteArrayBuffer(name), (Buffer)new ByteArrayBuffer(value));
                    }
                    break;
                }
                case HEADERS_COMPLETE: {
                    this.headerComplete();
                    break;
                }
                case CONTENT: {
                    buffer = this.buffer;
                    if (buffer == null || buffer.length() <= 0) break;
                    this.content((Buffer)buffer);
                    break;
                }
                case FINAL: {
                    this.messageComplete(0L);
                    break;
                }
                case ASYNC: {
                    this.handleRequest();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            buffer = this;
            return buffer;
        }
        catch (HttpException x) {
            this.respond(this.stream, x.getStatus());
            ServerHTTPSPDYAsyncConnection serverHTTPSPDYAsyncConnection = this;
            return serverHTTPSPDYAsyncConnection;
        }
        catch (IOException x) {
            this.close(this.stream);
            ServerHTTPSPDYAsyncConnection serverHTTPSPDYAsyncConnection = this;
            return serverHTTPSPDYAsyncConnection;
        }
        finally {
            ServerHTTPSPDYAsyncConnection.setCurrentConnection(null);
        }
    }

    private void respond(Stream stream, int status) {
        Headers headers = new Headers();
        headers.put("status", String.valueOf(status));
        headers.put("version", "HTTP/1.1");
        stream.reply(new ReplyInfo(headers, true));
    }

    private void close(Stream stream) {
        stream.getSession().goAway();
    }

    public void onInputShutdown() throws IOException {
    }

    private void updateState(State newState) {
        logger.debug("State update {} -> {}", new Object[]{this.state, newState});
        this.state = newState;
    }

    public void beginRequest(final Headers headers) {
        this.headers = headers.isEmpty() ? null : headers;
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!headers.isEmpty()) {
                    ServerHTTPSPDYAsyncConnection.this.updateState(State.REQUEST);
                }
                ServerHTTPSPDYAsyncConnection.this.handle();
            }
        });
    }

    public void headers(Headers headers) {
        this.headers = headers;
        this.post(new Runnable(){

            @Override
            public void run() {
                ServerHTTPSPDYAsyncConnection.this.updateState(ServerHTTPSPDYAsyncConnection.this.state == State.INITIAL ? State.REQUEST : State.HEADERS);
                ServerHTTPSPDYAsyncConnection.this.handle();
            }
        });
    }

    public void content(final DataInfo dataInfo, boolean endRequest) {
        ByteBufferDataInfo copyDataInfo = new ByteBufferDataInfo(dataInfo.asByteBuffer(false), dataInfo.isClose(), dataInfo.isCompress()){

            public void consume(int delta) {
                super.consume(delta);
                dataInfo.consume(delta);
            }
        };
        logger.debug("Queuing last={} content {}", new Object[]{endRequest, copyDataInfo});
        this.dataInfos.offer((DataInfo)copyDataInfo);
        if (endRequest) {
            this.dataInfos.offer(END_OF_CONTENT);
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                logger.debug("HTTP > {} bytes of content", new Object[]{dataInfo.length()});
                if (ServerHTTPSPDYAsyncConnection.this.state == State.HEADERS) {
                    ServerHTTPSPDYAsyncConnection.this.updateState(State.HEADERS_COMPLETE);
                    ServerHTTPSPDYAsyncConnection.this.handle();
                }
                ServerHTTPSPDYAsyncConnection.this.updateState(State.CONTENT);
                ServerHTTPSPDYAsyncConnection.this.handle();
            }
        });
    }

    public void endRequest() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (ServerHTTPSPDYAsyncConnection.this.state == State.HEADERS) {
                    ServerHTTPSPDYAsyncConnection.this.updateState(State.HEADERS_COMPLETE);
                    ServerHTTPSPDYAsyncConnection.this.handle();
                }
                ServerHTTPSPDYAsyncConnection.this.updateState(State.FINAL);
                ServerHTTPSPDYAsyncConnection.this.handle();
            }
        });
    }

    public void async() {
        this.post(new Runnable(){

            @Override
            public void run() {
                State oldState = ServerHTTPSPDYAsyncConnection.this.state;
                ServerHTTPSPDYAsyncConnection.this.updateState(State.ASYNC);
                ServerHTTPSPDYAsyncConnection.this.handle();
                ServerHTTPSPDYAsyncConnection.this.updateState(oldState);
            }
        });
    }

    private Buffer consumeContent(long maxIdleTime) throws IOException, InterruptedException {
        while (true) {
            State state;
            if ((state = this.state) != State.HEADERS_COMPLETE && state != State.CONTENT && state != State.FINAL) {
                throw new IllegalStateException();
            }
            if (this.buffer != null) {
                if (this.buffer.length() > 0) {
                    logger.debug("Consuming content bytes, {} available", new Object[]{this.buffer.length()});
                    return this.buffer;
                }
                this.dataInfo.consume(this.dataInfo.length());
                logger.debug("Consumed {} content bytes, queue size {}", new Object[]{this.dataInfo.consumed(), this.dataInfos.size()});
                this.dataInfo = null;
                this.buffer = null;
                continue;
            }
            logger.debug("Waiting at most {} ms for content bytes", new Object[]{maxIdleTime});
            long begin = System.nanoTime();
            this.dataInfo = this.dataInfos.poll(maxIdleTime, TimeUnit.MILLISECONDS);
            long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - begin);
            logger.debug("Waited {} ms for content bytes", new Object[]{elapsed});
            if (this.dataInfo == null) break;
            if (this.dataInfo == END_OF_CONTENT) {
                logger.debug("End of content bytes, queue size {}", new Object[]{this.dataInfos.size()});
                return null;
            }
            ByteBuffer byteBuffer = this.dataInfo.asByteBuffer(false);
            this.buffer = (NIOBuffer)(byteBuffer.isDirect() ? new DirectNIOBuffer(byteBuffer, false) : new IndirectNIOBuffer(byteBuffer, false));
        }
        this.stream.getSession().goAway();
        throw new EOFException("read timeout");
    }

    private int availableContent() {
        State state = this.state;
        if (state != State.HEADERS_COMPLETE && state != State.CONTENT) {
            throw new IllegalStateException();
        }
        return this.buffer == null ? 0 : this.buffer.length();
    }

    public void commitResponse(boolean last) throws IOException {
        super.commitResponse(last);
    }

    public void flushResponse() throws IOException {
        this.commitResponse(false);
    }

    public void completeResponse() throws IOException {
        super.completeResponse();
    }

    private class HTTPSPDYGenerator
    extends HttpGenerator {
        private boolean closed;

        private HTTPSPDYGenerator(Buffers buffers, EndPoint endPoint) {
            super(buffers, endPoint);
        }

        public void send1xx(int code) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void sendResponse(Buffer response) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void sendError(int code, String reason, String content, boolean close) throws IOException {
            super.sendError(code, reason, content, close);
        }

        public void completeHeader(HttpFields fields, boolean allContentAdded) throws IOException {
            Headers headers = new Headers();
            String version = "HTTP/1.1";
            headers.put("version", version);
            StringBuilder status = new StringBuilder().append(this._status);
            if (this._reason != null) {
                status.append(" ").append(this._reason.toString("UTF-8"));
            }
            headers.put("status", status.toString());
            logger.debug("HTTP < {} {}", new Object[]{version, status});
            if (fields != null) {
                for (int i = 0; i < fields.size(); ++i) {
                    HttpFields.Field field = fields.getField(i);
                    String name = field.getName().toLowerCase();
                    String value = field.getValue();
                    headers.put(name, value);
                    logger.debug("HTTP < {}: {}", new Object[]{name, value});
                }
            }
            Buffer content = this.getContentBuffer();
            ServerHTTPSPDYAsyncConnection.this.stream.reply(new ReplyInfo(headers, content == null));
            if (content != null) {
                this.closed = allContentAdded || this.isAllContentWritten();
                ByteBuffer buffer = ByteBuffer.wrap(content.asArray());
                logger.debug("HTTP < {} bytes of content", new Object[]{buffer.remaining()});
                ServerHTTPSPDYAsyncConnection.this.stream.data((DataInfo)new ByteBufferDataInfo(buffer, this.closed));
                content.clear();
                this._state = this.closed ? 4 : 2;
            } else {
                this.closed = true;
                this._state = 4;
            }
        }

        private Buffer getContentBuffer() {
            if (this._buffer != null && this._buffer.length() > 0) {
                return this._buffer;
            }
            if (this._bypass && this._content != null && this._content.length() > 0) {
                return this._content;
            }
            return null;
        }

        public boolean addContent(byte b) throws IOException {
            this.addContent((Buffer)new ByteArrayBuffer(new byte[]{b}), false);
            return false;
        }

        public void addContent(Buffer content, boolean last) throws IOException {
            super.addContent(content, last);
        }

        public void flush(long maxIdleTime) throws IOException {
            while (this._content != null && this._content.length() > 0) {
                this._content.skip(this._buffer.put(this._content));
                ByteBuffer buffer = ByteBuffer.wrap(this._buffer.asArray());
                logger.debug("HTTP < {} bytes of content", new Object[]{buffer.remaining()});
                this._buffer.clear();
                this.closed = this._content.length() == 0 && this._last;
                ServerHTTPSPDYAsyncConnection.this.stream.data((DataInfo)new ByteBufferDataInfo(buffer, this.closed));
                boolean expired = !ServerHTTPSPDYAsyncConnection.this.connection.getEndPoint().blockWritable(maxIdleTime);
                if (!expired) continue;
                ServerHTTPSPDYAsyncConnection.this.stream.getSession().goAway();
                throw new EOFException("write timeout");
            }
        }

        public int flushBuffer() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void blockForOutput(long maxIdleTime) throws IOException {
            this.flush(maxIdleTime);
        }

        public void complete() throws IOException {
            Buffer content = this.getContentBuffer();
            if (content != null) {
                ByteBuffer buffer = ByteBuffer.wrap(content.asArray());
                logger.debug("HTTP < {} bytes of content", new Object[]{buffer.remaining()});
                content.clear();
                this._state = 4;
                ServerHTTPSPDYAsyncConnection.this.stream.data((DataInfo)new ByteBufferDataInfo(buffer, true));
            } else if (!this.closed) {
                this.closed = true;
                this._state = 4;
                ServerHTTPSPDYAsyncConnection.this.stream.data((DataInfo)new ByteBufferDataInfo(ZERO_BYTES, true));
            }
        }
    }

    private static class HTTPSPDYParserHandler
    extends HttpParser.EventHandler {
        private HTTPSPDYParserHandler() {
        }

        public void startRequest(Buffer method, Buffer url, Buffer version) throws IOException {
        }

        public void content(Buffer ref) throws IOException {
        }

        public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
        }
    }

    private class HTTPSPDYParser
    extends HttpParser {
        public HTTPSPDYParser(Buffers buffers, EndPoint endPoint) {
            super(buffers, endPoint, (HttpParser.EventHandler)new HTTPSPDYParserHandler());
        }

        public Buffer blockForContent(long maxIdleTime) throws IOException {
            try {
                return ServerHTTPSPDYAsyncConnection.this.consumeContent(maxIdleTime);
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
        }

        public int available() throws IOException {
            return ServerHTTPSPDYAsyncConnection.this.availableContent();
        }
    }

    private static enum State {
        INITIAL,
        REQUEST,
        HEADERS,
        HEADERS_COMPLETE,
        CONTENT,
        FINAL,
        ASYNC;

    }
}

