/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http;

import java.io.Serializable;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import javax.net.ssl.SSLEngine;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.channel.nio2.ClientChannelFactory;
import org.http4s.blaze.channel.nio2.ClientChannelFactory$;
import org.http4s.blaze.http.ClientSessionManager;
import org.http4s.blaze.http.ClientSessionManagerImpl$;
import org.http4s.blaze.http.Http1ClientSession;
import org.http4s.blaze.http.Http2ClientSession;
import org.http4s.blaze.http.HttpClientConfig;
import org.http4s.blaze.http.HttpClientSession;
import org.http4s.blaze.http.HttpClientSession$Closed$;
import org.http4s.blaze.http.HttpRequest;
import org.http4s.blaze.http.http1.client.Http1ClientStage;
import org.http4s.blaze.http.util.UrlTools;
import org.http4s.blaze.http.util.UrlTools$UrlComposition$;
import org.http4s.blaze.internal.compat$;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.LeafBuilder$;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.pipeline.stages.SSLStage;
import org.http4s.blaze.pipeline.stages.SSLStage$;
import org.http4s.blaze.util.Execution$;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blaze.util.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r5r!B%K\u0011\u0013\u0019f!B+K\u0011\u00131\u0006\"B/\u0002\t\u0003q\u0006bB0\u0002\u0005\u0004%I\u0001\u0019\u0005\u0007I\u0006\u0001\u000b\u0011B1\u0007\t\u0015\f\u0001I\u001a\u0005\tm\u0016\u0011)\u001a!C\u0001o\"I\u0011\u0011A\u0003\u0003\u0012\u0003\u0006I\u0001\u001f\u0005\n\u0003\u0007)!Q3A\u0005\u0002]D\u0011\"!\u0002\u0006\u0005#\u0005\u000b\u0011\u0002=\t\ru+A\u0011AA\u0004\u0011%\t\t\"BA\u0001\n\u0003\t\u0019\u0002C\u0005\u0002\u001a\u0015\t\n\u0011\"\u0001\u0002\u001c!I\u0011\u0011G\u0003\u0012\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003g)\u0011\u0011!C!\u0003kA\u0011\"!\u0012\u0006\u0003\u0003%\t!a\u0012\t\u0013\u0005=S!!A\u0005\u0002\u0005E\u0003\"CA/\u000b\u0005\u0005I\u0011IA0\u0011%\ti'BA\u0001\n\u0003\ty\u0007C\u0005\u0002z\u0015\t\t\u0011\"\u0011\u0002|!I\u0011qP\u0003\u0002\u0002\u0013\u0005\u0013\u0011\u0011\u0005\n\u0003\u0007+\u0011\u0011!C!\u0003\u000bC\u0011\"a\"\u0006\u0003\u0003%\t%!#\b\u0013\u00055\u0015!!A\t\u0002\u0005=e\u0001C3\u0002\u0003\u0003E\t!!%\t\ruCB\u0011AAU\u0011%\t\u0019\tGA\u0001\n\u000b\n)\tC\u0005\u0002,b\t\t\u0011\"!\u0002.\"I\u00111\u0017\r\u0002\u0002\u0013\u0005\u0015Q\u0017\u0005\n\u0003\u000fD\u0012\u0011!C\u0005\u0003\u00134a!!5\u0002\u0001\u0006M\u0007BCAn=\tU\r\u0011\"\u0001\u0002^\"Q\u0011q\u001c\u0010\u0003\u0012\u0003\u0006I!!\u0003\t\u0015\u0005\u0005hD!f\u0001\n\u0003\t\u0019\u000f\u0003\u0006\u0002fz\u0011\t\u0012)A\u0005\u0003+Da!\u0018\u0010\u0005\u0002\u0005\u001d\bbBAx=\u0011\u0005\u0013\u0011\u001f\u0005\b\u0005OqB\u0011\tB\u0015\u0011\u001d\u0011\tD\bC!\u0005gA\u0011\"!\u0005\u001f\u0003\u0003%\tA!\u0014\t\u0013\u0005ea$%A\u0005\u0002\tM\u0003\"CA\u0019=E\u0005I\u0011\u0001B,\u0011%\t\u0019DHA\u0001\n\u0003\n)\u0004C\u0005\u0002Fy\t\t\u0011\"\u0001\u0002H!I\u0011q\n\u0010\u0002\u0002\u0013\u0005!1\f\u0005\n\u0003;r\u0012\u0011!C!\u0003?B\u0011\"!\u001c\u001f\u0003\u0003%\tAa\u0018\t\u0013\u0005ed$!A\u0005B\t\r\u0004\"CA@=\u0005\u0005I\u0011IAA\u0011%\t\u0019IHA\u0001\n\u0003\n)\tC\u0005\u0002\bz\t\t\u0011\"\u0011\u0003h\u001dI!1N\u0001\u0002\u0002#\u0005!Q\u000e\u0004\n\u0003#\f\u0011\u0011!E\u0001\u0005_Ba!\u0018\u001b\u0005\u0002\tM\u0004\"CABi\u0005\u0005IQIAC\u0011%\tY\u000bNA\u0001\n\u0003\u0013)\bC\u0005\u00024R\n\t\u0011\"!\u0003|!I\u0011q\u0019\u001b\u0002\u0002\u0013%\u0011\u0011\u001a\u0005\b\u0003W\u000bA\u0011\u0001BB\r\u0015)&J\u0002BD\u0011)\u0011yi\u000fB\u0001B\u0003%!\u0011\u0013\u0005\u000b\u0005[[$\u0011!Q\u0001\n\t=\u0006BB/<\t\u0003\u0011)\f\u0003\u0005\u0003<n\u0002K\u0011\u0002B_\u0011!\u00119n\u000fQ\u0005\f\te\u0007\u0002\u0003Bqw\u0001\u0006IAa9\t\u0011\t=8\b)A\u0005\u0005cDqa!\u0001<\t\u0003\u001a\u0019\u0001\u0003\u0005\u0004\nm\u0002K\u0011BB\u0006\u0011!\u0019ya\u000fQ\u0005\n\rE\u0001bBB\rw\u0011\u000531\u0004\u0005\b\u0005cYD\u0011IB\u0011\u0011!\u0019\u0019c\u000fQ\u0005\n\r\u0015\u0012\u0001G\"mS\u0016tGoU3tg&|g.T1oC\u001e,'/S7qY*\u00111\nT\u0001\u0005QR$\bO\u0003\u0002N\u001d\u0006)!\r\\1{K*\u0011q\nU\u0001\u0007QR$\b\u000fN:\u000b\u0003E\u000b1a\u001c:h\u0007\u0001\u0001\"\u0001V\u0001\u000e\u0003)\u0013\u0001d\u00117jK:$8+Z:tS>tW*\u00198bO\u0016\u0014\u0018*\u001c9m'\t\tq\u000b\u0005\u0002Y76\t\u0011LC\u0001[\u0003\u0015\u00198-\u00197b\u0013\ta\u0016L\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u000b1\u0003T8x#V\fG.\u001b;z)\"\u0014Xm\u001d5pY\u0012,\u0012!\u0019\t\u00031\nL!aY-\u0003\r\u0011{WO\u00197f\u0003Qaun^)vC2LG/\u001f+ie\u0016\u001c\bn\u001c7eA\ta1i\u001c8oK\u000e$\u0018n\u001c8JIN!QaV4k!\tA\u0006.\u0003\u0002j3\n9\u0001K]8ek\u000e$\bCA6t\u001d\ta\u0017O\u0004\u0002na6\taN\u0003\u0002p%\u00061AH]8pizJ\u0011AW\u0005\u0003ef\u000bq\u0001]1dW\u0006<W-\u0003\u0002uk\na1+\u001a:jC2L'0\u00192mK*\u0011!/W\u0001\u0007g\u000eDW-\\3\u0016\u0003a\u0004\"!_?\u000f\u0005i\\\bCA7Z\u0013\ta\u0018,\u0001\u0004Qe\u0016$WMZ\u0005\u0003}~\u0014aa\u0015;sS:<'B\u0001?Z\u0003\u001d\u00198\r[3nK\u0002\n\u0011\"Y;uQ>\u0014\u0018\u000e^=\u0002\u0015\u0005,H\u000f[8sSRL\b\u0005\u0006\u0004\u0002\n\u00055\u0011q\u0002\t\u0004\u0003\u0017)Q\"A\u0001\t\u000bYT\u0001\u0019\u0001=\t\r\u0005\r!\u00021\u0001y\u0003\u0011\u0019w\u000e]=\u0015\r\u0005%\u0011QCA\f\u0011\u001d18\u0002%AA\u0002aD\u0001\"a\u0001\f!\u0003\u0005\r\u0001_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiBK\u0002y\u0003?Y#!!\t\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003WI\u0016AC1o]>$\u0018\r^5p]&!\u0011qFA\u0013\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0007\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0013\u0001\u00026bm\u0006L1A`A\u001e\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u0005E\u0002Y\u0003\u0017J1!!\u0014Z\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019&!\u0017\u0011\u0007a\u000b)&C\u0002\u0002Xe\u00131!\u00118z\u0011%\tY\u0006EA\u0001\u0002\u0004\tI%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003C\u0002b!a\u0019\u0002j\u0005MSBAA3\u0015\r\t9'W\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA6\u0003K\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011OA<!\rA\u00161O\u0005\u0004\u0003kJ&a\u0002\"p_2,\u0017M\u001c\u0005\n\u00037\u0012\u0012\u0011!a\u0001\u0003'\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qGA?\u0011%\tYfEA\u0001\u0002\u0004\tI%\u0001\u0005iCND7i\u001c3f)\t\tI%\u0001\u0005u_N#(/\u001b8h)\t\t9$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003c\nY\tC\u0005\u0002\\Y\t\t\u00111\u0001\u0002T\u0005a1i\u001c8oK\u000e$\u0018n\u001c8JIB\u0019\u00111\u0002\r\u0014\u000ba\t\u0019*a(\u0011\u0011\u0005U\u00151\u0014=y\u0003\u0013i!!a&\u000b\u0007\u0005e\u0015,A\u0004sk:$\u0018.\\3\n\t\u0005u\u0015q\u0013\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAQ\u0003Ok!!a)\u000b\t\u0005\u0015\u0016qH\u0001\u0003S>L1\u0001^AR)\t\ty)A\u0003baBd\u0017\u0010\u0006\u0004\u0002\n\u0005=\u0016\u0011\u0017\u0005\u0006mn\u0001\r\u0001\u001f\u0005\u0007\u0003\u0007Y\u0002\u0019\u0001=\u0002\u000fUt\u0017\r\u001d9msR!\u0011qWAb!\u0015A\u0016\u0011XA_\u0013\r\tY,\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000ba\u000by\f\u001f=\n\u0007\u0005\u0005\u0017L\u0001\u0004UkBdWM\r\u0005\n\u0003\u000bd\u0012\u0011!a\u0001\u0003\u0013\t1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tY\r\u0005\u0003\u0002:\u00055\u0017\u0002BAh\u0003w\u0011aa\u00142kK\u000e$(!\u0005%uiB\f4+Z:tS>t\u0007K]8ysN1adVAkO*\u00042\u0001VAl\u0013\r\tIN\u0013\u0002\u0013\u0011R$\b/M\"mS\u0016tGoU3tg&|g.\u0001\u0002jIV\u0011\u0011\u0011B\u0001\u0004S\u0012\u0004\u0013A\u00029be\u0016tG/\u0006\u0002\u0002V\u00069\u0001/\u0019:f]R\u0004CCBAu\u0003W\fi\u000fE\u0002\u0002\fyAq!a7$\u0001\u0004\tI\u0001C\u0004\u0002b\u000e\u0002\r!!6\u0002\u0011\u0011L7\u000f]1uG\"$B!a=\u0003\u001eA1\u0011Q_A~\u0003\u007fl!!a>\u000b\u0007\u0005e\u0018,\u0001\u0006d_:\u001cWO\u001d:f]RLA!!@\u0002x\n1a)\u001e;ve\u0016\u0004BA!\u0001\u0003\u00189!!1\u0001B\n\u001d\u0011\u0011)A!\u0005\u000f\t\t\u001d!q\u0002\b\u0005\u0005\u0013\u0011iAD\u0002n\u0005\u0017I\u0011!U\u0005\u0003\u001fBK!!\u0014(\n\u0005-c\u0015b\u0001B\u000b\u0015\u0006\t\u0002\n\u001e;q\u00072LWM\u001c;TKN\u001c\u0018n\u001c8\n\t\te!1\u0004\u0002\u0014%\u0016dW-Y:fC\ndWMU3ta>t7/\u001a\u0006\u0004\u0005+Q\u0005b\u0002B\u0010I\u0001\u0007!\u0011E\u0001\be\u0016\fX/Z:u!\r!&1E\u0005\u0004\u0005KQ%a\u0003%uiB\u0014V-];fgR\faa\u001d;biV\u001cXC\u0001B\u0016!\u0011\u0011\tA!\f\n\t\t=\"1\u0004\u0002\u0007'R\fG/^:\u0002\u000b\rdwn]3\u0015\t\tU\"Q\b\t\u0007\u0003k\fYPa\u000e\u0011\u0007a\u0013I$C\u0002\u0003<e\u0013A!\u00168ji\"9!q\b\u0014A\u0002\t\u0005\u0013AB<ji\"Lg\u000e\u0005\u0003\u0003D\t%SB\u0001B#\u0015\u0011\u00119%a>\u0002\u0011\u0011,(/\u0019;j_:LAAa\u0013\u0003F\tAA)\u001e:bi&|g\u000e\u0006\u0004\u0002j\n=#\u0011\u000b\u0005\n\u00037<\u0003\u0013!a\u0001\u0003\u0013A\u0011\"!9(!\u0003\u0005\r!!6\u0016\u0005\tU#\u0006BA\u0005\u0003?)\"A!\u0017+\t\u0005U\u0017q\u0004\u000b\u0005\u0003'\u0012i\u0006C\u0005\u0002\\1\n\t\u00111\u0001\u0002JQ!\u0011\u0011\u000fB1\u0011%\tYFLA\u0001\u0002\u0004\t\u0019\u0006\u0006\u0003\u00028\t\u0015\u0004\"CA._\u0005\u0005\t\u0019AA%)\u0011\t\tH!\u001b\t\u0013\u0005m#'!AA\u0002\u0005M\u0013!\u0005%uiB\f4+Z:tS>t\u0007K]8ysB\u0019\u00111\u0002\u001b\u0014\u000bQ\u0012\t(a(\u0011\u0015\u0005U\u00151TA\u0005\u0003+\fI\u000f\u0006\u0002\u0003nQ1\u0011\u0011\u001eB<\u0005sBq!a78\u0001\u0004\tI\u0001C\u0004\u0002b^\u0002\r!!6\u0015\t\tu$\u0011\u0011\t\u00061\u0006e&q\u0010\t\b1\u0006}\u0016\u0011BAk\u0011%\t)\rOA\u0001\u0002\u0004\tI\u000f\u0006\u0003\u0003\u0006\u000e-\u0002C\u0001+<'\u0011YtK!#\u0011\u0007Q\u0013Y)C\u0002\u0003\u000e*\u0013Ac\u00117jK:$8+Z:tS>tW*\u00198bO\u0016\u0014\u0018\u0001D:fgNLwN\\\"bG\",\u0007\u0003\u0003BJ\u00053\u0013iJ!)\u000e\u0005\tU%\u0002\u0002BL\u0003\u007f\tA!\u001e;jY&!!1\u0014BK\u0005\ri\u0015\r\u001d\t\u0004\u0005?+ab\u0001B\u0002\u0001A1!1\u0013BR\u0005OKAA!*\u0003\u0016\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0007Q\u0013I+C\u0002\u0003,*\u0013\u0011\u0003\u0013;ua\u000ec\u0017.\u001a8u'\u0016\u001c8/[8o\u0003\u0019\u0019wN\u001c4jOB\u0019AK!-\n\u0007\tM&J\u0001\tIiR\u00048\t\\5f]R\u001cuN\u001c4jOR1!Q\u0011B\\\u0005sCqAa$?\u0001\u0004\u0011\t\nC\u0004\u0003.z\u0002\rAa,\u0002\u000b\u001d,G/\u00133\u0015\t\tu%q\u0018\u0005\b\u0005\u0003|\u0004\u0019\u0001Bb\u0003-\u0019w.\u001c9pg&$\u0018n\u001c8\u0011\t\t\u0015'\u0011\u001b\b\u0005\u0005\u000f\u0014YM\u0004\u0003\u0003\u0004\t%\u0017b\u0001BL\u0015&!!Q\u001aBh\u0003!)&\u000f\u001c+p_2\u001c(b\u0001BL\u0015&!!1\u001bBk\u00059)&\u000f\\\"p[B|7/\u001b;j_:TAA!4\u0003P\u0006\u0011QmY\u000b\u0003\u00057\u0004B!!>\u0003^&!!q\\A|\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004m_\u001e<WM\u001d\t\u0005\u0005K\u0014Y/\u0004\u0002\u0003h*\u0019!\u0011\u001e)\u0002\u000b1|w\rN:\n\t\t5(q\u001d\u0002\u0007\u0019><w-\u001a:\u0002\u001bM|7m[3u\r\u0006\u001cGo\u001c:z!\u0011\u0011\u0019P!@\u000e\u0005\tU(\u0002\u0002B|\u0005s\fAA\\5pe)\u0019!1 '\u0002\u000f\rD\u0017M\u001c8fY&!!q B{\u0005Q\u0019E.[3oi\u000eC\u0017M\u001c8fY\u001a\u000b7\r^8ss\u0006q\u0011mY9vSJ,7+Z:tS>tG\u0003BB\u0003\u0007\u000f\u0001b!!>\u0002|\n\u001d\u0006b\u0002B\u0010\u0007\u0002\u0007!\u0011E\u0001\u0014M&tG-\u0012=jgRLgnZ*fgNLwN\u001c\u000b\u0005\u0005O\u001bi\u0001C\u0004\u0002\\\u0012\u0003\rA!(\u0002!\r\u0014X-\u0019;f\u001d\u0016<8+Z:tS>tGCBB\u0003\u0007'\u00199\u0002C\u0004\u0004\u0016\u0015\u0003\rAa1\u0002\u001dU\u0014HnQ8na>\u001c\u0018\u000e^5p]\"9\u00111\\#A\u0002\tu\u0015!\u0004:fiV\u0014hnU3tg&|g\u000e\u0006\u0003\u00038\ru\u0001bBB\u0010\r\u0002\u0007!qU\u0001\bg\u0016\u001c8/[8o)\t\u0011)$A\tbI\u0012\u001cVm]:j_:$vnQ1dQ\u0016$bAa\u000e\u0004(\r%\u0002bBAn\u0011\u0002\u0007!Q\u0014\u0005\b\u0007?A\u0005\u0019\u0001BT\u0011\u001d\u0011iK\u000fa\u0001\u0005_\u0003")
public final class ClientSessionManagerImpl
implements ClientSessionManager {
    private final Map<ConnectionId, Collection<HttpClientSession>> sessionCache;
    private final HttpClientConfig config;
    private final Logger logger;
    private final ClientChannelFactory socketFactory;
    private volatile byte bitmap$init$0;

    public static ClientSessionManagerImpl apply(HttpClientConfig httpClientConfig) {
        return ClientSessionManagerImpl$.MODULE$.apply(httpClientConfig);
    }

    private ConnectionId getId(UrlTools.UrlComposition composition) {
        return new ConnectionId(composition.scheme(), composition.authority());
    }

    private ExecutionContext ec() {
        return Execution$.MODULE$.trampoline();
    }

    @Override
    public Future<HttpClientSession> acquireSession(HttpRequest request) {
        Future future;
        Try<UrlTools.UrlComposition> try_;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(new StringBuilder(30).append("Acquiring session for request ").append(request).toString());
        }
        if ((try_ = UrlTools$UrlComposition$.MODULE$.apply(request.url())) instanceof Success) {
            Future future2;
            Success success = (Success)try_;
            UrlTools.UrlComposition urlComposition = (UrlTools.UrlComposition)success.value();
            ConnectionId id = this.getId(urlComposition);
            HttpClientSession session = this.findExistingSession(id);
            if (session == null) {
                future2 = this.createNewSession(urlComposition, id);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(new StringBuilder(27).append("Found hot session for id ").append(id).append(": ").append(session).toString());
                }
                future2 = Future$.MODULE$.successful((Object)session);
            }
            future = future2;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            future = Future$.MODULE$.failed(t);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    private HttpClientSession findExistingSession(ConnectionId id) {
        Http2ClientSession http2ClientSession;
        Map<ConnectionId, Collection<HttpClientSession>> map = this.sessionCache;
        synchronized (map) {
            Http2ClientSession http2ClientSession2;
            Collection<HttpClientSession> collection = this.sessionCache.get(id);
            if (collection == null) {
                http2ClientSession2 = null;
            } else {
                HttpClientSession session = null;
                java.util.Iterator<HttpClientSession> it = collection.iterator();
                while (session == null && it.hasNext()) {
                    BoxedUnit boxedUnit;
                    boolean bl = false;
                    Http2ClientSession http2ClientSession3 = null;
                    HttpClientSession httpClientSession = it.next();
                    if (httpClientSession instanceof Http2ClientSession) {
                        bl = true;
                        http2ClientSession3 = (Http2ClientSession)httpClientSession;
                        HttpClientSession.Status status = http2ClientSession3.status();
                        HttpClientSession$Closed$ httpClientSession$Closed$ = HttpClientSession$Closed$.MODULE$;
                        if (!(status != null ? !status.equals(httpClientSession$Closed$) : httpClientSession$Closed$ != null)) {
                            http2ClientSession3.closeNow();
                            it.remove();
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                    }
                    if (bl && ClientSessionManagerImpl$.MODULE$.org$http4s$blaze$http$ClientSessionManagerImpl$$LowQualityThreshold() < http2ClientSession3.quality()) {
                        session = http2ClientSession3;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (bl) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (httpClientSession instanceof Http1ClientSession) {
                        BoxedUnit boxedUnit2;
                        Http1ClientSession http1ClientSession = (Http1ClientSession)httpClientSession;
                        it.remove();
                        HttpClientSession.Status status = http1ClientSession.status();
                        HttpClientSession$Closed$ httpClientSession$Closed$ = HttpClientSession$Closed$.MODULE$;
                        if (status == null ? httpClientSession$Closed$ != null : !status.equals(httpClientSession$Closed$)) {
                            session = http1ClientSession;
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = http1ClientSession.closeNow();
                        }
                        boxedUnit = boxedUnit2;
                        continue;
                    }
                    throw new MatchError((Object)httpClientSession);
                }
                Object object = collection.isEmpty() ? this.sessionCache.remove(id) : BoxedUnit.UNIT;
                http2ClientSession2 = session;
            }
            http2ClientSession = http2ClientSession2;
        }
        return http2ClientSession;
    }

    private Future<HttpClientSession> createNewSession(UrlTools.UrlComposition urlComposition, ConnectionId id) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(new StringBuilder(28).append("Creating new session for id ").append(id).toString());
        }
        Promise p = Promise$.MODULE$.apply();
        this.socketFactory.connect((SocketAddress)urlComposition.getAddress(), this.socketFactory.connect$default$2()).onComplete((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClientSessionManagerImpl.$anonfun$createNewSession$1(this, p, urlComposition, id, x0$1)), this.ec());
        return p.future();
    }

    @Override
    public void returnSession(HttpClientSession session) {
        Http1ClientSession http1ClientSession;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(new StringBuilder(18).append("Returning session ").append(session).toString());
        }
        HttpClientSession httpClientSession = session;
        if (session.isClosed()) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (httpClientSession instanceof Http2ClientSession) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (httpClientSession instanceof Http1ClientSession && !(http1ClientSession = (Http1ClientSession)httpClientSession).isReady()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(new StringBuilder(24).append("Closing unready session ").append(http1ClientSession).toString());
            }
            http1ClientSession.closeNow().onComplete((Function1 & Serializable)x0$1 -> {
                ClientSessionManagerImpl.$anonfun$returnSession$1(this, session, x0$1);
                return BoxedUnit.UNIT;
            }, this.ec());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (httpClientSession instanceof Http1SessionProxy) {
            Http1SessionProxy http1SessionProxy = (Http1SessionProxy)httpClientSession;
            this.addSessionToCache(http1SessionProxy.id(), http1SessionProxy);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(45).append("The impossible happened! Found invalid type: ").append(httpClientSession).toString());
        }
    }

    @Override
    public Future<BoxedUnit> close() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Closing session");
        }
        Map<ConnectionId, Collection<HttpClientSession>> map = this.sessionCache;
        synchronized (map) {
            compat$.MODULE$.CollectionConverters().MapHasAsScala(this.sessionCache).asScala().values().foreach((Function1 & Serializable)x$1 -> {
                ClientSessionManagerImpl.$anonfun$close$1(this, x$1);
                return BoxedUnit.UNIT;
            });
            this.sessionCache.clear();
        }
        return package$.MODULE$.FutureUnit();
    }

    private void addSessionToCache(ConnectionId id, HttpClientSession session) {
        block5: {
            int n;
            Map<ConnectionId, Collection<HttpClientSession>> map = this.sessionCache;
            synchronized (map) {
                Collection<HttpClientSession> collection;
                Collection<HttpClientSession> collection2 = this.sessionCache.get(id);
                if (collection2 == null) {
                    Stack<HttpClientSession> stack = new Stack<HttpClientSession>();
                    this.sessionCache.put(id, stack);
                    collection = stack;
                } else {
                    collection = collection2;
                }
                Collection<HttpClientSession> collection3 = collection;
                collection3.add(session);
                n = collection3.size();
            }
            int size = n;
            if (!this.logger.isDebugEnabled()) break block5;
            this.logger.debug(new StringBuilder(37).append("Added session ").append(session).append(". Now ").append(size).append(" sessions for id ").append(id).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$createNewSession$1(ClientSessionManagerImpl $this, Promise p$1, UrlTools.UrlComposition urlComposition$1, ConnectionId id$1, Try x0$1) {
        boolean bl;
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            bl = p$1.tryFailure(e);
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            HeadStage head = (HeadStage)success.value();
            Http1ClientStage clientStage = new Http1ClientStage($this.config);
            LeafBuilder builder = LeafBuilder$.MODULE$.apply((TailStage)clientStage);
            if (urlComposition$1.scheme().equalsIgnoreCase("https")) {
                SSLEngine engine = $this.config.getClientSslEngine();
                engine.setUseClientMode(true);
                builder = builder.prepend((MidStage)new SSLStage(engine, SSLStage$.MODULE$.$lessinit$greater$default$2()));
            }
            builder.base(head);
            head.sendInboundCommand((Command.InboundCommand)Command.Connected$.MODULE$);
            bl = p$1.trySuccess((Object)new Http1SessionProxy(id$1, clientStage));
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$returnSession$1(ClientSessionManagerImpl $this, HttpClientSession session$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            if ($this.logger.isInfoEnabled()) {
                $this.logger.info(new StringBuilder(24).append("Failure closing session ").append(session$1).toString(), t);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$close$1(ClientSessionManagerImpl $this, Collection x$1) {
        compat$.MODULE$.CollectionConverters().CollectionHasAsScala(x$1).asScala().foreach((Function1 & Serializable)session -> {
            BoxedUnit boxedUnit;
            try {
                boxedUnit = session.closeNow();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                Throwable t = (Throwable)option.get();
                $this.logger.warn("Exception caught while closing session", t);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                boxedUnit = boxedUnit2;
            }
            return boxedUnit;
        });
    }

    public ClientSessionManagerImpl(Map<ConnectionId, Collection<HttpClientSession>> sessionCache, HttpClientConfig config) {
        this.sessionCache = sessionCache;
        this.config = config;
        this.logger = LoggerFactory.getLogger(ClientSessionManagerImpl.class);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        Option<AsynchronousChannelGroup> x$1 = config.channelGroup();
        int x$2 = ClientChannelFactory$.MODULE$.$lessinit$greater$default$1();
        ChannelOptions x$3 = ClientChannelFactory$.MODULE$.$lessinit$greater$default$3();
        TickWheelExecutor x$4 = ClientChannelFactory$.MODULE$.$lessinit$greater$default$4();
        Duration x$5 = ClientChannelFactory$.MODULE$.$lessinit$greater$default$5();
        this.socketFactory = new ClientChannelFactory(x$2, x$1, x$3, x$4, x$5);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public static class ConnectionId
    implements Product,
    Serializable {
        private final String scheme;
        private final String authority;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String scheme() {
            return this.scheme;
        }

        public String authority() {
            return this.authority;
        }

        public ConnectionId copy(String scheme, String authority) {
            return new ConnectionId(scheme, authority);
        }

        public String copy$default$1() {
            return this.scheme();
        }

        public String copy$default$2() {
            return this.authority();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.scheme();
                    break;
                }
                case 1: {
                    object = this.authority();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "scheme";
                    break;
                }
                case 1: {
                    string = "authority";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConnectionId)) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.scheme();
            String string2 = connectionId.scheme();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.authority();
            String string4 = connectionId.authority();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public ConnectionId(String scheme, String authority) {
            this.scheme = scheme;
            this.authority = authority;
            Product.$init$((Product)this);
        }
    }

    public static class Http1SessionProxy
    implements Http1ClientSession,
    Product,
    Serializable {
        private final ConnectionId id;
        private final Http1ClientSession parent;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public final boolean isReady() {
            return HttpClientSession.isReady$(this);
        }

        @Override
        public final boolean isClosed() {
            return HttpClientSession.isClosed$(this);
        }

        @Override
        public final Future<BoxedUnit> closeNow() {
            return HttpClientSession.closeNow$(this);
        }

        public ConnectionId id() {
            return this.id;
        }

        public Http1ClientSession parent() {
            return this.parent;
        }

        @Override
        public Future<HttpClientSession.ReleaseableResponse> dispatch(HttpRequest request) {
            return this.parent().dispatch(request);
        }

        @Override
        public HttpClientSession.Status status() {
            return this.parent().status();
        }

        @Override
        public Future<BoxedUnit> close(Duration within) {
            return this.parent().close(within);
        }

        public Http1SessionProxy copy(ConnectionId id, Http1ClientSession parent) {
            return new Http1SessionProxy(id, parent);
        }

        public ConnectionId copy$default$1() {
            return this.id();
        }

        public Http1ClientSession copy$default$2() {
            return this.parent();
        }

        public String productPrefix() {
            return "Http1SessionProxy";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.id();
                    break;
                }
                case 1: {
                    object = this.parent();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Http1SessionProxy;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "id";
                    break;
                }
                case 1: {
                    string = "parent";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Http1SessionProxy)) return false;
            boolean bl = true;
            if (!bl) return false;
            Http1SessionProxy http1SessionProxy = (Http1SessionProxy)x$1;
            ConnectionId connectionId = this.id();
            ConnectionId connectionId2 = http1SessionProxy.id();
            if (connectionId == null) {
                if (connectionId2 != null) {
                    return false;
                }
            } else if (!((Object)connectionId).equals(connectionId2)) return false;
            Http1ClientSession http1ClientSession = this.parent();
            Http1ClientSession http1ClientSession2 = http1SessionProxy.parent();
            if (http1ClientSession == null) {
                if (http1ClientSession2 != null) {
                    return false;
                }
            } else if (!http1ClientSession.equals(http1ClientSession2)) return false;
            if (!http1SessionProxy.canEqual(this)) return false;
            return true;
        }

        public Http1SessionProxy(ConnectionId id, Http1ClientSession parent) {
            this.id = id;
            this.parent = parent;
            HttpClientSession.$init$(this);
            Product.$init$((Product)this);
        }
    }
}

