/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http1.client;

import java.io.Serializable;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.channel.nio2.ClientChannelFactory;
import org.http4s.blaze.channel.nio2.ClientChannelFactory$;
import org.http4s.blaze.http.ClientSessionManager;
import org.http4s.blaze.http.HttpClientConfig;
import org.http4s.blaze.http.HttpClientSession;
import org.http4s.blaze.http.HttpRequest;
import org.http4s.blaze.http.http1.client.Http1ClientStage;
import org.http4s.blaze.http.util.UrlTools;
import org.http4s.blaze.http.util.UrlTools$UrlComposition$;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.LeafBuilder$;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.pipeline.stages.SSLStage;
import org.http4s.blaze.pipeline.stages.SSLStage$;
import org.http4s.blaze.util.Execution$;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blaze.util.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005}4Q!\u0003\u0006\u0003\u001dYA\u0001\"\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\u0006M\u0001!\ta\n\u0005\u0007W\u0001\u0001\u000b\u0011\u0002\u0017\t\rI\u0002\u0001\u0015!\u00034\u0011\u0015Y\u0004\u0001\"\u0011=\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015)\u0006\u0001\"\u0003W\u0005y\u0011\u0015m]5d\u0011R$\b/M\"mS\u0016tGoU3tg&|g.T1oC\u001e,'O\u0003\u0002\f\u0019\u000511\r\\5f]RT!!\u0004\b\u0002\u000b!$H\u000f]\u0019\u000b\u0005=\u0001\u0012\u0001\u00025uiBT!!\u0005\n\u0002\u000b\td\u0017M_3\u000b\u0005M!\u0012A\u00025uiB$4OC\u0001\u0016\u0003\ry'oZ\n\u0004\u0001]i\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0005\u0002\u001f?5\ta\"\u0003\u0002!\u001d\t!2\t\\5f]R\u001cVm]:j_:l\u0015M\\1hKJ\faaY8oM&<7\u0001\u0001\t\u0003=\u0011J!!\n\b\u0003!!#H\u000f]\"mS\u0016tGoQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u0002)UA\u0011\u0011\u0006A\u0007\u0002\u0015!)\u0011E\u0001a\u0001G\u00051An\\4hKJ\u0004\"!\f\u0019\u000e\u00039R!a\f\u000b\u0002\u000b1|w\rN:\n\u0005Er#A\u0002'pO\u001e,'/A\u0004gC\u000e$xN]=\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014\u0001\u00028j_JR!\u0001\u000f\t\u0002\u000f\rD\u0017M\u001c8fY&\u0011!(\u000e\u0002\u0015\u00072LWM\u001c;DQ\u0006tg.\u001a7GC\u000e$xN]=\u0002\u001d\u0005\u001c\u0017/^5sKN+7o]5p]R\u0011QH\u0012\t\u0004}\u0005\u001bU\"A \u000b\u0005\u0001K\u0012AC2p]\u000e,(O]3oi&\u0011!i\u0010\u0002\u0007\rV$XO]3\u0011\u0005y!\u0015BA#\u000f\u0005EAE\u000f\u001e9DY&,g\u000e^*fgNLwN\u001c\u0005\u0006\u000f\u0016\u0001\r\u0001S\u0001\be\u0016\fX/Z:u!\tq\u0012*\u0003\u0002K\u001d\tY\u0001\n\u001e;q%\u0016\fX/Z:u\u00035\u0011X\r^;s]N+7o]5p]R\u0011Q\n\u0015\t\u000319K!aT\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006#\u001a\u0001\raQ\u0001\bg\u0016\u001c8/[8o\u0003\u0015\u0019Gn\\:f)\u0005!\u0006c\u0001 B\u001b\u0006y1m\u001c8oK\u000e$\b+\u001b9fY&tW\rF\u0002D/>DQ\u0001\u0017\u0005A\u0002e\u000b1!\u001e:m!\tQFN\u0004\u0002\\S:\u0011Al\u001a\b\u0003;\u001at!AX3\u000f\u0005}#gB\u00011d\u001b\u0005\t'B\u00012#\u0003\u0019a$o\\8u}%\tQ#\u0003\u0002\u0014)%\u0011\u0011CE\u0005\u0003\u001fAI!\u0001\u001b\b\u0002\tU$\u0018\u000e\\\u0005\u0003U.\f\u0001\"\u0016:m)>|Gn\u001d\u0006\u0003Q:I!!\u001c8\u0003\u001dU\u0013HnQ8na>\u001c\u0018\u000e^5p]*\u0011!n\u001b\u0005\u0006a\"\u0001\r!]\u0001\u0005Q\u0016\fG\rE\u0002sk^l\u0011a\u001d\u0006\u0003iB\t\u0001\u0002]5qK2Lg.Z\u0005\u0003mN\u0014\u0011\u0002S3bIN#\u0018mZ3\u0011\u0005alX\"A=\u000b\u0005i\\\u0018a\u00018j_*\tA0\u0001\u0003kCZ\f\u0017B\u0001@z\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d")
public final class BasicHttp1ClientSessionManager
implements ClientSessionManager {
    private final HttpClientConfig config;
    private final Logger logger;
    private final ClientChannelFactory factory;
    private volatile byte bitmap$init$0;

    @Override
    public Future<HttpClientSession> acquireSession(HttpRequest request) {
        Future future;
        Try<UrlTools.UrlComposition> try_ = UrlTools$UrlComposition$.MODULE$.apply(request.url());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            UrlTools.UrlComposition composition = (UrlTools.UrlComposition)success.value();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(new StringBuilder(0).append(new StringBuilder(43).append("Attempting to acquire session for address ").append(request.url()).append(" ").toString()).append(new StringBuilder(23).append("with url decomposition ").append(composition).toString()).toString());
            }
            future = this.factory.connect((SocketAddress)composition.getAddress(), this.factory.connect$default$2()).map((Function1 & Serializable)x$1 -> this.connectPipeline(composition, (HeadStage<ByteBuffer>)x$1), Execution$.MODULE$.directec());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            this.logger.debug("Failed to build valid request", t);
            future = Future$.MODULE$.failed(t);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    @Override
    public void returnSession(HttpClientSession session) {
        session.close((Duration)Duration$.MODULE$.Zero());
    }

    @Override
    public Future<BoxedUnit> close() {
        return package$.MODULE$.FutureUnit();
    }

    /*
     * WARNING - void declaration
     */
    private HttpClientSession connectPipeline(UrlTools.UrlComposition url, HeadStage<ByteBuffer> head) {
        void var3_3;
        Http1ClientStage clientStage = new Http1ClientStage(this.config);
        LeafBuilder builder = LeafBuilder$.MODULE$.apply((TailStage)clientStage);
        if (url.isTls()) {
            builder = builder.prepend((MidStage)new SSLStage(this.config.getClientSslEngine(), SSLStage$.MODULE$.$lessinit$greater$default$2()));
        }
        builder.base(head);
        head.sendInboundCommand((Command.InboundCommand)Command.Connected$.MODULE$);
        return var3_3;
    }

    public BasicHttp1ClientSessionManager(HttpClientConfig config) {
        this.config = config;
        this.logger = LoggerFactory.getLogger(BasicHttp1ClientSessionManager.class);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        Option<AsynchronousChannelGroup> x$1 = config.channelGroup();
        int x$2 = ClientChannelFactory$.MODULE$.$lessinit$greater$default$1();
        ChannelOptions x$3 = ClientChannelFactory$.MODULE$.$lessinit$greater$default$3();
        TickWheelExecutor x$4 = ClientChannelFactory$.MODULE$.$lessinit$greater$default$4();
        Duration x$5 = ClientChannelFactory$.MODULE$.$lessinit$greater$default$5();
        this.factory = new ClientChannelFactory(x$2, x$1, x$3, x$4, x$5);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

