/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.BufferUnderflow$;
import org.http4s.blaze.http.http2.Continue$;
import org.http4s.blaze.http.http2.Error;
import org.http4s.blaze.http.http2.FrameDecoder$;
import org.http4s.blaze.http.http2.FrameListener;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.MaybeError;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.http.http2.Priority$NoPriority$;
import org.http4s.blaze.http.http2.Result;
import org.http4s.blaze.http.http2.SettingsDecoder;
import org.http4s.blaze.http.http2.SettingsDecoder$;
import org.http4s.blaze.http.http2.bits$;
import org.http4s.blaze.http.http2.bits$Flags$;
import org.http4s.blaze.http.http2.bits$FrameTypes$;
import org.http4s.blaze.http.http2.bits$Masks$;
import scala.MatchError;
import scala.Option;
import scala.Tuple4;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005%d\u0001B\r\u001b\t\u0015B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!)Q\u0007\u0001C\u0001m!)!\b\u0001C\u0003w!1\u0011\n\u0001Q\u0005\n)CQ\u0001\u0014\u0001\u0005\u00025Caa\u0017\u0001!\n\u0013a\u0006B\u00021\u0001A\u0013%\u0011\r\u0003\u0004f\u0001\u0001&IA\u001a\u0005\u0007S\u0002\u0001K\u0011\u00026\t\r5\u0004\u0001\u0015\"\u0003o\u0011\u0019\u0011\b\u0001)C\u0005g\"1q\u000f\u0001Q\u0005\naDa\u0001 \u0001!\n\u0013i\b\u0002CA\u0001\u0001\u0001&I!a\u0001\t\u0011\u0005%\u0001\u0001)C\u0005\u0003\u00179q!a\u0005\u001b\u0011\u0013\t)B\u0002\u0004\u001a5!%\u0011q\u0003\u0005\u0007kI!\t!!\u0007\t\u000f\u0005m!\u0003\"\u0001\u0002\u001e!9\u0011\u0011\u0005\n\u0005\u0002\u0005\r\u0002bBA\u0014%\u0011%\u0011\u0011\u0006\u0005\b\u0003w\u0011B\u0011BA\u001f\u0011\u001d\tYE\u0005C\u0001\u0003\u001b\u0012AB\u0012:b[\u0016$UmY8eKJT!a\u0007\u000f\u0002\u000b!$H\u000f\u001d\u001a\u000b\u0005uq\u0012\u0001\u00025uiBT!a\b\u0011\u0002\u000b\td\u0017M_3\u000b\u0005\u0005\u0012\u0013A\u00025uiB$4OC\u0001$\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VMZ\u0001\u000eY>\u001c\u0017\r\\*fiRLgnZ:\u0011\u00059zS\"\u0001\u000e\n\u0005AR\"!\u0004%uiB\u00144+\u001a;uS:<7/\u0001\u0005mSN$XM\\3s!\tq3'\u0003\u000255\tiaI]1nK2K7\u000f^3oKJ\fa\u0001P5oSRtDcA\u001c9sA\u0011a\u0006\u0001\u0005\u0006Y\r\u0001\r!\f\u0005\u0006c\r\u0001\rAM\u0001\rI\u0016\u001cw\u000eZ3Ck\u001a4WM\u001d\u000b\u0003y}\u0002\"AL\u001f\n\u0005yR\"A\u0002*fgVdG\u000fC\u0003A\t\u0001\u0007\u0011)\u0001\u0004ck\u001a4WM\u001d\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000b1A\\5p\u0015\u00051\u0015\u0001\u00026bm\u0006L!\u0001S\"\u0003\u0015\tKH/\u001a\"vM\u001a,'/\u0001\be_\u0012+7m\u001c3f\u0005V4g-\u001a:\u0015\u0005qZ\u0005\"\u0002!\u0006\u0001\u0004\t\u0015\u0001E8o\u000bb$XM\\:j_:4%/Y7f)\u0015adj\u0015-[\u0011\u0015ye\u00011\u0001Q\u0003\u0011\u0019w\u000eZ3\u0011\u0005\u001d\n\u0016B\u0001*)\u0005\u0011\u0011\u0015\u0010^3\t\u000bQ3\u0001\u0019A+\u0002\u0011M$(/Z1n\u0013\u0012\u0004\"a\n,\n\u0005]C#aA%oi\")\u0011L\u0002a\u0001!\u0006)a\r\\1hg\")\u0001I\u0002a\u0001\u0003\u0006yA-Z2pI\u0016$\u0015\r^1Ge\u0006lW\r\u0006\u0003=;z{\u0006\"\u0002!\b\u0001\u0004\t\u0005\"\u0002+\b\u0001\u0004)\u0006\"B-\b\u0001\u0004\u0001\u0016!\u00053fG>$W\rS3bI\u0016\u0014hI]1nKR!AHY2e\u0011\u0015\u0001\u0005\u00021\u0001B\u0011\u0015!\u0006\u00021\u0001V\u0011\u0015I\u0006\u00021\u0001Q\u0003M!WmY8eKB\u0013\u0018n\u001c:jif4%/Y7f)\rat\r\u001b\u0005\u0006\u0001&\u0001\r!\u0011\u0005\u0006)&\u0001\r!V\u0001\u0015I\u0016\u001cw\u000eZ3SgR\u001cFO]3b[\u001a\u0013\u0018-\\3\u0015\u0007qZG\u000eC\u0003A\u0015\u0001\u0007\u0011\tC\u0003U\u0015\u0001\u0007Q+A\neK\u000e|G-Z*fiRLgnZ:Ge\u0006lW\r\u0006\u0003=_B\f\b\"\u0002!\f\u0001\u0004\t\u0005\"\u0002+\f\u0001\u0004)\u0006\"B-\f\u0001\u0004\u0001\u0016A\u00063fG>$W\rU;tQB\u0013x.\\5tK\u001a\u0013\u0018-\\3\u0015\tq\"XO\u001e\u0005\u0006\u00012\u0001\r!\u0011\u0005\u0006)2\u0001\r!\u0016\u0005\u000632\u0001\r\u0001U\u0001\u0010I\u0016\u001cw\u000eZ3QS:<gI]1nKR!A(\u001f>|\u0011\u0015\u0001U\u00021\u0001B\u0011\u0015!V\u00021\u0001V\u0011\u0015IV\u00021\u0001Q\u0003E!WmY8eK\u001e{\u0017i^1z\rJ\fW.\u001a\u000b\u0004yy|\b\"\u0002!\u000f\u0001\u0004\t\u0005\"\u0002+\u000f\u0001\u0004)\u0016a\u00063fG>$WmV5oI><X\u000b\u001d3bi\u00164%/Y7f)\u0015a\u0014QAA\u0004\u0011\u0015\u0001u\u00021\u0001B\u0011\u0015!v\u00021\u0001V\u0003]!WmY8eK\u000e{g\u000e^5ok\u0006$\u0018n\u001c8Ge\u0006lW\rF\u0004=\u0003\u001b\ty!!\u0005\t\u000b\u0001\u0003\u0002\u0019A!\t\u000bQ\u0003\u0002\u0019A+\t\u000be\u0003\u0002\u0019\u0001)\u0002\u0019\u0019\u0013\u0018-\\3EK\u000e|G-\u001a:\u0011\u00059\u00122C\u0001\n')\t\t)\"\u0001\bhKRdUM\\4uQ\u001aKW\r\u001c3\u0015\u0007U\u000by\u0002C\u0003A)\u0001\u0007\u0011)A\u0006hKR\u001cFO]3b[&#GcA+\u0002&!)\u0001)\u0006a\u0001\u0003\u0006Yq-\u001a;Qe&|'/\u001b;z)\u0011\tY#!\u000f\u0011\t\u00055\u00121\u0007\b\u0004]\u0005=\u0012bAA\u00195\u0005A\u0001K]5pe&$\u00180\u0003\u0003\u00026\u0005]\"!\u0003#fa\u0016tG-\u001a8u\u0015\r\t\tD\u0007\u0005\u0006\u0001Z\u0001\r!Q\u0001\rY&l\u0017\u000e\u001e)bI\u0012Lgn\u001a\u000b\u0007\u0003\u007f\t)%!\u0013\u0011\u00079\n\t%C\u0002\u0002Di\u0011!\"T1zE\u0016,%O]8s\u0011\u0019\t9e\u0006a\u0001+\u00069\u0001/\u00193eS:<\u0007\"\u0002!\u0018\u0001\u0004\t\u0015A\u00025fqN#(\u000f\u0006\u0003\u0002P\u0005\u0015\u0004\u0003BA)\u0003?rA!a\u0015\u0002\\A\u0019\u0011Q\u000b\u0015\u000e\u0005\u0005]#bAA-I\u00051AH]8pizJ1!!\u0018)\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011MA2\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\f\u0015\t\r\u0005\u001d\u0004\u00041\u0001V\u0003\u0005I\u0007")
public class FrameDecoder {
    private final Http2Settings localSettings;
    private final FrameListener listener;

    public static String hexStr(int n) {
        return FrameDecoder$.MODULE$.hexStr(n);
    }

    public static int getStreamId(ByteBuffer byteBuffer) {
        return FrameDecoder$.MODULE$.getStreamId(byteBuffer);
    }

    public static int getLengthField(ByteBuffer byteBuffer) {
        return FrameDecoder$.MODULE$.getLengthField(byteBuffer);
    }

    public final Result decodeBuffer(ByteBuffer buffer) {
        return buffer.remaining() < bits$.MODULE$.HeaderSize() ? BufferUnderflow$.MODULE$ : this.doDecodeBuffer(buffer);
    }

    private Result doDecodeBuffer(ByteBuffer buffer) {
        Result result;
        buffer.mark();
        int len = FrameDecoder$.MODULE$.getLengthField(buffer);
        byte frameType = buffer.get();
        byte flags = buffer.get();
        int streamId = FrameDecoder$.MODULE$.getStreamId(buffer);
        if (this.localSettings.maxFrameSize() < len) {
            result = new Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(new StringBuilder(45).append("HTTP2 packet is too large to handle. Stream: ").append(streamId).toString()));
        } else if (frameType != bits$FrameTypes$.MODULE$.CONTINUATION() && this.listener.inHeaderSequence()) {
            String msg = new StringBuilder(46).append("Received frame type ").append(FrameDecoder$.MODULE$.hexStr(frameType)).append(" while in HEADERS sequence").toString();
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg));
        } else if (frameType == bits$FrameTypes$.MODULE$.CONTINUATION() && !this.listener.inHeaderSequence()) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Received CONTINUATION frame outside of a HEADERS sequence"));
        } else if (buffer.remaining() < len) {
            buffer.reset();
            result = BufferUnderflow$.MODULE$;
        } else {
            int oldLimit = buffer.limit();
            int endOfFrame = buffer.position() + len;
            buffer.limit(endOfFrame);
            try {
                try {
                    byte by = frameType;
                    Result result2 = bits$FrameTypes$.MODULE$.DATA() == by ? this.decodeDataFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.HEADERS() == by ? this.decodeHeaderFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.PRIORITY() == by ? this.decodePriorityFrame(buffer, streamId) : (bits$FrameTypes$.MODULE$.RST_STREAM() == by ? this.decodeRstStreamFrame(buffer, streamId) : (bits$FrameTypes$.MODULE$.SETTINGS() == by ? this.decodeSettingsFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.PUSH_PROMISE() == by ? this.decodePushPromiseFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.PING() == by ? this.decodePingFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.GOAWAY() == by ? this.decodeGoAwayFrame(buffer, streamId) : (bits$FrameTypes$.MODULE$.WINDOW_UPDATE() == by ? this.decodeWindowUpdateFrame(buffer, streamId) : (bits$FrameTypes$.MODULE$.CONTINUATION() == by ? this.decodeContinuationFrame(buffer, streamId, flags) : this.onExtensionFrame(by, streamId, flags, buffer.slice()))))))))));
                    result = result2;
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    result = new Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(new StringBuilder(33).append("Frame type ").append(FrameDecoder$.MODULE$.hexStr(frameType)).append(" and size ").append(len).append(" underflowed").toString()));
                }
            }
            finally {
                buffer.limit(oldLimit);
                buffer.position(endOfFrame);
            }
        }
        return result;
    }

    public Result onExtensionFrame(byte code, int streamId, byte flags, ByteBuffer buffer) {
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToByte((byte)code), (Object)BoxesRunTime.boxToInteger((int)streamId), (Object)BoxesRunTime.boxToByte((byte)flags), (Object)buffer);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        return Continue$.MODULE$;
    }

    private Result decodeDataFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        if (streamId == 0) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Data frame with stream id 0x0"));
        } else {
            MaybeError maybeError;
            int flowBytes = buffer.remaining();
            if (!bits$Flags$.MODULE$.PADDED(flags)) {
                maybeError = Continue$.MODULE$;
            } else {
                int padding = buffer.get() & 0xFF;
                maybeError = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$limitPadding(padding, buffer);
            }
            Continue$ r = maybeError;
            result = !r.success() ? r : this.listener.onDataFrame(streamId, bits$Flags$.MODULE$.END_STREAM(flags), buffer.slice(), flowBytes);
        }
        return result;
    }

    private Result decodeHeaderFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        if (streamId == 0) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Headers frame with stream id 0x0"));
        } else {
            int padding = !bits$Flags$.MODULE$.PADDED(flags) ? 0 : buffer.get() & 0xFF;
            Priority$NoPriority$ priority = !bits$Flags$.MODULE$.PRIORITY(flags) ? Priority$NoPriority$.MODULE$ : FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$getPriority(buffer);
            MaybeError r = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$limitPadding(padding, buffer);
            if (!r.success()) {
                result = r;
            } else {
                Priority.Dependent dependent;
                int dep;
                Priority$NoPriority$ priority$NoPriority$ = priority;
                Result result2 = priority$NoPriority$ instanceof Priority.Dependent && (dep = (dependent = (Priority.Dependent)((Object)priority$NoPriority$)).dependentStreamId()) == streamId ? new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(36).append("Header stream id ").append(FrameDecoder$.MODULE$.hexStr(streamId)).append(" depends on itself.").toString())) : this.listener.onHeadersFrame(streamId, priority, bits$Flags$.MODULE$.END_HEADERS(flags), bits$Flags$.MODULE$.END_STREAM(flags), buffer.slice());
                result = result2;
            }
        }
        return result;
    }

    private Result decodePriorityFrame(ByteBuffer buffer, int streamId) {
        Result result;
        if (streamId == 0) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Priority frame with stream id 0x0"));
        } else if (buffer.remaining() != 5) {
            String msg = new StringBuilder(49).append("Invalid PRIORITY frame size, required 5, received").append(buffer.remaining()).toString();
            result = new Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().rst(streamId, msg));
        } else {
            Priority.Dependent priority = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$getPriority(buffer);
            result = priority.dependentStreamId() == streamId ? new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(streamId, "Priority frame depends on itself")) : this.listener.onPriorityFrame(streamId, priority);
        }
        return result;
    }

    private Result decodeRstStreamFrame(ByteBuffer buffer, int streamId) {
        Result result;
        if (streamId == 0) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("RST_STREAM frame with stream id 0x0"));
        } else if (buffer.remaining() != 4) {
            String msg = new StringBuilder(58).append("Invalid RST_STREAM frame size. Required 4 bytes, received ").append(buffer.remaining()).toString();
            result = new Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(msg));
        } else {
            long code = (long)buffer.getInt() & bits$Masks$.MODULE$.INT32();
            result = this.listener.onRstStreamFrame(streamId, code);
        }
        return result;
    }

    private Result decodeSettingsFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        Right right;
        SettingsDecoder.SettingsFrame settingsFrame;
        Either<Http2Exception, SettingsDecoder.SettingsFrame> either = SettingsDecoder$.MODULE$.decodeSettingsFrame(buffer, streamId, flags);
        if (either instanceof Right && (settingsFrame = (SettingsDecoder.SettingsFrame)(right = (Right)either).value()) != null) {
            Option<Seq<Http2Settings.Setting>> settings = settingsFrame.settings();
            result = this.listener.onSettingsFrame(settings);
        } else if (either instanceof Left) {
            Left left = (Left)either;
            Http2Exception ex = (Http2Exception)left.value();
            result = new Error(ex);
        } else {
            throw new MatchError(either);
        }
        return result;
    }

    private Result decodePushPromiseFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        if (streamId == 0) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("PUSH_PROMISE frame with stream id 0x0"));
        } else {
            MaybeError r;
            int padding = !bits$Flags$.MODULE$.PADDED(flags) ? 0 : buffer.get() & 0xFF;
            int promisedId = FrameDecoder$.MODULE$.getStreamId(buffer);
            result = promisedId == 0 ? new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("PUSH_PROMISE frame with promised stream id 0x0")) : (promisedId == streamId ? new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(59).append("PUSH_PROMISE frame with promised stream of the same stream ").append(FrameDecoder$.MODULE$.hexStr(streamId)).toString())) : (!(r = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$limitPadding(padding, buffer)).success() ? r : this.listener.onPushPromiseFrame(streamId, promisedId, bits$Flags$.MODULE$.END_HEADERS(flags), buffer.slice())));
        }
        return result;
    }

    private Result decodePingFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        int PingSize = 8;
        if (streamId != 0) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(33).append("PING frame with stream id ").append(FrameDecoder$.MODULE$.hexStr(streamId)).append(" != 0x0").toString()));
        } else if (buffer.remaining() != PingSize) {
            String msg = new StringBuilder(46).append("Invalid PING frame size. Expected 8, received ").append(buffer.remaining()).toString();
            result = new Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(msg));
        } else {
            byte[] pingBytes = new byte[PingSize];
            buffer.get(pingBytes);
            result = this.listener.onPingFrame(bits$Flags$.MODULE$.ACK(flags), pingBytes);
        }
        return result;
    }

    private Result decodeGoAwayFrame(ByteBuffer buffer, int streamId) {
        Result result;
        if (streamId != 0) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(36).append("GOAWAY frame with stream id ").append(FrameDecoder$.MODULE$.hexStr(streamId)).append(" != 0x0.").toString()));
        } else {
            int lastStream = bits$Flags$.MODULE$.DepID(buffer.getInt());
            long code = (long)buffer.getInt() & bits$Masks$.MODULE$.INT32();
            byte[] data = new byte[buffer.remaining()];
            buffer.get(data);
            result = this.listener.onGoAwayFrame(lastStream, code, data);
        }
        return result;
    }

    private Result decodeWindowUpdateFrame(ByteBuffer buffer, int streamId) {
        Result result;
        if (buffer.remaining() != 4) {
            result = new Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(new StringBuilder(56).append("WindowUpdate with invalid frame size. Expected 4, found ").append(buffer.remaining()).toString()));
        } else {
            int size = buffer.getInt() & bits$Masks$.MODULE$.INT31();
            if (size != 0) {
                result = this.listener.onWindowUpdateFrame(streamId, size);
            } else {
                String msg = "WINDOW_UPDATE with invalid update size 0";
                Http2Exception http2Exception = streamId == 0 ? Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg) : Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(streamId, msg);
                result = new Error(http2Exception);
            }
        }
        return result;
    }

    private Result decodeContinuationFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        if (streamId == 0) {
            String msg = "CONTINUATION frame with invalid stream dependency on 0x0";
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg));
        } else {
            result = this.listener.onContinuationFrame(streamId, bits$Flags$.MODULE$.END_HEADERS(flags), buffer.slice());
        }
        return result;
    }

    public FrameDecoder(Http2Settings localSettings, FrameListener listener) {
        this.localSettings = localSettings;
        this.listener = listener;
    }
}

