/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2.client;

import java.io.Serializable;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import javax.net.ssl.SSLEngine;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.channel.nio2.ClientChannelFactory;
import org.http4s.blaze.channel.nio2.ClientChannelFactory$;
import org.http4s.blaze.http.ALPNTokens$;
import org.http4s.blaze.http.ClientSessionManager;
import org.http4s.blaze.http.Http2ClientSession;
import org.http4s.blaze.http.HttpClientConfig;
import org.http4s.blaze.http.HttpClientSession;
import org.http4s.blaze.http.HttpClientSession$Ready$;
import org.http4s.blaze.http.HttpRequest;
import org.http4s.blaze.http.http2.DefaultFlowStrategy;
import org.http4s.blaze.http.http2.ImmutableHttp2Settings;
import org.http4s.blaze.http.http2.client.ALPNClientSelector;
import org.http4s.blaze.http.http2.client.ClientPriorKnowledgeHandshaker;
import org.http4s.blaze.http.http2.client.Http2ClientSessionManagerImpl$;
import org.http4s.blaze.http.util.UrlTools;
import org.http4s.blaze.http.util.UrlTools$UrlComposition$;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.LeafBuilder$;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.pipeline.stages.SSLStage;
import org.http4s.blaze.pipeline.stages.SSLStage$;
import org.http4s.blaze.util.Execution$;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blaze.util.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Map;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005}s!B\t\u0013\u0011\u0003yb!B\u0011\u0013\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003\"B\u0016\u0002\t\u0003ac!B\u0011\u0013\u0001Yq\u0003\u0002C\u001a\u0005\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011]\"!\u0011!Q\u0001\naB\u0001\u0002\u0010\u0003\u0003\u0002\u0003\u0006I!\u0010\u0005\u0006S\u0011!\t!\u0017\u0005\u0007;\u0012\u0001\u000b\u0011\u00020\t\r\u0011$\u0001\u0015!\u0003f\u0011\u0015iG\u0001\"\u0011o\u0011\u0015AH\u0001\"\u0011z\u0011\u0015qH\u0001\"\u0011\u0000\u0011!\t)\u0001\u0002Q\u0005\n\u0005\u001d\u0001BB7\u0005\t#\t\u0019\u0004C\u0004\u00028\u0011!\t\"!\u000f\u0002;!#H\u000f\u001d\u001aDY&,g\u000e^*fgNLwN\\'b]\u0006<WM]%na2T!a\u0005\u000b\u0002\r\rd\u0017.\u001a8u\u0015\t)b#A\u0003iiR\u0004(G\u0003\u0002\u00181\u0005!\u0001\u000e\u001e;q\u0015\tI\"$A\u0003cY\u0006TXM\u0003\u0002\u001c9\u00051\u0001\u000e\u001e;qiMT\u0011!H\u0001\u0004_J<7\u0001\u0001\t\u0003A\u0005i\u0011A\u0005\u0002\u001e\u0011R$\bOM\"mS\u0016tGoU3tg&|g.T1oC\u001e,'/S7qYN\u0011\u0011a\t\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0012!B1qa2LH#B\u0017\u0002\\\u0005u\u0003C\u0001\u0011\u0005'\r!1e\f\t\u0003aEj\u0011AF\u0005\u0003eY\u0011Ac\u00117jK:$8+Z:tS>tW*\u00198bO\u0016\u0014\u0018AB2p]\u001aLw\r\u0005\u00021k%\u0011aG\u0006\u0002\u0011\u0011R$\bo\u00117jK:$8i\u001c8gS\u001e\fq\"\u001b8ji&\fGnU3ui&twm\u001d\t\u0003sij\u0011\u0001F\u0005\u0003wQ\u0011a#S7nkR\f'\r\\3IiR\u0004(gU3ui&twm]\u0001\rg\u0016\u001c8/[8o\u0007\u0006\u001c\u0007.\u001a\t\u0005}\r+\u0005+D\u0001@\u0015\t\u0001\u0015)A\u0004nkR\f'\r\\3\u000b\u0005\t+\u0013AC2pY2,7\r^5p]&\u0011Ai\u0010\u0002\u0004\u001b\u0006\u0004\bC\u0001$N\u001d\t95\n\u0005\u0002IK5\t\u0011J\u0003\u0002K=\u00051AH]8pizJ!\u0001T\u0013\u0002\rA\u0013X\rZ3g\u0013\tquJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0019\u0016\u00022!\u0015+W\u001b\u0005\u0011&BA*&\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003+J\u0013aAR;ukJ,\u0007C\u0001\u0019X\u0013\tAfC\u0001\nIiR\u0004(g\u00117jK:$8+Z:tS>tG\u0003B\u0017[7rCQa\r\u0005A\u0002QBQa\u000e\u0005A\u0002aBQ\u0001\u0010\u0005A\u0002u\na\u0001\\8hO\u0016\u0014\bCA0c\u001b\u0005\u0001'BA1\u001d\u0003\u0015awn\u001a\u001bt\u0013\t\u0019\u0007M\u0001\u0004M_\u001e<WM]\u0001\bM\u0006\u001cGo\u001c:z!\t17.D\u0001h\u0015\tA\u0017.\u0001\u0003oS>\u0014$B\u00016\u0019\u0003\u001d\u0019\u0007.\u00198oK2L!\u0001\\4\u0003)\rc\u0017.\u001a8u\u0007\"\fgN\\3m\r\u0006\u001cGo\u001c:z\u00039\t7-];je\u0016\u001cVm]:j_:$\"a\\:\u0011\u0007E#\u0006\u000f\u0005\u00021c&\u0011!O\u0006\u0002\u0012\u0011R$\bo\u00117jK:$8+Z:tS>t\u0007\"\u0002;\f\u0001\u0004)\u0018a\u0002:fcV,7\u000f\u001e\t\u0003aYL!a\u001e\f\u0003\u0017!#H\u000f\u001d*fcV,7\u000f^\u0001\u0006G2|7/\u001a\u000b\u0002uB\u0019\u0011\u000bV>\u0011\u0005\u0011b\u0018BA?&\u0005\u0011)f.\u001b;\u0002\u001bI,G/\u001e:o'\u0016\u001c8/[8o)\rY\u0018\u0011\u0001\u0005\u0007\u0003\u0007i\u0001\u0019\u00019\u0002\u000fM,7o]5p]\u0006\u0019R.Y6f\u0003:$7\u000b^8sKN+7o]5p]R\u0019\u0001+!\u0003\t\u000f\u0005-a\u00021\u0001\u0002\u000e\u0005\u0019QO\u001d7\u0011\t\u0005=\u0011Q\u0006\b\u0005\u0003#\t9C\u0004\u0003\u0002\u0014\u0005\rb\u0002BA\u000b\u0003CqA!a\u0006\u0002 9!\u0011\u0011DA\u000f\u001d\rA\u00151D\u0005\u0002;%\u00111\u0004H\u0005\u00033iI!a\u0006\r\n\u0007\u0005\u0015b#\u0001\u0003vi&d\u0017\u0002BA\u0015\u0003W\t\u0001\"\u0016:m)>|Gn\u001d\u0006\u0004\u0003K1\u0012\u0002BA\u0018\u0003c\u0011a\"\u0016:m\u0007>l\u0007o\\:ji&|gN\u0003\u0003\u0002*\u0005-Bc\u0001)\u00026!9\u00111B\bA\u0002\u00055\u0011aD5oSRL\u0017\r\u001c)ja\u0016d\u0017N\\3\u0015\u0007A\u000bY\u0004C\u0004\u0002>A\u0001\r!a\u0010\u0002\t!,\u0017\r\u001a\t\u0007\u0003\u0003\n9%a\u0013\u000e\u0005\u0005\r#bAA#1\u0005A\u0001/\u001b9fY&tW-\u0003\u0003\u0002J\u0005\r#!\u0003%fC\u0012\u001cF/Y4f!\u0011\ti%a\u0016\u000e\u0005\u0005=#\u0002BA)\u0003'\n1A\\5p\u0015\t\t)&\u0001\u0003kCZ\f\u0017\u0002BA-\u0003\u001f\u0012!BQ=uK\n+hMZ3s\u0011\u0015\u00194\u00011\u00015\u0011\u001594\u00011\u00019\u0001")
public class Http2ClientSessionManagerImpl
implements ClientSessionManager {
    private final HttpClientConfig config;
    private final ImmutableHttp2Settings initialSettings;
    private final Map<String, Future<Http2ClientSession>> sessionCache;
    public final Logger org$http4s$blaze$http$http2$client$Http2ClientSessionManagerImpl$$logger;
    private final ClientChannelFactory factory;
    private volatile byte bitmap$init$0;

    public static Http2ClientSessionManagerImpl apply(HttpClientConfig httpClientConfig, ImmutableHttp2Settings immutableHttp2Settings) {
        return Http2ClientSessionManagerImpl$.MODULE$.apply(httpClientConfig, immutableHttp2Settings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Future<HttpClientSession> acquireSession(HttpRequest request) {
        boolean bl = false;
        Success success = null;
        Try<UrlTools.UrlComposition> try_ = UrlTools$UrlComposition$.MODULE$.apply(request.url());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            return Future$.MODULE$.failed(t);
        }
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            UrlTools.UrlComposition composition = (UrlTools.UrlComposition)success.value();
            if (!composition.scheme().equalsIgnoreCase("https")) {
                IllegalArgumentException ex = new IllegalArgumentException("Only https URL's allowed");
                return Future$.MODULE$.failed((Throwable)ex);
            }
        }
        if (!bl) throw new MatchError(try_);
        UrlTools.UrlComposition composition = (UrlTools.UrlComposition)success.value();
        Map<String, Future<Http2ClientSession>> map = this.sessionCache;
        synchronized (map) {
            Future future;
            Option option = this.sessionCache.get((Object)composition.authority());
            if (option instanceof Some) {
                Some some = (Some)option;
                Future session = (Future)some.value();
                future = session.flatMap((Function1 & Serializable)s -> {
                    HttpClientSession.Status status = s.status();
                    HttpClientSession$Ready$ httpClientSession$Ready$ = HttpClientSession$Ready$.MODULE$;
                    return !(status != null ? !status.equals(httpClientSession$Ready$) : httpClientSession$Ready$ != null) ? session : this.org$http4s$blaze$http$http2$client$Http2ClientSessionManagerImpl$$makeAndStoreSession(composition);
                }, Execution$.MODULE$.trampoline()).recoverWith((PartialFunction)new Serializable(this, composition){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ Http2ClientSessionManagerImpl $outer;
                    private final UrlTools.UrlComposition composition$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (this.$outer.org$http4s$blaze$http$http2$client$Http2ClientSessionManagerImpl$$logger.isInfoEnabled()) {
                            this.$outer.org$http4s$blaze$http$http2$client$Http2ClientSessionManagerImpl$$logger.info("Found bad session. Replacing.", A1);
                        }
                        Future<Http2ClientSession> future = this.$outer.org$http4s$blaze$http$http2$client$Http2ClientSessionManagerImpl$$makeAndStoreSession(this.composition$1);
                        return (B1)future;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.composition$1 = composition$1;
                    }
                }, Execution$.MODULE$.trampoline());
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                future = this.org$http4s$blaze$http$http2$client$Http2ClientSessionManagerImpl$$makeAndStoreSession(composition);
            }
            Future future2 = future;
            return future2;
        }
    }

    @Override
    public Future<BoxedUnit> close() {
        List list;
        Map<String, Future<Http2ClientSession>> map = this.sessionCache;
        synchronized (map) {
            List sessions = this.sessionCache.values().toList();
            this.sessionCache.clear();
            list = sessions;
        }
        List sessions = list;
        return (Future)sessions.foldLeft((Object)package$.MODULE$.FutureUnit(), (Function2 & Serializable)(acc, s) -> {
            Future f = s.flatMap((Function1 & Serializable)x$1 -> x$1.closeNow(), Execution$.MODULE$.directec());
            return acc.flatMap((Function1 & Serializable)x$2 -> f, Execution$.MODULE$.trampoline());
        });
    }

    @Override
    public void returnSession(HttpClientSession session) {
    }

    /*
     * WARNING - void declaration
     */
    public Future<Http2ClientSession> org$http4s$blaze$http$http2$client$Http2ClientSessionManagerImpl$$makeAndStoreSession(UrlTools.UrlComposition url) {
        void var3_2;
        if (this.org$http4s$blaze$http$http2$client$Http2ClientSessionManagerImpl$$logger.isDebugEnabled()) {
            this.org$http4s$blaze$http$http2$client$Http2ClientSessionManagerImpl$$logger.debug(new StringBuilder(39).append("Creating a new session for composition ").append(url).toString());
        }
        Future<Http2ClientSession> fSession = this.acquireSession(url);
        Option option = this.sessionCache.put((Object)url.authority(), fSession);
        if (option instanceof Some) {
            Some some = (Some)option;
            Future old = (Future)some.value();
            old.onComplete((Function1 & Serializable)x0$1 -> {
                Future<BoxedUnit> future;
                Try try_ = x0$1;
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Http2ClientSession session = (Http2ClientSession)success.value();
                    future = session.close((Duration)Duration$.MODULE$.Inf());
                } else if (try_ instanceof Failure) {
                    future = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)try_);
                }
                return future;
            }, Execution$.MODULE$.directec());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        return var3_2;
    }

    public Future<Http2ClientSession> acquireSession(UrlTools.UrlComposition url) {
        block0: {
            if (!this.org$http4s$blaze$http$http2$client$Http2ClientSessionManagerImpl$$logger.isDebugEnabled()) break block0;
            this.org$http4s$blaze$http$http2$client$Http2ClientSessionManagerImpl$$logger.debug(new StringBuilder(39).append("Creating a new session for composition ").append(url).toString());
        }
        return this.factory.connect((SocketAddress)url.getAddress(), this.factory.connect$default$2()).flatMap((Function1 & Serializable)head -> this.initialPipeline((HeadStage<ByteBuffer>)head), Execution$.MODULE$.directec());
    }

    public Future<Http2ClientSession> initialPipeline(HeadStage<ByteBuffer> head) {
        Promise p = Promise$.MODULE$.apply();
        SSLEngine engine = this.config.getClientSslEngine();
        engine.setUseClientMode(true);
        LeafBuilder$.MODULE$.apply((TailStage)new ALPNClientSelector(engine, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ALPNTokens$.MODULE$.H2(), ALPNTokens$.MODULE$.H2_14()}))), ALPNTokens$.MODULE$.H2(), (Function1<String, LeafBuilder<ByteBuffer>>)(Function1 & Serializable)s -> this.buildConnection$1((String)s, p))).prepend((MidStage)new SSLStage(engine, SSLStage$.MODULE$.$lessinit$greater$default$2())).base(head);
        head.sendInboundCommand((Command.InboundCommand)Command.Connected$.MODULE$);
        return p.future();
    }

    private final LeafBuilder buildConnection$1(String s, Promise p$1) {
        String string = s;
        String string2 = ALPNTokens$.MODULE$.H2();
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = s;
            String string4 = ALPNTokens$.MODULE$.H2_14();
            if ((string3 == null ? string4 != null : !string3.equals(string4)) && this.org$http4s$blaze$http$http2$client$Http2ClientSessionManagerImpl$$logger.isErrorEnabled()) {
                this.org$http4s$blaze$http$http2$client$Http2ClientSessionManagerImpl$$logger.error("Failed to negotiate H2. Using H2 protocol anyway.");
            }
        }
        DefaultFlowStrategy f = new DefaultFlowStrategy(this.initialSettings);
        ClientPriorKnowledgeHandshaker handShaker = new ClientPriorKnowledgeHandshaker(this.initialSettings, f, Execution$.MODULE$.trampoline());
        p$1.completeWith(handShaker.clientSession());
        return LeafBuilder$.MODULE$.apply((TailStage)handShaker);
    }

    public Http2ClientSessionManagerImpl(HttpClientConfig config, ImmutableHttp2Settings initialSettings, Map<String, Future<Http2ClientSession>> sessionCache) {
        this.config = config;
        this.initialSettings = initialSettings;
        this.sessionCache = sessionCache;
        this.org$http4s$blaze$http$http2$client$Http2ClientSessionManagerImpl$$logger = LoggerFactory.getLogger(Http2ClientSessionManagerImpl.class);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        Option<AsynchronousChannelGroup> x$1 = config.channelGroup();
        int x$2 = ClientChannelFactory$.MODULE$.$lessinit$greater$default$1();
        ChannelOptions x$3 = ClientChannelFactory$.MODULE$.$lessinit$greater$default$3();
        TickWheelExecutor x$4 = ClientChannelFactory$.MODULE$.$lessinit$greater$default$4();
        Duration x$5 = ClientChannelFactory$.MODULE$.$lessinit$greater$default$5();
        this.factory = new ClientChannelFactory(x$2, x$1, x$3, x$4, x$5);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

