/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.http4s.blaze.http.HeaderNames$;
import org.http4s.blaze.http.util.HeaderLike;
import org.http4s.blaze.http.util.HeaderLike$;
import org.http4s.blaze.http.util.HeaderTools;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.Iterable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class HeaderTools$ {
    public static final HeaderTools$ MODULE$ = new HeaderTools$();
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz").withLocale(Locale.US).withZone(ZoneId.of("GMT"));
    private static volatile HeaderTools.CachedDateHeader dateTime;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        dateTime = new HeaderTools.CachedDateHeader(0L, "");
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
    }

    private DateTimeFormatter dateFormat() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/ross/src/blaze/http/src/main/scala/org/http4s/blaze/http/util/HeaderTools.scala: 18");
        }
        return dateFormat;
    }

    private HeaderTools.CachedDateHeader dateTime() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/ross/src/blaze/http/src/main/scala/org/http4s/blaze/http/util/HeaderTools.scala: 25");
        }
        return dateTime;
    }

    private void dateTime_$eq(HeaderTools.CachedDateHeader x$1) {
        dateTime = x$1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
    }

    private String getDateHeader() {
        String string;
        HeaderTools.CachedDateHeader cached = this.dateTime();
        long current = System.currentTimeMillis();
        if (current - cached.acquired() <= 1000L) {
            string = cached.header();
        } else {
            String next = new java.lang.StringBuilder(8).append("date: ").append(this.dateFormat().format(Instant.now())).append("\r\n").toString();
            this.dateTime_$eq(new HeaderTools.CachedDateHeader(current, next));
            string = next;
        }
        return string;
    }

    public boolean isKeepAlive(Option<String> connectionHeader, int minorVersion) {
        boolean bl;
        Option<String> option = connectionHeader;
        if (option instanceof Some) {
            Some some = (Some)option;
            String headerValue = (String)some.value();
            bl = headerValue.equalsIgnoreCase("keep-alive") ? true : (headerValue.equalsIgnoreCase("close") ? false : headerValue.equalsIgnoreCase("upgrade"));
        } else if (None$.MODULE$.equals(option)) {
            bl = minorVersion != 0;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public <H> HeaderTools.SpecialHeaders renderHeaders(StringBuilder sb, Iterable<H> headers, HeaderLike<H> evidence$1) {
        None$ transferEncoding = None$.MODULE$;
        None$ contentLength = None$.MODULE$;
        None$ connection = None$.MODULE$;
        boolean hasDateheader = false;
        HeaderLike<H> hl = HeaderLike$.MODULE$.apply(evidence$1);
        for (Object header : headers) {
            BoxedUnit boxedUnit;
            String k = hl.getKey(header);
            String v = hl.getValue(header);
            if (k.equalsIgnoreCase(HeaderNames$.MODULE$.TransferEncoding())) {
                transferEncoding = new Some((Object)v);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (k.equalsIgnoreCase(HeaderNames$.MODULE$.ContentLength())) {
                contentLength = new Some((Object)v);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (k.equalsIgnoreCase(HeaderNames$.MODULE$.Connection())) {
                connection = new Some((Object)v);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (!hasDateheader && k.equalsIgnoreCase(HeaderNames$.MODULE$.Date())) {
                hasDateheader = true;
            }
            sb.append(k);
            Object object = v.length() > 0 ? sb.append(": ").append(v) : BoxedUnit.UNIT;
            boxedUnit = sb.append("\r\n");
        }
        Object object = !hasDateheader ? sb.append(this.getDateHeader()) : BoxedUnit.UNIT;
        return new HeaderTools.SpecialHeaders((Option<String>)transferEncoding, (Option<String>)contentLength, (Option<String>)connection);
    }

    private HeaderTools$() {
    }
}

