/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.unicode.UnicodeEncoding;
import org.jruby.MetaClass;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MultipleAsgn19Node;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.compiler.ASTInspector;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SimpleSourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CompiledBlock;
import org.jruby.runtime.CompiledBlock19;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.CompiledBlockCallback19;
import org.jruby.runtime.CompiledBlockLight;
import org.jruby.runtime.CompiledBlockLight19;
import org.jruby.runtime.CompiledSharedScopeBlock;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Interpreted19Block;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.util.ByteList;
import org.jruby.util.DefinedMessage;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.TypeConverter;

public class Helpers {
    public static final int MAX_SPECIFIC_ARITY_OBJECT_ARRAY = 10;
    public static final int MAX_SPECIFIC_ARITY_HASH = 3;
    private static IRubyObject[] NO_PARAMS = new IRubyObject[0];

    public static CallSite selectAttrAsgnCallSite(IRubyObject receiver2, IRubyObject self2, CallSite normalSite, CallSite variableSite) {
        if (receiver2 == self2) {
            return variableSite;
        }
        return normalSite;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject value2, ThreadContext context, IRubyObject caller2) {
        callSite.call(context, caller2, receiver2, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject arg0, IRubyObject value2, ThreadContext context, IRubyObject caller2) {
        callSite.call(context, caller2, receiver2, arg0, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject arg0, IRubyObject arg1, IRubyObject value2, ThreadContext context, IRubyObject caller2) {
        callSite.call(context, caller2, receiver2, arg0, arg1, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject value2, ThreadContext context, IRubyObject caller2) {
        callSite.call(context, caller2, receiver2, arg0, arg1, arg2, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject[] args2, ThreadContext context, IRubyObject caller2) {
        callSite.call(context, caller2, receiver2, args2);
        return args2[args2.length - 1];
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject[] args2, IRubyObject value2, ThreadContext context, IRubyObject caller2) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 0, args2.length);
        newArgs[args2.length] = value2;
        callSite.call(context, caller2, receiver2, newArgs);
        return value2;
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller2, IRubyObject arg2, IRubyObject[] receivers) {
        for (int i2 = 0; i2 < receivers.length; ++i2) {
            IRubyObject receiver2 = receivers[i2];
            if (!Helpers.invokeEqqForCaseWhen(callSite, context, caller2, arg2, receiver2)) continue;
            return true;
        }
        return false;
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller2, IRubyObject arg2, IRubyObject receiver2) {
        IRubyObject result2 = callSite.call(context, caller2, receiver2, arg2);
        return result2.isTrue();
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller2, IRubyObject arg2, IRubyObject receiver0, IRubyObject receiver1) {
        IRubyObject result2 = callSite.call(context, caller2, receiver0, arg2);
        if (result2.isTrue()) {
            return true;
        }
        return Helpers.invokeEqqForCaseWhen(callSite, context, caller2, arg2, receiver1);
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller2, IRubyObject arg2, IRubyObject receiver0, IRubyObject receiver1, IRubyObject receiver2) {
        IRubyObject result2 = callSite.call(context, caller2, receiver0, arg2);
        if (result2.isTrue()) {
            return true;
        }
        return Helpers.invokeEqqForCaseWhen(callSite, context, caller2, arg2, receiver1, receiver2);
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject[] receivers) {
        for (int i2 = 0; i2 < receivers.length; ++i2) {
            if (!receivers[i2].isTrue()) continue;
            return true;
        }
        return false;
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject receiver2) {
        return receiver2.isTrue();
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject receiver0, IRubyObject receiver1) {
        return receiver0.isTrue() || receiver1.isTrue();
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject receiver0, IRubyObject receiver1, IRubyObject receiver2) {
        return receiver0.isTrue() || receiver1.isTrue() || receiver2.isTrue();
    }

    public static CompiledBlockCallback createBlockCallback(Object scriptObject, String closureMethod, String file2, int line) {
        Class<?> scriptClass = scriptObject.getClass();
        ClassLoader scriptClassLoader = scriptClass.getClassLoader();
        MethodFactory factory = MethodFactory.createFactory(scriptClassLoader);
        return factory.getBlockCallback(closureMethod, file2, line, scriptObject);
    }

    public static CompiledBlockCallback19 createBlockCallback19(Object scriptObject, String closureMethod, String file2, int line) {
        Class<?> scriptClass = scriptObject.getClass();
        ClassLoader scriptClassLoader = scriptClass.getClassLoader();
        MethodFactory factory = MethodFactory.createFactory(scriptClassLoader);
        return factory.getBlockCallback19(closureMethod, file2, line, scriptObject);
    }

    public static byte[] createBlockCallbackOffline(String classPath, String closureMethod, String file2, int line) {
        MethodFactory factory = MethodFactory.createFactory(Helpers.class.getClassLoader());
        return factory.getBlockCallbackOffline(closureMethod, file2, line, classPath);
    }

    public static byte[] createBlockCallback19Offline(String classPath, String closureMethod, String file2, int line) {
        MethodFactory factory = MethodFactory.createFactory(Helpers.class.getClassLoader());
        return factory.getBlockCallback19Offline(closureMethod, file2, line, classPath);
    }

    public static String buildBlockDescriptor19(String closureMethod, int arity2, String file2, int line, boolean hasMultipleArgsHead, NodeType argsNodeId, String parameterList, ASTInspector inspector) {
        return Helpers.buildBlockDescriptor(closureMethod, arity2, file2, line, hasMultipleArgsHead, argsNodeId, inspector) + ":" + parameterList;
    }

    public static String buildBlockDescriptor(String closureMethod, int arity2, String file2, int line, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
        String descriptor = JavaNameMangler.mangleMethodName(closureMethod) + ':' + arity2 + ':' + hasMultipleArgsHead + ':' + BlockBody.asArgumentType(argsNodeId) + ':' + JavaNameMangler.mangleMethodName(file2) + ':' + line + ':' + (!inspector.hasClosure() && !inspector.hasScopeAwareMethods());
        return descriptor;
    }

    public static String[] parseBlockDescriptor(String descriptor) {
        String[] mangled = descriptor.split(":");
        mangled[0] = JavaNameMangler.demangleMethodName(mangled[0]);
        mangled[4] = JavaNameMangler.demangleMethodName(mangled[4]);
        return mangled;
    }

    public static BlockBody createCompiledBlockBody(ThreadContext context, Object scriptObject, StaticScope scope, String descriptor) {
        String[] firstSplit = Helpers.parseBlockDescriptor(descriptor);
        return Helpers.createCompiledBlockBody(context, scriptObject, firstSplit[0], Integer.parseInt(firstSplit[1]), scope, Boolean.valueOf(firstSplit[2]), Integer.parseInt(firstSplit[3]), firstSplit[4], Integer.parseInt(firstSplit[5]), Boolean.valueOf(firstSplit[6]));
    }

    public static BlockBody createCompiledBlockBody(ThreadContext context, Object scriptObject, String closureMethod, int arity2, StaticScope staticScope, boolean hasMultipleArgsHead, int argsNodeType, String file2, int line, boolean light) {
        staticScope.determineModule();
        if (light) {
            return CompiledBlockLight.newCompiledBlockLight(Arity.createArity(arity2), staticScope, Helpers.createBlockCallback(scriptObject, closureMethod, file2, line), hasMultipleArgsHead, argsNodeType);
        }
        return CompiledBlock.newCompiledBlock(Arity.createArity(arity2), staticScope, Helpers.createBlockCallback(scriptObject, closureMethod, file2, line), hasMultipleArgsHead, argsNodeType);
    }

    public static BlockBody createCompiledBlockBody19(ThreadContext context, Object scriptObject, StaticScope scope, String descriptor) {
        String[] firstSplit = Helpers.parseBlockDescriptor(descriptor);
        return Helpers.createCompiledBlockBody19(context, scriptObject, firstSplit[0], Integer.parseInt(firstSplit[1]), scope, Boolean.valueOf(firstSplit[2]), Integer.parseInt(firstSplit[3]), firstSplit[4], Integer.parseInt(firstSplit[5]), Boolean.valueOf(firstSplit[6]), firstSplit[7]);
    }

    public static BlockBody createCompiledBlockBody19(ThreadContext context, Object scriptObject, String closureMethod, int arity2, StaticScope staticScope, boolean hasMultipleArgsHead, int argsNodeType, String file2, int line, boolean light, String parameterList) {
        staticScope.determineModule();
        if (light) {
            return CompiledBlockLight19.newCompiledBlockLight(Arity.createArity(arity2), staticScope, Helpers.createBlockCallback19(scriptObject, closureMethod, file2, line), hasMultipleArgsHead, argsNodeType, parameterList.split(";"));
        }
        return CompiledBlock19.newCompiledBlock(Arity.createArity(arity2), staticScope, Helpers.createBlockCallback19(scriptObject, closureMethod, file2, line), hasMultipleArgsHead, argsNodeType, parameterList.split(";"));
    }

    public static Block createBlock(ThreadContext context, IRubyObject self2, BlockBody body) {
        return CompiledBlock.newCompiledClosure(context, self2, body);
    }

    public static Block createBlock19(ThreadContext context, IRubyObject self2, BlockBody body) {
        return CompiledBlock19.newCompiledClosure(context, self2, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject runBeginBlock(ThreadContext context, IRubyObject self2, String scopeString, CompiledBlockCallback callback) {
        StaticScope staticScope = Helpers.decodeScope(context, context.getCurrentStaticScope(), scopeString);
        context.preScopedBody(DynamicScope.newDynamicScope(staticScope, context.getCurrentScope()));
        Block block = CompiledBlock.newCompiledClosure(context, self2, Arity.createArity(0), staticScope, callback, false, 0);
        try {
            block.yield(context, null);
        }
        finally {
            context.postScopedBody();
        }
        return context.runtime.getNil();
    }

    public static Block createSharedScopeBlock(ThreadContext context, IRubyObject self2, int arity2, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argsNodeType) {
        return CompiledSharedScopeBlock.newCompiledSharedScopeClosure(context, self2, Arity.createArity(arity2), context.getCurrentScope(), callback, hasMultipleArgsHead, argsNodeType);
    }

    public static IRubyObject def(ThreadContext context, IRubyObject self2, Object scriptObject, String rubyName, String javaName, StaticScope scope, int arity2, String filename2, int line, CallConfiguration callConfig, String parameterDesc) {
        Class<?> compiledClass = scriptObject.getClass();
        Ruby runtime = context.runtime;
        RubyModule containingClass = context.getRubyClass();
        Visibility visibility = context.getCurrentVisibility();
        Helpers.performNormalMethodChecks(containingClass, runtime, rubyName);
        MethodFactory factory = MethodFactory.createFactory(compiledClass.getClassLoader());
        DynamicMethod method2 = Helpers.constructNormalMethod(factory, javaName, rubyName, containingClass, new SimpleSourcePosition(filename2, line), arity2, scope, visibility, scriptObject, callConfig, parameterDesc);
        Helpers.addInstanceMethod(containingClass, rubyName, method2, visibility, context, runtime);
        return runtime.getNil();
    }

    public static IRubyObject defs(ThreadContext context, IRubyObject self2, IRubyObject receiver2, Object scriptObject, String rubyName, String javaName, StaticScope scope, int arity2, String filename2, int line, CallConfiguration callConfig, String parameterDesc) {
        Class<?> compiledClass = scriptObject.getClass();
        Ruby runtime = context.runtime;
        RubyClass rubyClass = Helpers.performSingletonMethodChecks(runtime, receiver2, rubyName);
        MethodFactory factory = MethodFactory.createFactory(compiledClass.getClassLoader());
        DynamicMethod method2 = Helpers.constructSingletonMethod(factory, rubyName, javaName, rubyClass, new SimpleSourcePosition(filename2, line), arity2, scope, scriptObject, callConfig, parameterDesc);
        rubyClass.addMethod(rubyName, method2);
        Helpers.callSingletonMethodHook(receiver2, context, runtime.fastNewSymbol(rubyName));
        return runtime.getNil();
    }

    public static byte[] defOffline(String rubyName, String javaName, String classPath, String invokerName, Arity arity2, StaticScope scope, CallConfiguration callConfig, String filename2, int line) {
        MethodFactory factory = MethodFactory.createFactory(Helpers.class.getClassLoader());
        byte[] methodBytes = factory.getCompiledMethodOffline(rubyName, javaName, classPath, invokerName, arity2, scope, callConfig, filename2, line);
        return methodBytes;
    }

    public static RubyClass getSingletonClass(Ruby runtime, IRubyObject receiver2) {
        if (receiver2 instanceof RubyFixnum || receiver2 instanceof RubySymbol) {
            throw runtime.newTypeError(runtime.is1_9() ? "can't define singleton" : "no virtual class for " + receiver2.getMetaClass().getBaseName());
        }
        return receiver2.getSingletonClass();
    }

    public static IRubyObject invokeMethodMissing(IRubyObject receiver2, String name2, IRubyObject[] args2) {
        ThreadContext context = receiver2.getRuntime().getCurrentContext();
        context.setLastCallStatusAndVisibility(CallType.FUNCTIONAL, Visibility.PUBLIC);
        if (name2.equals("method_missing")) {
            return RubyKernel.method_missing(context, receiver2, args2, Block.NULL_BLOCK);
        }
        IRubyObject[] newArgs = Helpers.prepareMethodMissingArgs(args2, context, name2);
        return Helpers.invoke(context, receiver2, "method_missing", newArgs, Block.NULL_BLOCK);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject[] args2, Block block) {
        return Helpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, (RubyModule)receiver2.getMetaClass(), name2, args2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject arg0, Block block) {
        return Helpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, (RubyModule)receiver2.getMetaClass(), name2, arg0, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject arg0, IRubyObject arg1, Block block) {
        return Helpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, (RubyModule)receiver2.getMetaClass(), name2, arg0, arg1, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return Helpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, receiver2.getMetaClass(), name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, Block block) {
        return Helpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, (RubyModule)receiver2.getMetaClass(), name2, block);
    }

    public static DynamicMethod selectMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType) {
        Ruby runtime = context.runtime;
        if (name2.equals("method_missing")) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        DynamicMethod methodMissing = receiver2.getMetaClass().searchMethod("method_missing");
        if (methodMissing.isUndefined() || methodMissing.equals(runtime.getDefaultMethodMissing())) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        return new MethodMissingMethod(methodMissing, callType);
    }

    public static DynamicMethod selectMethodMissing(ThreadContext context, RubyClass selfClass, Visibility visibility, String name2, CallType callType) {
        Ruby runtime = context.runtime;
        if (name2.equals("method_missing")) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        DynamicMethod methodMissing = selfClass.searchMethod("method_missing");
        if (methodMissing.isUndefined() || methodMissing.equals(runtime.getDefaultMethodMissing())) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        return new MethodMissingMethod(methodMissing, callType);
    }

    public static DynamicMethod selectMethodMissing(RubyClass selfClass, Visibility visibility, String name2, CallType callType) {
        Ruby runtime = selfClass.getClassRuntime();
        if (name2.equals("method_missing")) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        DynamicMethod methodMissing = selfClass.searchMethod("method_missing");
        if (methodMissing.isUndefined() || methodMissing.equals(runtime.getDefaultMethodMissing())) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        return new MethodMissingMethod(methodMissing, callType);
    }

    public static final Map<String, String> map(String ... keyValues) {
        HashMap<String, String> map = new HashMap<String, String>(keyValues.length / 2);
        int i2 = 0;
        while (i2 < keyValues.length) {
            map.put(keyValues[i2++], keyValues[i2++]);
        }
        return map;
    }

    public static IRubyObject handleNextJump(ThreadContext context, JumpException.NextJump nj) {
        return nj.getValue() == null ? context.runtime.getNil() : (IRubyObject)nj.getValue();
    }

    private static DynamicMethod selectInternalMM(Ruby runtime, Visibility visibility, CallType callType) {
        if (visibility == Visibility.PRIVATE) {
            return runtime.getPrivateMethodMissing();
        }
        if (visibility == Visibility.PROTECTED) {
            return runtime.getProtectedMethodMissing();
        }
        if (callType == CallType.VARIABLE) {
            return runtime.getVariableMethodMissing();
        }
        if (callType == CallType.SUPER) {
            return runtime.getSuperMethodMissing();
        }
        return runtime.getNormalMethodMissing();
    }

    private static IRubyObject[] prepareMethodMissingArgs(IRubyObject[] args2, ThreadContext context, String name2) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 1, args2.length);
        newArgs[0] = context.runtime.newSymbol(name2);
        return newArgs;
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, arg1, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, args2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2) {
        return self2.getMetaClass().finvoke(context, self2, name2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, arg1);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, arg1, arg2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject ... args2) {
        return self2.getMetaClass().finvoke(context, self2, name2, args2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, CallType callType) {
        return Helpers.invoke(context, self2, name2, IRubyObject.NULL_ARRAY, callType, Block.NULL_BLOCK);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, CallType callType, Block block) {
        return self2.getMetaClass().invoke(context, self2, name2, args2, callType, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2, CallType callType, Block block) {
        return self2.getMetaClass().invoke(context, self2, name2, arg2, callType, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        return asClass.finvoke(context, self2, name2, args2, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, Block block) {
        return asClass.finvoke(context, self2, name2, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, IRubyObject arg0, Block block) {
        return asClass.finvoke(context, self2, name2, arg0, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return asClass.finvoke(context, self2, name2, arg0, arg1, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return asClass.finvoke(context, self2, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject invokeChecked(ThreadContext context, IRubyObject self2, String name2) {
        return self2.getMetaClass().finvokeChecked(context, self2, name2);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return Helpers.invokeSuper(context, self2, context.getFrameKlazz(), context.getFrameName(), args2, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, RubyModule klass, String name2, IRubyObject[] args2, Block block) {
        UndefinedMethod method2;
        Helpers.checkSuperDisabledOrOutOfMethod(context, klass, name2);
        RubyClass superClass = Helpers.findImplementerIfNecessary(self2.getMetaClass(), klass).getSuperClass();
        DynamicMethod dynamicMethod = method2 = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.SUPER, args2, block);
        }
        return ((DynamicMethod)method2).call(context, self2, (RubyModule)superClass, name2, args2, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, Block block) {
        UndefinedMethod method2;
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass superClass = Helpers.findImplementerIfNecessary(self2.getMetaClass(), klazz).getSuperClass();
        DynamicMethod dynamicMethod = method2 = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.SUPER, block);
        }
        return method2.call(context, self2, (RubyModule)superClass, name2, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, IRubyObject arg0, Block block) {
        UndefinedMethod method2;
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass superClass = Helpers.findImplementerIfNecessary(self2.getMetaClass(), klazz).getSuperClass();
        DynamicMethod dynamicMethod = method2 = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.SUPER, arg0, block);
        }
        return method2.call(context, self2, (RubyModule)superClass, name2, arg0, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, Block block) {
        UndefinedMethod method2;
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass superClass = Helpers.findImplementerIfNecessary(self2.getMetaClass(), klazz).getSuperClass();
        DynamicMethod dynamicMethod = method2 = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.SUPER, arg0, arg1, block);
        }
        return method2.call(context, self2, (RubyModule)superClass, name2, arg0, arg1, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        UndefinedMethod method2;
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass superClass = Helpers.findImplementerIfNecessary(self2.getMetaClass(), klazz).getSuperClass();
        DynamicMethod dynamicMethod = method2 = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), name2, CallType.SUPER, arg0, arg1, arg2, block);
        }
        return method2.call(context, self2, superClass, name2, arg0, arg1, arg2, block);
    }

    public static RubyArray ensureRubyArray(IRubyObject value2) {
        return Helpers.ensureRubyArray(value2.getRuntime(), value2);
    }

    public static RubyArray ensureRubyArray(Ruby runtime, IRubyObject value2) {
        return value2 instanceof RubyArray ? (RubyArray)value2 : RubyArray.newArray(runtime, value2);
    }

    public static RubyArray ensureMultipleAssignableRubyArray(IRubyObject value2, Ruby runtime, boolean masgnHasHead) {
        if (!(value2 instanceof RubyArray)) {
            value2 = runtime.is1_9() ? ArgsUtil.convertToRubyArray19(runtime, value2, masgnHasHead) : ArgsUtil.convertToRubyArray(runtime, value2, masgnHasHead);
        }
        return (RubyArray)value2;
    }

    public static IRubyObject fetchClassVariable(Ruby runtime, StaticScope scope, IRubyObject self2, String name2) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(runtime, scope);
        if (rubyClass == null) {
            rubyClass = self2.getMetaClass();
        }
        return rubyClass.getClassVar(name2);
    }

    public static IRubyObject getConstant(ThreadContext context, String internedName) {
        Ruby runtime = context.runtime;
        return context.getCurrentScope().getStaticScope().getConstantWithConstMissing(internedName);
    }

    public static IRubyObject nullToNil(IRubyObject value2, ThreadContext context) {
        return value2 != null ? value2 : context.nil;
    }

    public static IRubyObject nullToNil(IRubyObject value2, Ruby runtime) {
        return value2 != null ? value2 : runtime.getNil();
    }

    public static IRubyObject nullToNil(IRubyObject value2, IRubyObject nil) {
        return value2 != null ? value2 : nil;
    }

    public static RubyClass prepareSuperClass(Ruby runtime, IRubyObject rubyClass) {
        RubyClass.checkInheritable(rubyClass);
        return (RubyClass)rubyClass;
    }

    public static RubyModule prepareClassNamespace(ThreadContext context, StaticScope scope, IRubyObject rubyModule) {
        if ((rubyModule == null || rubyModule.isNil()) && (rubyModule = scope.getModule()) == null) {
            throw context.runtime.newTypeError("no outer class/module");
        }
        if (rubyModule instanceof RubyModule) {
            return (RubyModule)rubyModule;
        }
        throw context.runtime.newTypeError(rubyModule + " is not a class/module");
    }

    public static IRubyObject setClassVariable(Ruby runtime, StaticScope scope, IRubyObject self2, String name2, IRubyObject value2) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(runtime, scope);
        if (rubyClass == null) {
            rubyClass = self2.getMetaClass();
        }
        rubyClass.setClassVar(name2, value2);
        return value2;
    }

    public static IRubyObject declareClassVariable(Ruby runtime, StaticScope scope, IRubyObject self2, String name2, IRubyObject value2) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(runtime, scope);
        if (rubyClass == null) {
            throw runtime.newTypeError("no class/module to define class variable");
        }
        rubyClass.setClassVar(name2, value2);
        return value2;
    }

    public static void handleArgumentSizes(ThreadContext context, Ruby runtime, int given, int required, int opt, int rest2) {
        if (opt == 0) {
            if (rest2 < 0 ? given != required : given < required) {
                throw runtime.newArgumentError("wrong number of arguments (" + given + " for " + required + ")");
            }
        } else if (rest2 < 0) {
            if (given < required) {
                throw runtime.newArgumentError("wrong number of arguments (" + given + " for " + required + ")");
            }
            if (given > required + opt) {
                throw runtime.newArgumentError("wrong number of arguments (" + given + " for " + (required + opt) + ")");
            }
        } else if (given < required) {
            throw runtime.newArgumentError("wrong number of arguments (" + given + " for " + required + ")");
        }
    }

    public static Throwable unwrapRedoNextBreakOrJustLocalJump(RaiseException re, ThreadContext context) {
        RubyException exception2 = re.getException();
        if (context.runtime.getLocalJumpError().isInstance(exception2)) {
            RubyLocalJumpError jumpError = (RubyLocalJumpError)re.getException();
            switch (jumpError.getReason()) {
                case REDO: {
                    return JumpException.REDO_JUMP;
                }
                case NEXT: {
                    if (jumpError.exit_value().isNil()) {
                        throw JumpException.NEXT_JUMP;
                    }
                    return new JumpException.NextJump(jumpError.exit_value());
                }
                case BREAK: {
                    return new JumpException.BreakJump(context.getFrameJumpTarget(), jumpError.exit_value());
                }
            }
        }
        return re;
    }

    public static String getLocalJumpTypeOrRethrow(RaiseException re) {
        RubyException exception2 = re.getException();
        Ruby runtime = exception2.getRuntime();
        if (runtime.getLocalJumpError().isInstance(exception2)) {
            RubyLocalJumpError jumpError = (RubyLocalJumpError)re.getException();
            IRubyObject reason2 = jumpError.reason();
            return reason2.asJavaString();
        }
        throw re;
    }

    public static IRubyObject unwrapLocalJumpErrorValue(RaiseException re) {
        return ((RubyLocalJumpError)re.getException()).exit_value();
    }

    public static IRubyObject processBlockArgument(Ruby runtime, Block block) {
        if (!block.isGiven()) {
            return runtime.getNil();
        }
        return Helpers.processGivenBlock(block, runtime);
    }

    private static IRubyObject processGivenBlock(Block block, Ruby runtime) {
        RubyProc blockArg = block.getProcObject();
        if (blockArg == null) {
            blockArg = runtime.newBlockPassProc(Block.Type.PROC, block);
            blockArg.getBlock().type = Block.Type.PROC;
        }
        return blockArg;
    }

    public static Block getBlockFromBlockPassBody(Ruby runtime, IRubyObject proc2, Block currentBlock) {
        if (proc2.isNil()) {
            return Block.NULL_BLOCK;
        }
        if (!(proc2 instanceof RubyProc)) {
            proc2 = Helpers.coerceProc(proc2, runtime);
        }
        return Helpers.getBlockFromProc(currentBlock, proc2);
    }

    private static IRubyObject coerceProc(IRubyObject proc2, Ruby runtime) throws RaiseException {
        if (!((proc2 = TypeConverter.convertToType(proc2, runtime.getProc(), "to_proc", false)) instanceof RubyProc)) {
            throw runtime.newTypeError("wrong argument type " + proc2.getMetaClass().getName() + " (expected Proc)");
        }
        return proc2;
    }

    private static Block getBlockFromProc(Block currentBlock, IRubyObject proc2) {
        RubyProc procObject;
        if (currentBlock != null && currentBlock.isGiven() && (procObject = currentBlock.getProcObject()) != null && procObject == proc2) {
            return currentBlock;
        }
        return ((RubyProc)proc2).getBlock();
    }

    public static Block getBlockFromBlockPassBody(IRubyObject proc2, Block currentBlock) {
        return Helpers.getBlockFromBlockPassBody(proc2.getRuntime(), proc2, currentBlock);
    }

    public static IRubyObject backref(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        if (backref instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
        }
        return backref;
    }

    public static IRubyObject backrefLastMatch(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.last_match(backref);
    }

    public static IRubyObject backrefMatchPre(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.match_pre(backref);
    }

    public static IRubyObject backrefMatchPost(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.match_post(backref);
    }

    public static IRubyObject backrefMatchLast(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.match_last(backref);
    }

    public static IRubyObject[] getArgValues(ThreadContext context) {
        return context.getCurrentScope().getArgValues();
    }

    public static IRubyObject callZSuper(Ruby runtime, ThreadContext context, Block block, IRubyObject self2) {
        if (!block.isGiven()) {
            block = context.getCurrentFrame().getBlock();
        }
        return Helpers.invokeSuper(context, self2, context.getCurrentScope().getArgValues(), block);
    }

    public static IRubyObject[] appendToObjectArray(IRubyObject[] array, IRubyObject add3) {
        IRubyObject[] newArray = new IRubyObject[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = add3;
        return newArray;
    }

    public static JumpException.ReturnJump returnJump(IRubyObject result2, ThreadContext context) {
        return context.returnJump(result2);
    }

    public static IRubyObject throwReturnJump(IRubyObject result2, ThreadContext context) {
        throw context.returnJump(result2);
    }

    public static IRubyObject breakJumpInWhile(JumpException.BreakJump bj, ThreadContext context) {
        if (bj.getTarget() == context.getFrameJumpTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    public static IRubyObject breakJump(ThreadContext context, IRubyObject value2) {
        throw new JumpException.BreakJump(context.getFrameJumpTarget(), value2);
    }

    public static IRubyObject breakLocalJumpError(Ruby runtime, IRubyObject value2) {
        throw runtime.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, value2, "unexpected break");
    }

    public static IRubyObject[] concatObjectArrays(IRubyObject[] array, IRubyObject[] add3) {
        return Helpers.toArray(array, add3);
    }

    public static IRubyObject[] toArray(IRubyObject[] array, IRubyObject ... add3) {
        IRubyObject[] newArray = new IRubyObject[array.length + add3.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(add3, 0, newArray, array.length, add3.length);
        return newArray;
    }

    public static IRubyObject[] toArray(IRubyObject obj, IRubyObject ... rest2) {
        IRubyObject[] newArray = new IRubyObject[rest2.length + 1];
        newArray[0] = obj;
        System.arraycopy(rest2, 0, newArray, 1, rest2.length);
        return newArray;
    }

    public static IRubyObject[] toArray(IRubyObject obj0, IRubyObject obj1, IRubyObject ... rest2) {
        IRubyObject[] newArray = new IRubyObject[rest2.length + 2];
        newArray[0] = obj0;
        newArray[1] = obj1;
        System.arraycopy(rest2, 0, newArray, 2, rest2.length);
        return newArray;
    }

    public static IRubyObject[] toArray(IRubyObject obj0, IRubyObject obj1, IRubyObject obj2, IRubyObject ... rest2) {
        IRubyObject[] newArray = new IRubyObject[rest2.length + 3];
        newArray[0] = obj0;
        newArray[1] = obj1;
        newArray[2] = obj2;
        System.arraycopy(rest2, 0, newArray, 3, rest2.length);
        return newArray;
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject[] exceptions, ThreadContext context) {
        for (int i2 = 0; i2 < exceptions.length; ++i2) {
            IRubyObject result2 = Helpers.isExceptionHandled(currentException, exceptions[i2], context);
            if (!result2.isTrue()) continue;
            return result2;
        }
        return context.runtime.getFalse();
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception2, ThreadContext context) {
        return Helpers.isExceptionHandled((IRubyObject)currentException, exception2, context);
    }

    public static IRubyObject isExceptionHandled(IRubyObject currentException, IRubyObject exception2, ThreadContext context) {
        Ruby runtime = context.runtime;
        if (!runtime.getModule().isInstance(exception2)) {
            throw runtime.newTypeError("class or module required for rescue clause");
        }
        IRubyObject result2 = Helpers.invoke(context, exception2, "===", currentException);
        if (result2.isTrue()) {
            return result2;
        }
        return runtime.getFalse();
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception0, IRubyObject exception1, ThreadContext context) {
        IRubyObject result2 = Helpers.isExceptionHandled(currentException, exception0, context);
        if (result2.isTrue()) {
            return result2;
        }
        return Helpers.isExceptionHandled(currentException, exception1, context);
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception0, IRubyObject exception1, IRubyObject exception2, ThreadContext context) {
        IRubyObject result2 = Helpers.isExceptionHandled(currentException, exception0, context);
        if (result2.isTrue()) {
            return result2;
        }
        return Helpers.isExceptionHandled(currentException, exception1, exception2, context);
    }

    private static boolean checkJavaException(Throwable throwable, IRubyObject catchable, ThreadContext context) {
        Ruby runtime = context.runtime;
        if (runtime.getException() == catchable || runtime.getObject() == catchable || runtime.getStandardError() == catchable) {
            if (throwable instanceof RaiseException) {
                return Helpers.isExceptionHandled(((RaiseException)throwable).getException(), catchable, context).isTrue();
            }
            return Helpers.isExceptionHandled(JavaUtil.convertJavaToUsableRubyObject(runtime, throwable), catchable, context).isTrue();
        }
        if (runtime.getNativeException() == catchable) {
            return true;
        }
        if (catchable instanceof RubyClass && catchable.getInstanceVariables().hasInstanceVariable("@java_class")) {
            Class cls;
            RubyClass rubyClass = (RubyClass)catchable;
            JavaClass javaClass = (JavaClass)rubyClass.getInstanceVariable("@java_class");
            if (javaClass != null && (cls = javaClass.javaClass()).isInstance(throwable)) {
                return true;
            }
        } else if (catchable instanceof RubyModule) {
            IRubyObject exception2 = JavaUtil.convertJavaToUsableRubyObject(runtime, throwable);
            IRubyObject result2 = Helpers.invoke(context, catchable, "===", exception2);
            return result2.isTrue();
        }
        return false;
    }

    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject[] throwables, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwables, context);
        }
        if (throwables.length == 0) {
            return context.runtime.getTrue();
        }
        for (int i2 = 0; i2 < throwables.length; ++i2) {
            if (!Helpers.checkJavaException(currentThrowable, throwables[i2], context)) continue;
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable, context);
        }
        if (Helpers.checkJavaException(currentThrowable, throwable, context)) {
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable0, IRubyObject throwable1, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable0, throwable1, context);
        }
        if (Helpers.checkJavaException(currentThrowable, throwable0, context)) {
            return context.runtime.getTrue();
        }
        if (Helpers.checkJavaException(currentThrowable, throwable1, context)) {
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable0, IRubyObject throwable1, IRubyObject throwable2, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable0, throwable1, throwable2, context);
        }
        if (Helpers.checkJavaException(currentThrowable, throwable0, context)) {
            return context.runtime.getTrue();
        }
        if (Helpers.checkJavaException(currentThrowable, throwable1, context)) {
            return context.runtime.getTrue();
        }
        if (Helpers.checkJavaException(currentThrowable, throwable2, context)) {
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public static void storeExceptionInErrorInfo(Throwable currentThrowable, ThreadContext context) {
        IRubyObject exception2 = null;
        exception2 = currentThrowable instanceof RaiseException ? ((RaiseException)currentThrowable).getException() : JavaUtil.convertJavaToUsableRubyObject(context.runtime, currentThrowable);
        context.setErrorInfo(exception2);
    }

    public static void storeNativeExceptionInErrorInfo(Throwable currentThrowable, ThreadContext context) {
        RubyException exception2 = null;
        if (currentThrowable instanceof RaiseException) {
            exception2 = ((RaiseException)currentThrowable).getException();
        } else {
            Ruby runtime = context.runtime;
            exception2 = new NativeException(runtime, runtime.getNativeException(), currentThrowable);
            ((NativeException)exception2).prepareIntegratedBacktrace(context, currentThrowable.getStackTrace());
        }
        context.setErrorInfo(exception2);
    }

    public static void clearErrorInfo(ThreadContext context) {
        context.setErrorInfo(context.runtime.getNil());
    }

    public static void checkSuperDisabledOrOutOfMethod(ThreadContext context) {
        Helpers.checkSuperDisabledOrOutOfMethod(context, context.getFrameKlazz(), context.getFrameName());
    }

    public static void checkSuperDisabledOrOutOfMethod(ThreadContext context, RubyModule klass, String name2) {
        if (klass == null) {
            if (name2 != null) {
                throw context.runtime.newNameError("superclass method '" + name2 + "' disabled", name2);
            }
            throw context.runtime.newNoMethodError("super called outside of method", null, context.nil);
        }
    }

    public static Block ensureSuperBlock(Block given, Block parent) {
        if (!given.isGiven()) {
            return parent;
        }
        return given;
    }

    public static RubyModule findImplementerIfNecessary(RubyModule clazz, RubyModule implementationClass) {
        if (implementationClass != null && implementationClass.needsImplementer()) {
            return clazz.findImplementer(implementationClass);
        }
        return implementationClass;
    }

    public static RubyArray createSubarray(RubyArray input, int start2) {
        return (RubyArray)input.subseqLight(start2, input.size() - start2);
    }

    public static RubyArray createSubarray(RubyArray input, int start2, int post) {
        return (RubyArray)input.subseqLight(start2, input.size() - post - start2);
    }

    public static RubyArray createSubarray(IRubyObject[] input, Ruby runtime, int start2) {
        if (start2 >= input.length) {
            return RubyArray.newEmptyArray(runtime);
        }
        return RubyArray.newArrayNoCopy(runtime, input, start2);
    }

    public static RubyArray createSubarray(IRubyObject[] input, Ruby runtime, int start2, int exclude) {
        int length2 = input.length - exclude - start2;
        if (length2 <= 0) {
            return RubyArray.newEmptyArray(runtime);
        }
        return RubyArray.newArrayNoCopy(runtime, input, start2, length2);
    }

    public static IRubyObject elementOrNull(IRubyObject[] input, int element) {
        if (element >= input.length) {
            return null;
        }
        return input[element];
    }

    public static IRubyObject optElementOrNull(IRubyObject[] input, int element, int postCount) {
        if (element + postCount >= input.length) {
            return null;
        }
        return input[element];
    }

    public static IRubyObject elementOrNil(IRubyObject[] input, int element, IRubyObject nil) {
        if (element >= input.length) {
            return nil;
        }
        return input[element];
    }

    public static IRubyObject postElementOrNil(IRubyObject[] input, int postCount, int postIndex, IRubyObject nil) {
        int aryIndex = input.length - postCount + postIndex;
        if (aryIndex >= input.length || aryIndex < 0) {
            return nil;
        }
        return input[aryIndex];
    }

    public static RubyBoolean isWhenTriggered(IRubyObject expression, IRubyObject expressionsObject, ThreadContext context) {
        RubyArray expressions = Helpers.splatValue(expressionsObject);
        int k = expressions.getLength();
        for (int j = 0; j < k; ++j) {
            IRubyObject condition = expressions.eltInternal(j);
            if ((expression == null || !condition.callMethod(context, "===", expression).isTrue()) && (expression != null || !condition.isTrue())) continue;
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public static IRubyObject setConstantInModule(ThreadContext context, String name2, IRubyObject value2, IRubyObject module) {
        if (!(module instanceof RubyModule)) {
            throw context.runtime.newTypeError(module.toString() + " is not a class/module");
        }
        ((RubyModule)module).setConstant(name2, value2);
        return value2;
    }

    public static IRubyObject setConstantInCurrent(IRubyObject value2, ThreadContext context, String name2) {
        return context.getCurrentStaticScope().setConstant(name2, value2);
    }

    public static IRubyObject retryJump() {
        throw JumpException.RETRY_JUMP;
    }

    public static IRubyObject redoJump() {
        throw JumpException.REDO_JUMP;
    }

    public static IRubyObject redoLocalJumpError(Ruby runtime) {
        throw runtime.newLocalJumpError(RubyLocalJumpError.Reason.REDO, runtime.getNil(), "unexpected redo");
    }

    public static IRubyObject nextJump(IRubyObject value2) {
        if (value2.isNil()) {
            throw JumpException.NEXT_JUMP;
        }
        throw new JumpException.NextJump(value2);
    }

    public static IRubyObject nextLocalJumpError(Ruby runtime, IRubyObject value2) {
        throw runtime.newLocalJumpError(RubyLocalJumpError.Reason.NEXT, value2, "unexpected next");
    }

    public static IRubyObject[] anewarrayIRubyObjects(int size2) {
        return new IRubyObject[size2];
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, int start2) {
        ary[start2] = one;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        ary[start2 + 6] = seven;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        ary[start2 + 6] = seven;
        ary[start2 + 7] = eight;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        ary[start2 + 6] = seven;
        ary[start2 + 7] = eight;
        ary[start2 + 8] = nine;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, IRubyObject ten, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        ary[start2 + 6] = seven;
        ary[start2 + 7] = eight;
        ary[start2 + 8] = nine;
        ary[start2 + 9] = ten;
        return ary;
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one) {
        return new IRubyObject[]{one};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two) {
        return new IRubyObject[]{one, two};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three) {
        return new IRubyObject[]{one, two, three};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four) {
        return new IRubyObject[]{one, two, three, four};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five) {
        return new IRubyObject[]{one, two, three, four, five};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six) {
        return new IRubyObject[]{one, two, three, four, five, six};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven) {
        return new IRubyObject[]{one, two, three, four, five, six, seven};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight) {
        return new IRubyObject[]{one, two, three, four, five, six, seven, eight};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine) {
        return new IRubyObject[]{one, two, three, four, five, six, seven, eight, nine};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, IRubyObject ten) {
        return new IRubyObject[]{one, two, three, four, five, six, seven, eight, nine, ten};
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one) {
        return RubyArray.newArrayLight(runtime, one);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two) {
        return RubyArray.newArrayLight(runtime, one, two);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three) {
        return RubyArray.newArrayLight(runtime, one, two, three);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four) {
        return RubyArray.newArrayLight(runtime, one, two, three, four);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five) {
        return RubyArray.newArrayLight(runtime, one, two, three, four, five);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six) {
        return RubyArray.newArrayLight(runtime, one, two, three, four, five, six);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven) {
        return RubyArray.newArrayLight(runtime, one, two, three, four, five, six, seven);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight) {
        return RubyArray.newArrayLight(runtime, one, two, three, four, five, six, seven, eight);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine) {
        return RubyArray.newArrayLight(runtime, one, two, three, four, five, six, seven, eight, nine);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, IRubyObject ten) {
        return RubyArray.newArrayLight(runtime, one, two, three, four, five, six, seven, eight, nine, ten);
    }

    public static String[] constructStringArray(String one) {
        return new String[]{one};
    }

    public static String[] constructStringArray(String one, String two) {
        return new String[]{one, two};
    }

    public static String[] constructStringArray(String one, String two, String three) {
        return new String[]{one, two, three};
    }

    public static String[] constructStringArray(String one, String two, String three, String four) {
        return new String[]{one, two, three, four};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five) {
        return new String[]{one, two, three, four, five};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six) {
        return new String[]{one, two, three, four, five, six};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven) {
        return new String[]{one, two, three, four, five, six, seven};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight) {
        return new String[]{one, two, three, four, five, six, seven, eight};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight, String nine) {
        return new String[]{one, two, three, four, five, six, seven, eight, nine};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight, String nine, String ten) {
        return new String[]{one, two, three, four, five, six, seven, eight, nine, ten};
    }

    public static RubyHash constructHash(Ruby runtime, IRubyObject key1, IRubyObject value1) {
        RubyHash hash2 = RubyHash.newHash(runtime);
        hash2.fastASetCheckString(runtime, key1, value1);
        return hash2;
    }

    public static RubyHash constructHash(Ruby runtime, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2) {
        RubyHash hash2 = RubyHash.newHash(runtime);
        hash2.fastASetCheckString(runtime, key1, value1);
        hash2.fastASetCheckString(runtime, key2, value2);
        return hash2;
    }

    public static RubyHash constructHash(Ruby runtime, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2, IRubyObject key3, IRubyObject value3) {
        RubyHash hash2 = RubyHash.newHash(runtime);
        hash2.fastASetCheckString(runtime, key1, value1);
        hash2.fastASetCheckString(runtime, key2, value2);
        hash2.fastASetCheckString(runtime, key3, value3);
        return hash2;
    }

    public static RubyHash constructSmallHash(Ruby runtime, IRubyObject key1, IRubyObject value1) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime);
        hash2.fastASetSmallCheckString(runtime, key1, value1);
        return hash2;
    }

    public static RubyHash constructSmallHash(Ruby runtime, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime);
        hash2.fastASetSmallCheckString(runtime, key1, value1);
        hash2.fastASetSmallCheckString(runtime, key2, value2);
        return hash2;
    }

    public static RubyHash constructSmallHash(Ruby runtime, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2, IRubyObject key3, IRubyObject value3) {
        RubyHash hash2 = RubyHash.newHash(runtime);
        hash2.fastASetSmallCheckString(runtime, key1, value1);
        hash2.fastASetSmallCheckString(runtime, key2, value2);
        hash2.fastASetSmallCheckString(runtime, key3, value3);
        return hash2;
    }

    public static RubyHash constructHash19(Ruby runtime, IRubyObject key1, IRubyObject value1) {
        RubyHash hash2 = RubyHash.newHash(runtime);
        hash2.fastASetCheckString(runtime, key1, value1);
        return hash2;
    }

    public static RubyHash constructHash19(Ruby runtime, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2) {
        RubyHash hash2 = RubyHash.newHash(runtime);
        hash2.fastASetCheckString(runtime, key1, value1);
        hash2.fastASetCheckString(runtime, key2, value2);
        return hash2;
    }

    public static RubyHash constructHash19(Ruby runtime, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2, IRubyObject key3, IRubyObject value3) {
        RubyHash hash2 = RubyHash.newHash(runtime);
        hash2.fastASetCheckString(runtime, key1, value1);
        hash2.fastASetCheckString(runtime, key2, value2);
        hash2.fastASetCheckString(runtime, key3, value3);
        return hash2;
    }

    public static RubyHash constructSmallHash19(Ruby runtime, IRubyObject key1, IRubyObject value1) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime);
        hash2.fastASetSmallCheckString(runtime, key1, value1);
        return hash2;
    }

    public static RubyHash constructSmallHash19(Ruby runtime, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime);
        hash2.fastASetSmallCheckString(runtime, key1, value1);
        hash2.fastASetSmallCheckString(runtime, key2, value2);
        return hash2;
    }

    public static RubyHash constructSmallHash19(Ruby runtime, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2, IRubyObject key3, IRubyObject value3) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime);
        hash2.fastASetSmallCheckString(runtime, key1, value1);
        hash2.fastASetSmallCheckString(runtime, key2, value2);
        hash2.fastASetSmallCheckString(runtime, key3, value3);
        return hash2;
    }

    public static IRubyObject undefMethod(ThreadContext context, Object nameArg) {
        String name2;
        RubyModule module = context.getRubyClass();
        String string2 = name2 = nameArg instanceof String ? (String)nameArg : nameArg.toString();
        if (module == null) {
            throw context.runtime.newTypeError("No class to undef method '" + name2 + "'.");
        }
        module.undef(context, name2);
        return context.runtime.getNil();
    }

    public static IRubyObject defineAlias(ThreadContext context, IRubyObject self2, Object newNameArg, Object oldNameArg) {
        Ruby runtime = context.runtime;
        RubyModule module = context.getRubyClass();
        if (module == null || self2 instanceof RubyFixnum || self2 instanceof RubySymbol) {
            throw runtime.newTypeError("no class to make alias");
        }
        String newName = newNameArg instanceof String ? (String)newNameArg : newNameArg.toString();
        String oldName = oldNameArg instanceof String ? (String)oldNameArg : oldNameArg.toString();
        module.defineAlias(newName, oldName);
        module.callMethod(context, "method_added", (IRubyObject)runtime.newSymbol(newName));
        return runtime.getNil();
    }

    public static IRubyObject negate(IRubyObject value2, Ruby runtime) {
        if (value2.isTrue()) {
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    public static IRubyObject stringOrNil(ByteList value2, ThreadContext context) {
        if (value2 == null) {
            return context.nil;
        }
        return RubyString.newStringShared(context.runtime, value2);
    }

    public static StaticScope preLoad(ThreadContext context, String[] varNames) {
        StaticScope staticScope = context.runtime.getStaticScopeFactory().newLocalScope(null, varNames);
        Helpers.preLoadCommon(context, staticScope, false);
        return staticScope;
    }

    public static StaticScope preLoad(ThreadContext context, String scopeString, boolean wrap2) {
        StaticScope staticScope = Helpers.decodeScope(context, null, scopeString);
        Helpers.preLoadCommon(context, staticScope, wrap2);
        return staticScope;
    }

    public static void preLoadCommon(ThreadContext context, StaticScope staticScope, boolean wrap2) {
        RubyClass objectClass = context.runtime.getObject();
        IRubyObject topLevel = context.runtime.getTopSelf();
        if (wrap2) {
            staticScope.setModule(RubyModule.newModule(context.runtime));
        } else {
            staticScope.setModule(objectClass);
        }
        DynamicScope scope = DynamicScope.newDynamicScope(staticScope);
        context.preScopedBody(scope);
        context.preNodeEval(objectClass, topLevel);
    }

    public static void postLoad(ThreadContext context) {
        context.postNodeEval();
        context.postScopedBody();
    }

    public static void registerEndBlock(Block block, Ruby runtime) {
        runtime.pushExitBlock(runtime.newProc(Block.Type.LAMBDA, block));
    }

    public static IRubyObject match3(RubyRegexp regexp2, IRubyObject value2, ThreadContext context) {
        if (value2 instanceof RubyString) {
            return regexp2.op_match(context, value2);
        }
        return value2.callMethod(context, "=~", regexp2);
    }

    public static IRubyObject match3_19(RubyRegexp regexp2, IRubyObject value2, ThreadContext context) {
        if (value2 instanceof RubyString) {
            return regexp2.op_match19(context, value2);
        }
        return value2.callMethod(context, "=~", regexp2);
    }

    public static IRubyObject getErrorInfo(Ruby runtime) {
        return runtime.getGlobalVariables().get("$!");
    }

    public static void setErrorInfo(Ruby runtime, IRubyObject error2) {
        runtime.getGlobalVariables().set("$!", error2);
    }

    public static IRubyObject setLastLine(Ruby runtime, ThreadContext context, IRubyObject value2) {
        return context.setLastLine(value2);
    }

    public static IRubyObject getLastLine(Ruby runtime, ThreadContext context) {
        return context.getLastLine();
    }

    public static IRubyObject setBackref(Ruby runtime, ThreadContext context, IRubyObject value2) {
        if (!value2.isNil() && !(value2 instanceof RubyMatchData)) {
            throw runtime.newTypeError(value2, runtime.getMatchData());
        }
        return context.setBackRef(value2);
    }

    public static IRubyObject getBackref(Ruby runtime, ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        if (backref instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
        }
        return backref;
    }

    public static IRubyObject preOpAsgnWithOrAnd(IRubyObject receiver2, ThreadContext context, IRubyObject self2, CallSite varSite) {
        return varSite.call(context, self2, receiver2);
    }

    public static IRubyObject postOpAsgnWithOrAnd(IRubyObject receiver2, IRubyObject value2, ThreadContext context, IRubyObject self2, CallSite varAsgnSite) {
        varAsgnSite.call(context, self2, receiver2, value2);
        return value2;
    }

    public static IRubyObject opAsgnWithMethod(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject arg2, CallSite varSite, CallSite opSite, CallSite opAsgnSite) {
        IRubyObject var = varSite.call(context, self2, receiver2);
        IRubyObject result2 = opSite.call(context, self2, var, arg2);
        opAsgnSite.call(context, self2, receiver2, result2);
        return result2;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self2, receiver2);
        IRubyObject result2 = opSite.call(context, self2, var, value2);
        elementAsgnSite.call(context, self2, receiver2, result2);
        return result2;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject arg2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self2, receiver2, arg2);
        IRubyObject result2 = opSite.call(context, self2, var, value2);
        elementAsgnSite.call(context, self2, receiver2, arg2, result2);
        return result2;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject arg1, IRubyObject arg2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self2, receiver2, arg1, arg2);
        IRubyObject result2 = opSite.call(context, self2, var, value2);
        elementAsgnSite.call(context, self2, receiver2, arg1, arg2, result2);
        return result2;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self2, receiver2, arg1, arg2, arg3);
        IRubyObject result2 = opSite.call(context, self2, var, value2);
        elementAsgnSite.call(context, self2, receiver2, arg1, arg2, arg3, result2);
        return result2;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self2, receiver2);
        IRubyObject result2 = opSite.call(context, self2, var, value2);
        elementAsgnSite.call(context, self2, receiver2, Helpers.appendToObjectArray(args2, result2));
        return result2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoOneArg(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject arg2, IRubyObject value2, CallSite asetSite) {
        asetSite.call(context, self2, receiver2, arg2, value2);
        return value2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoTwoArgs(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite asetSite) {
        asetSite.call(context, self2, receiver2, args2[0], args2[1], value2);
        return value2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoThreeArgs(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite asetSite) {
        asetSite.call(context, self2, receiver2, args2[0], args2[1], args2[2], value2);
        return value2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoNArgs(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite asetSite) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 0, args2.length);
        newArgs[args2.length] = value2;
        asetSite.call(context, self2, receiver2, newArgs);
        return value2;
    }

    public static RubyArray arrayValue(IRubyObject value2) {
        Ruby runtime = value2.getRuntime();
        return Helpers.arrayValue(runtime.getCurrentContext(), runtime, value2);
    }

    public static RubyArray arrayValue(ThreadContext context, Ruby runtime, IRubyObject value2) {
        IRubyObject tmp = value2.checkArrayType();
        if (tmp.isNil()) {
            if (value2.respondsTo("to_a") && value2.getMetaClass().searchMethod("to_a").getImplementationClass() != runtime.getKernel()) {
                IRubyObject avalue = value2.callMethod(context, "to_a");
                if (!(avalue instanceof RubyArray)) {
                    if (runtime.is1_9() && avalue.isNil()) {
                        return runtime.newArray(value2);
                    }
                    throw runtime.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)avalue;
            }
            return runtime.newArray(value2);
        }
        RubyArray arr = (RubyArray)tmp;
        return runtime.is1_9() ? arr.aryDup19() : arr;
    }

    public static RubyArray asArray18(ThreadContext context, IRubyObject value2) {
        Ruby runtime = context.runtime;
        IRubyObject tmp = value2.checkArrayType();
        if (tmp.isNil()) {
            if (value2.respondsTo("to_a") && value2.getMetaClass().searchMethod("to_a").getImplementationClass() != runtime.getKernel()) {
                IRubyObject avalue = value2.callMethod(context, "to_a");
                if (!(avalue instanceof RubyArray)) {
                    if (runtime.is1_9() && avalue.isNil()) {
                        return runtime.newArray(value2);
                    }
                    throw runtime.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)avalue;
            }
            return runtime.newArray(value2);
        }
        return (RubyArray)tmp;
    }

    public static RubyArray asArray(ThreadContext context, IRubyObject value2) {
        return TypeConverter.rb_Array(context, value2);
    }

    public static IRubyObject aryToAry(IRubyObject value2) {
        if (value2 instanceof RubyArray) {
            return value2;
        }
        if (value2.respondsTo("to_ary")) {
            return TypeConverter.convertToType(value2, value2.getRuntime().getArray(), "to_ary", false);
        }
        return value2.getRuntime().newArray(value2);
    }

    public static IRubyObject aValueSplat(IRubyObject value2) {
        if (!(value2 instanceof RubyArray) || ((RubyArray)value2).length().getLongValue() == 0L) {
            return value2.getRuntime().getNil();
        }
        RubyArray array = (RubyArray)value2;
        return array.getLength() == 1 ? array.first() : array;
    }

    public static IRubyObject aValueSplat19(IRubyObject value2) {
        if (!(value2 instanceof RubyArray)) {
            return value2.getRuntime().getNil();
        }
        return (RubyArray)value2;
    }

    public static RubyArray splatValue(IRubyObject value2) {
        if (value2.isNil()) {
            return value2.getRuntime().newArray(value2);
        }
        return Helpers.arrayValue(value2);
    }

    public static RubyArray splatValue19(IRubyObject value2) {
        if (value2.isNil()) {
            return value2.getRuntime().newEmptyArray();
        }
        return Helpers.arrayValue(value2);
    }

    public static IRubyObject unsplatValue19(IRubyObject argsResult) {
        IRubyObject newResult;
        RubyArray array;
        if (argsResult instanceof RubyArray && (array = (RubyArray)argsResult).size() == 1 && (!((newResult = array.eltInternal(0)) instanceof RubyArray) || ((RubyArray)newResult).size() != 0)) {
            argsResult = newResult;
        }
        return argsResult;
    }

    public static IRubyObject unsplatValue19IfArityOne(IRubyObject argsResult, Block block) {
        if (block.isGiven() && block.arity().getValue() > 1) {
            argsResult = Helpers.unsplatValue19(argsResult);
        }
        return argsResult;
    }

    public static IRubyObject[] splatToArguments(IRubyObject value2) {
        Ruby runtime = value2.getRuntime();
        if (value2.isNil()) {
            return runtime.getSingleNilArray();
        }
        return Helpers.splatToArgumentsCommon(runtime, value2);
    }

    public static IRubyObject[] splatToArguments19(IRubyObject value2) {
        Ruby runtime = value2.getRuntime();
        if (value2.isNil()) {
            return IRubyObject.NULL_ARRAY;
        }
        return Helpers.splatToArgumentsCommon(runtime, value2);
    }

    private static IRubyObject[] splatToArgumentsCommon(Ruby runtime, IRubyObject value2) {
        if (value2.isNil()) {
            return runtime.getSingleNilArray();
        }
        IRubyObject tmp = value2.checkArrayType();
        if (tmp.isNil()) {
            return Helpers.convertSplatToJavaArray(runtime, value2);
        }
        return ((RubyArray)tmp).toJavaArrayMaybeUnsafe();
    }

    private static IRubyObject[] convertSplatToJavaArray(Ruby runtime, IRubyObject value2) {
        RubyClass metaClass = value2.getMetaClass();
        DynamicMethod method2 = metaClass.searchMethod("to_a");
        if (method2.isUndefined() || method2.getImplementationClass() == runtime.getKernel()) {
            return new IRubyObject[]{value2};
        }
        IRubyObject avalue = method2.call(runtime.getCurrentContext(), value2, metaClass, "to_a");
        if (!(avalue instanceof RubyArray)) {
            if (runtime.is1_9() && avalue.isNil()) {
                return new IRubyObject[]{value2};
            }
            throw runtime.newTypeError("`to_a' did not return Array");
        }
        return ((RubyArray)avalue).toJavaArray();
    }

    public static IRubyObject[] argsCatToArguments(IRubyObject[] args2, IRubyObject cat) {
        IRubyObject[] ary = Helpers.splatToArguments(cat);
        return Helpers.argsCatToArgumentsCommon(args2, ary, cat);
    }

    public static IRubyObject[] argsCatToArguments19(IRubyObject[] args2, IRubyObject cat) {
        IRubyObject[] ary = Helpers.splatToArguments19(cat);
        return Helpers.argsCatToArgumentsCommon(args2, ary, cat);
    }

    private static IRubyObject[] argsCatToArgumentsCommon(IRubyObject[] args2, IRubyObject[] ary, IRubyObject cat) {
        if (ary.length > 0) {
            IRubyObject[] newArgs = new IRubyObject[args2.length + ary.length];
            System.arraycopy(args2, 0, newArgs, 0, args2.length);
            System.arraycopy(ary, 0, newArgs, args2.length, ary.length);
            args2 = newArgs;
        }
        return args2;
    }

    public static void addInstanceMethod(RubyModule containingClass, String name2, DynamicMethod method2, Visibility visibility, ThreadContext context, Ruby runtime) {
        containingClass.addMethod(name2, method2);
        RubySymbol sym = runtime.fastNewSymbol(name2);
        if (visibility == Visibility.MODULE_FUNCTION) {
            Helpers.addModuleMethod(containingClass, name2, method2, context, sym);
        }
        Helpers.callNormalMethodHook(containingClass, context, sym);
    }

    private static void addModuleMethod(RubyModule containingClass, String name2, DynamicMethod method2, ThreadContext context, RubySymbol sym) {
        containingClass.getSingletonClass().addMethod(name2, new WrapperMethod((RubyModule)containingClass.getSingletonClass(), method2, Visibility.PUBLIC));
        containingClass.callMethod(context, "singleton_method_added", (IRubyObject)sym);
    }

    private static void callNormalMethodHook(RubyModule containingClass, ThreadContext context, RubySymbol name2) {
        if (containingClass.isSingleton()) {
            Helpers.callSingletonMethodHook(((MetaClass)containingClass).getAttached(), context, name2);
        } else {
            containingClass.callMethod(context, "method_added", (IRubyObject)name2);
        }
    }

    private static void callSingletonMethodHook(IRubyObject receiver2, ThreadContext context, RubySymbol name2) {
        receiver2.callMethod(context, "singleton_method_added", name2);
    }

    private static DynamicMethod constructNormalMethod(MethodFactory factory, String javaName, String name2, RubyModule containingClass, ISourcePosition position, int arity2, StaticScope scope, Visibility visibility, Object scriptObject, CallConfiguration callConfig, String parameterDesc) {
        Ruby runtime = containingClass.getRuntime();
        if ("initialize".equals(name2) || "initialize_copy".equals(name2) || "method_missing".equals(name2) || visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        } else if (runtime.is2_0() && ("respond_to_missing?".equals(name2) || "initialize_clone".equals(name2) || "initialize_dup".equals(name2))) {
            visibility = Visibility.PRIVATE;
        }
        DynamicMethod method2 = RubyInstanceConfig.LAZYHANDLES_COMPILE ? factory.getCompiledMethodLazily(containingClass, name2, javaName, Arity.createArity(arity2), visibility, scope, scriptObject, callConfig, position, parameterDesc) : factory.getCompiledMethod(containingClass, name2, javaName, Arity.createArity(arity2), visibility, scope, scriptObject, callConfig, position, parameterDesc);
        return method2;
    }

    private static DynamicMethod constructSingletonMethod(MethodFactory factory, String rubyName, String javaName, RubyClass rubyClass, ISourcePosition position, int arity2, StaticScope scope, Object scriptObject, CallConfiguration callConfig, String parameterDesc) {
        if (RubyInstanceConfig.LAZYHANDLES_COMPILE) {
            return factory.getCompiledMethodLazily(rubyClass, rubyName, javaName, Arity.createArity(arity2), Visibility.PUBLIC, scope, scriptObject, callConfig, position, parameterDesc);
        }
        return factory.getCompiledMethod(rubyClass, rubyName, javaName, Arity.createArity(arity2), Visibility.PUBLIC, scope, scriptObject, callConfig, position, parameterDesc);
    }

    public static String encodeScope(StaticScope scope) {
        StringBuilder namesBuilder = new StringBuilder(scope.getType().name());
        namesBuilder.append(',');
        boolean first2 = true;
        for (String name2 : scope.getVariables()) {
            if (!first2) {
                namesBuilder.append(';');
            }
            first2 = false;
            namesBuilder.append(name2);
        }
        namesBuilder.append(',').append(scope.getRequiredArgs()).append(',').append(scope.getOptionalArgs()).append(',').append(scope.getRestArg());
        return namesBuilder.toString();
    }

    @Deprecated
    public static StaticScope decodeRootScope(ThreadContext context, String scopeString) {
        return Helpers.decodeScope(context, null, scopeString);
    }

    @Deprecated
    public static StaticScope decodeLocalScope(ThreadContext context, String scopeString) {
        return Helpers.decodeScope(context, context.getCurrentStaticScope(), scopeString);
    }

    @Deprecated
    public static StaticScope decodeLocalScope(ThreadContext context, StaticScope parent, String scopeString) {
        return Helpers.decodeScope(context, parent, scopeString);
    }

    @Deprecated
    public static StaticScope decodeBlockScope(ThreadContext context, String scopeString) {
        return Helpers.decodeScope(context, context.getCurrentStaticScope(), scopeString);
    }

    public static StaticScope decodeScope(ThreadContext context, StaticScope parent, String scopeString) {
        String[][] decodedScope = Helpers.decodeScopeDescriptor(scopeString);
        StaticScope scope = null;
        switch (StaticScope.Type.valueOf(decodedScope[0][0])) {
            case BLOCK: {
                scope = context.runtime.getStaticScopeFactory().newBlockScope(parent, decodedScope[1]);
                break;
            }
            case EVAL: {
                scope = context.runtime.getStaticScopeFactory().newEvalScope(parent, decodedScope[1]);
                break;
            }
            case LOCAL: {
                scope = context.runtime.getStaticScopeFactory().newLocalScope(parent, decodedScope[1]);
            }
        }
        Helpers.setAritiesFromDecodedScope(scope, decodedScope[0]);
        return scope;
    }

    private static String[][] decodeScopeDescriptor(String scopeString) {
        String[] scopeElements = scopeString.split(",");
        String[] scopeNames = scopeElements[1].length() == 0 ? new String[]{} : Helpers.getScopeNames(scopeElements[1]);
        return new String[][]{scopeElements, scopeNames};
    }

    private static void setAritiesFromDecodedScope(StaticScope scope, String[] scopeElements) {
        scope.setArities(Integer.parseInt(scopeElements[2]), Integer.parseInt(scopeElements[3]), Integer.parseInt(scopeElements[4]));
    }

    public static StaticScope decodeScopeAndDetermineModule(ThreadContext context, StaticScope parent, String scopeString) {
        StaticScope scope = Helpers.decodeScope(context, parent, scopeString);
        scope.determineModule();
        return scope;
    }

    private static void performNormalMethodChecks(RubyModule containingClass, Ruby runtime, String name2) throws RaiseException {
        if (containingClass == runtime.getDummy()) {
            throw runtime.newTypeError("no class/module to add method");
        }
        if (containingClass == runtime.getObject() && name2.equals("initialize")) {
            runtime.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining Object#initialize may cause infinite loop");
        }
        if (name2.equals("__id__") || name2.equals("__send__")) {
            runtime.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining `" + name2 + "' may cause serious problem");
        }
    }

    public static RubyClass performSingletonMethodChecks(Ruby runtime, IRubyObject receiver2, String name2) throws RaiseException {
        if (receiver2 instanceof RubyFixnum || receiver2 instanceof RubySymbol) {
            throw runtime.newTypeError("can't define singleton method \"" + name2 + "\" for " + receiver2.getMetaClass().getBaseName());
        }
        if (receiver2.isFrozen()) {
            throw runtime.newFrozenError("object");
        }
        RubyClass rubyClass = receiver2.getSingletonClass();
        return rubyClass;
    }

    public static IRubyObject arrayEntryOrNil(RubyArray array, int index2) {
        if (index2 < array.getLength()) {
            return array.eltInternal(index2);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayEntryOrNilZero(RubyArray array) {
        if (0 < array.getLength()) {
            return array.eltInternal(0);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayEntryOrNilOne(RubyArray array) {
        if (1 < array.getLength()) {
            return array.eltInternal(1);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayEntryOrNilTwo(RubyArray array) {
        if (2 < array.getLength()) {
            return array.eltInternal(2);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNil(RubyArray array, int pre, int post, int index2) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + index2);
        }
        if (pre + index2 < array.getLength()) {
            return array.eltInternal(pre + index2);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNilZero(RubyArray array, int pre, int post) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + 0);
        }
        if (pre + 0 < array.getLength()) {
            return array.eltInternal(pre + 0);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNilOne(RubyArray array, int pre, int post) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + 1);
        }
        if (pre + 1 < array.getLength()) {
            return array.eltInternal(pre + 1);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNilTwo(RubyArray array, int pre, int post) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + 2);
        }
        if (pre + 2 < array.getLength()) {
            return array.eltInternal(pre + 2);
        }
        return array.getRuntime().getNil();
    }

    public static RubyArray subarrayOrEmpty(RubyArray array, Ruby runtime, int index2) {
        if (index2 < array.getLength()) {
            return Helpers.createSubarray(array, index2);
        }
        return RubyArray.newEmptyArray(runtime);
    }

    public static RubyArray subarrayOrEmpty(RubyArray array, Ruby runtime, int index2, int post) {
        if (index2 + post < array.getLength()) {
            return Helpers.createSubarray(array, index2, post);
        }
        return RubyArray.newEmptyArray(runtime);
    }

    public static RubyModule checkIsModule(IRubyObject maybeModule) {
        if (maybeModule instanceof RubyModule) {
            return (RubyModule)maybeModule;
        }
        throw maybeModule.getRuntime().newTypeError(maybeModule + " is not a class/module");
    }

    public static IRubyObject getGlobalVariable(Ruby runtime, String name2) {
        return runtime.getGlobalVariables().get(name2);
    }

    public static IRubyObject setGlobalVariable(IRubyObject value2, Ruby runtime, String name2) {
        return runtime.getGlobalVariables().set(name2, value2);
    }

    public static IRubyObject getInstanceVariable(IRubyObject self2, Ruby runtime, String internedName) {
        IRubyObject result2 = self2.getInstanceVariables().getInstanceVariable(internedName);
        if (result2 != null) {
            return result2;
        }
        if (runtime.isVerbose()) {
            Helpers.warnAboutUninitializedIvar(runtime, internedName);
        }
        return runtime.getNil();
    }

    private static void warnAboutUninitializedIvar(Ruby runtime, String internedName) {
        runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + internedName + " not initialized");
    }

    public static IRubyObject setInstanceVariable(IRubyObject value2, IRubyObject self2, String name2) {
        return self2.getInstanceVariables().setInstanceVariable(name2, value2);
    }

    public static RubyProc newLiteralLambda(ThreadContext context, Block block, IRubyObject self2) {
        return RubyProc.newProc(context.runtime, block, Block.Type.LAMBDA);
    }

    public static void fillNil(IRubyObject[] arr, int from, int to, Ruby runtime) {
        if (arr.length == 0) {
            return;
        }
        IRubyObject[] nils = runtime.getNilPrefilledArray();
        int i2 = from;
        while (i2 + 128 < to) {
            System.arraycopy(nils, 0, arr, i2, 128);
            i2 += 128;
        }
        System.arraycopy(nils, 0, arr, i2, to - i2);
    }

    public static void fillNil(IRubyObject[] arr, Ruby runtime) {
        if (arr.length == 0) {
            return;
        }
        Helpers.fillNil(arr, 0, arr.length, runtime);
    }

    public static boolean isFastSwitchableString(IRubyObject str) {
        return str instanceof RubyString;
    }

    public static boolean isFastSwitchableSingleCharString(IRubyObject str) {
        return str instanceof RubyString && ((RubyString)str).getByteList().length() == 1;
    }

    public static int getFastSwitchString(IRubyObject str) {
        ByteList byteList = ((RubyString)str).getByteList();
        return byteList.hashCode();
    }

    public static int getFastSwitchSingleCharString(IRubyObject str) {
        ByteList byteList = ((RubyString)str).getByteList();
        return byteList.get(0);
    }

    public static boolean isFastSwitchableSymbol(IRubyObject sym) {
        return sym instanceof RubySymbol;
    }

    public static boolean isFastSwitchableSingleCharSymbol(IRubyObject sym) {
        return sym instanceof RubySymbol && ((RubySymbol)sym).asJavaString().length() == 1;
    }

    public static int getFastSwitchSymbol(IRubyObject sym) {
        String str = ((RubySymbol)sym).asJavaString();
        return str.hashCode();
    }

    public static int getFastSwitchSingleCharSymbol(IRubyObject sym) {
        String str = ((RubySymbol)sym).asJavaString();
        return str.charAt(0);
    }

    public static Block getBlock(ThreadContext context, IRubyObject self2, Node node) {
        IterNode iter = (IterNode)node;
        iter.getScope().determineModule();
        if (iter.getBlockBody() instanceof InterpretedBlock) {
            return InterpretedBlock.newInterpretedClosure(context, iter.getBlockBody(), self2);
        }
        return Interpreted19Block.newInterpretedClosure(context, iter.getBlockBody(), self2);
    }

    public static Block getBlock(Ruby runtime, ThreadContext context, IRubyObject self2, Node node, Block aBlock) {
        return Helpers.getBlockFromBlockPassBody(runtime, node.interpret(runtime, context, self2, aBlock), aBlock);
    }

    public static RubyBoolean rbEqual(ThreadContext context, IRubyObject a, IRubyObject b) {
        Ruby runtime = context.runtime;
        if (a == b) {
            return runtime.getTrue();
        }
        IRubyObject res = Helpers.invokedynamic(context, a, MethodNames.OP_EQUAL, b);
        return runtime.newBoolean(res.isTrue());
    }

    public static RubyBoolean rbEql(ThreadContext context, IRubyObject a, IRubyObject b) {
        Ruby runtime = context.runtime;
        if (a == b) {
            return runtime.getTrue();
        }
        IRubyObject res = Helpers.invokedynamic(context, a, MethodNames.EQL, b);
        return runtime.newBoolean(res.isTrue());
    }

    public static void traceLine(ThreadContext context, String file2, int line) {
        String name2 = context.getFrameName();
        RubyModule type2 = context.getFrameKlazz();
        context.runtime.callEventHooks(context, RubyEvent.LINE, file2, line, name2, type2);
    }

    public static void traceClass(ThreadContext context) {
        String name2 = context.getFrameName();
        RubyModule type2 = context.getFrameKlazz();
        context.runtime.callEventHooks(context, RubyEvent.CLASS, context.getFile(), context.getLine(), name2, type2);
    }

    public static void traceEnd(ThreadContext context) {
        String name2 = context.getFrameName();
        RubyModule type2 = context.getFrameKlazz();
        context.runtime.callEventHooks(context, RubyEvent.END, context.getFile(), context.getLine(), name2, type2);
    }

    public static String interpretAliasUndefName(Node nameNode, Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        String name2;
        if (nameNode instanceof LiteralNode) {
            name2 = ((LiteralNode)nameNode).getName();
        } else {
            assert (nameNode instanceof DSymbolNode) : "Alias or Undef not literal or dsym";
            name2 = ((RubySymbol)nameNode.interpret(runtime, context, self2, aBlock)).asJavaString();
        }
        return name2;
    }

    public static void checkArgumentCount(ThreadContext context, IRubyObject[] args2, int min2, int max2) {
        Helpers.checkArgumentCount(context, args2.length, min2, max2);
    }

    public static void checkArgumentCount(ThreadContext context, IRubyObject[] args2, int req) {
        Helpers.checkArgumentCount(context, args2.length, req, req);
    }

    public static void checkArgumentCount(ThreadContext context, int length2, int min2, int max2) {
        int expected = 0;
        if (length2 < min2) {
            expected = min2;
        } else if (max2 > -1 && length2 > max2) {
            expected = max2;
        } else {
            return;
        }
        throw context.runtime.newArgumentError(length2, expected);
    }

    public static boolean isModuleAndHasConstant(IRubyObject left2, String name2) {
        return left2 instanceof RubyModule && ((RubyModule)left2).getConstantFromNoConstMissing(name2, false) != null;
    }

    public static RubyString getDefinedConstantOrBoundMethod(IRubyObject left2, String name2) {
        if (Helpers.isModuleAndHasConstant(left2, name2)) {
            return left2.getRuntime().getDefinedMessage(DefinedMessage.CONSTANT);
        }
        if (left2.getMetaClass().isMethodBound(name2, true)) {
            left2.getRuntime().getDefinedMessage(DefinedMessage.METHOD);
        }
        return null;
    }

    public static RubyModule getSuperClassForDefined(Ruby runtime, RubyModule klazz) {
        RubyClass superklazz = klazz.getSuperClass();
        if (superklazz == null && klazz.isModule()) {
            superklazz = runtime.getObject();
        }
        return superklazz;
    }

    public static boolean isGenerationEqual(IRubyObject object, int generation) {
        RubyClass metaClass = object instanceof RubyBasicObject ? ((RubyBasicObject)object).getMetaClass() : object.getMetaClass();
        return metaClass.getGeneration() == generation;
    }

    public static String[] getScopeNames(String scopeNames) {
        StringTokenizer toker = new StringTokenizer(scopeNames, ";");
        ArrayList<String> list2 = new ArrayList<String>(10);
        while (toker.hasMoreTokens()) {
            list2.add(toker.nextToken().intern());
        }
        return list2.toArray(new String[list2.size()]);
    }

    public static IRubyObject[] arraySlice1N(IRubyObject arrayish) {
        arrayish = Helpers.aryToAry(arrayish);
        RubyArray arrayish2 = Helpers.ensureMultipleAssignableRubyArray(arrayish, arrayish.getRuntime(), true);
        return new IRubyObject[]{Helpers.arrayEntryOrNilZero(arrayish2), Helpers.subarrayOrEmpty(arrayish2, arrayish2.getRuntime(), 1)};
    }

    public static IRubyObject arraySlice1(IRubyObject arrayish) {
        arrayish = Helpers.aryToAry(arrayish);
        RubyArray arrayish2 = Helpers.ensureMultipleAssignableRubyArray(arrayish, arrayish.getRuntime(), true);
        return Helpers.arrayEntryOrNilZero(arrayish2);
    }

    public static RubyClass metaclass(IRubyObject object) {
        return object instanceof RubyBasicObject ? ((RubyBasicObject)object).getMetaClass() : object.getMetaClass();
    }

    public static String rawBytesToString(byte[] bytes2) {
        char[] chars2 = new char[bytes2.length];
        for (int i2 = 0; i2 < bytes2.length; ++i2) {
            chars2[i2] = (char)bytes2[i2];
        }
        return new String(chars2);
    }

    public static byte[] stringToRawBytes(String string2) {
        char[] chars2 = string2.toCharArray();
        byte[] bytes2 = new byte[chars2.length];
        for (int i2 = 0; i2 < chars2.length; ++i2) {
            bytes2[i2] = (byte)chars2[i2];
        }
        return bytes2;
    }

    public static String encodeCaptureOffsets(int[] scopeOffsets) {
        char[] encoded = new char[scopeOffsets.length * 2];
        for (int i2 = 0; i2 < scopeOffsets.length; ++i2) {
            int offDepth = scopeOffsets[i2];
            char off = (char)(offDepth & 0xFFFF);
            char depth = (char)(offDepth >> 16);
            encoded[2 * i2] = off;
            encoded[2 * i2 + 1] = depth;
        }
        return new String(encoded);
    }

    public static int[] decodeCaptureOffsets(String encoded) {
        char[] chars2 = encoded.toCharArray();
        int[] scopeOffsets = new int[chars2.length / 2];
        for (int i2 = 0; i2 < scopeOffsets.length; ++i2) {
            char off = chars2[2 * i2];
            char depth = chars2[2 * i2 + 1];
            scopeOffsets[i2] = depth << 16 | off;
        }
        return scopeOffsets;
    }

    public static IRubyObject match2AndUpdateScope(IRubyObject receiver2, ThreadContext context, IRubyObject value2, String scopeOffsets) {
        IRubyObject match2 = ((RubyRegexp)receiver2).op_match(context, value2);
        Helpers.updateScopeWithCaptures(context, Helpers.decodeCaptureOffsets(scopeOffsets), match2);
        return match2;
    }

    public static IRubyObject match2AndUpdateScope19(IRubyObject receiver2, ThreadContext context, IRubyObject value2, String scopeOffsets) {
        IRubyObject match2 = ((RubyRegexp)receiver2).op_match19(context, value2);
        Helpers.updateScopeWithCaptures(context, Helpers.decodeCaptureOffsets(scopeOffsets), match2);
        return match2;
    }

    public static void updateScopeWithCaptures(ThreadContext context, int[] scopeOffsets, IRubyObject result2) {
        Ruby runtime = context.runtime;
        if (result2.isNil()) {
            IRubyObject nil = runtime.getNil();
            for (int i2 = 0; i2 < scopeOffsets.length; ++i2) {
                context.getCurrentScope().setValue(nil, scopeOffsets[i2], 0);
            }
        } else {
            RubyMatchData matchData = (RubyMatchData)context.getBackRef();
            IRubyObject[] namedValues = matchData.getNamedBackrefValues(runtime);
            for (int i3 = 0; i3 < scopeOffsets.length; ++i3) {
                context.getCurrentScope().setValue(namedValues[i3], scopeOffsets[i3] & 0xFFFF, scopeOffsets[i3] >> 16);
            }
        }
    }

    public static RubyArray argsPush(RubyArray first2, IRubyObject second) {
        return ((RubyArray)first2.dup()).append(second);
    }

    public static RubyArray argsCat(IRubyObject first2, IRubyObject second) {
        Ruby runtime = first2.getRuntime();
        RubyArray secondArgs = runtime.is1_9() ? Helpers.splatValue19(second) : Helpers.splatValue(second);
        return ((RubyArray)Helpers.ensureRubyArray(runtime, first2).dup()).concat(secondArgs);
    }

    public static String encodeParameterList(ArgsNode argsNode) {
        StringBuilder builder = new StringBuilder();
        boolean added = false;
        if (argsNode.getPre() != null) {
            for (Node preNode : argsNode.getPre().childNodes()) {
                if (added) {
                    builder.append(';');
                }
                added = true;
                if (preNode instanceof MultipleAsgn19Node) {
                    builder.append("nil");
                    continue;
                }
                builder.append("q").append(((ArgumentNode)preNode).getName());
            }
        }
        if (argsNode.getOptArgs() != null) {
            for (Node optNode : argsNode.getOptArgs().childNodes()) {
                if (added) {
                    builder.append(';');
                }
                added = true;
                builder.append("o");
                if (optNode instanceof OptArgNode) {
                    builder.append(((OptArgNode)optNode).getName());
                    continue;
                }
                if (optNode instanceof LocalAsgnNode) {
                    builder.append(((LocalAsgnNode)optNode).getName());
                    continue;
                }
                if (!(optNode instanceof DAsgnNode)) continue;
                builder.append(((DAsgnNode)optNode).getName());
            }
        }
        if (argsNode.getRestArg() >= 0) {
            if (added) {
                builder.append(';');
            }
            added = true;
            if (argsNode.getRestArgNode() instanceof UnnamedRestArgNode) {
                if (((UnnamedRestArgNode)argsNode.getRestArgNode()).isStar()) {
                    builder.append("R");
                }
            } else {
                builder.append("r").append(argsNode.getRestArgNode().getName());
            }
        }
        if (argsNode.getPost() != null) {
            for (Node postNode : argsNode.getPost().childNodes()) {
                if (added) {
                    builder.append(';');
                }
                added = true;
                if (postNode instanceof MultipleAsgn19Node) {
                    builder.append("nil");
                    continue;
                }
                builder.append("q").append(((ArgumentNode)postNode).getName());
            }
        }
        if (argsNode.getBlock() != null) {
            if (added) {
                builder.append(';');
            }
            added = true;
            builder.append("b").append(argsNode.getBlock().getName());
        }
        if (!added) {
            return "NONE";
        }
        return builder.toString();
    }

    public static RubyArray parameterListToParameters(Ruby runtime, String[] parameterList, boolean isLambda) {
        RubyArray parms = RubyArray.newEmptyArray(runtime);
        for (String param : parameterList) {
            if (param.equals("NONE")) break;
            RubyArray elem = RubyArray.newEmptyArray(runtime);
            if (param.equals("nil")) {
                elem.add(RubySymbol.newSymbol(runtime, isLambda ? "req" : "opt"));
                parms.add(elem);
                continue;
            }
            if (param.length() == 0) {
                System.out.println(Arrays.toString(parameterList));
            }
            if (param.charAt(0) == 'q') {
                elem.add(RubySymbol.newSymbol(runtime, isLambda ? "req" : "opt"));
            } else if (param.charAt(0) == 'r') {
                elem.add(RubySymbol.newSymbol(runtime, "rest"));
            } else {
                if (param.charAt(0) == 'R') {
                    elem.add(RubySymbol.newSymbol(runtime, "rest"));
                    parms.add(elem);
                    continue;
                }
                if (param.charAt(0) == 'o') {
                    elem.add(RubySymbol.newSymbol(runtime, "opt"));
                    if (param.length() == 1) {
                        parms.add(elem);
                        continue;
                    }
                } else if (param.charAt(0) == 'b') {
                    elem.add(RubySymbol.newSymbol(runtime, "block"));
                }
            }
            if (param.length() > 1) {
                elem.add(RubySymbol.newSymbol(runtime, param.substring(1)));
            }
            parms.add(elem);
        }
        return parms;
    }

    public static RubyString getDefinedCall(ThreadContext context, IRubyObject self2, IRubyObject receiver2, String name2) {
        RubyClass metaClass = receiver2.getMetaClass();
        DynamicMethod method2 = metaClass.searchMethod(name2);
        Visibility visibility = method2.getVisibility();
        if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || metaClass.getRealClass().isInstance(self2)) && !method2.isUndefined()) {
            return context.runtime.getDefinedMessage(DefinedMessage.METHOD);
        }
        if (context.runtime.is1_9() && receiver2.callMethod(context, "respond_to_missing?", new IRubyObject[]{context.runtime.newSymbol(name2), context.runtime.getFalse()}).isTrue()) {
            return context.runtime.getDefinedMessage(DefinedMessage.METHOD);
        }
        return null;
    }

    public static RubyString getDefinedNot(Ruby runtime, RubyString definition) {
        if (definition != null && runtime.is1_9()) {
            definition = runtime.getDefinedMessage(DefinedMessage.METHOD);
        }
        return definition;
    }

    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self2, MethodNames method2) {
        RubyClass metaclass = self2.getMetaClass();
        String name2 = method2.realName();
        return Helpers.getMethodCached(context, metaclass, method2.ordinal(), name2).call(context, self2, metaclass, name2);
    }

    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self2, MethodNames method2, IRubyObject arg0) {
        RubyClass metaclass = self2.getMetaClass();
        String name2 = method2.realName();
        return Helpers.getMethodCached(context, metaclass, method2.ordinal(), name2).call(context, self2, (RubyModule)metaclass, name2, arg0);
    }

    private static DynamicMethod getMethodCached(ThreadContext context, RubyClass metaclass, int index2, String name2) {
        if (metaclass.index == 0 || metaclass.index >= 39) {
            return metaclass.searchMethod(name2);
        }
        return context.runtimeCache.getMethod(context, metaclass, metaclass.index * (index2 + 1), name2);
    }

    public static IRubyObject lastElement(IRubyObject[] ary) {
        return ary[ary.length - 1];
    }

    public static RubyString appendAsString(RubyString target, IRubyObject other) {
        return target.append(other.asString());
    }

    public static RubyString appendAsString19(RubyString target, IRubyObject other) {
        return target.append19(other.asString());
    }

    public static boolean needsSplat19(int requiredCount, boolean isRest) {
        return isRest && requiredCount > 0 || !isRest && requiredCount > 1;
    }

    public static IRubyObject[] restructureBlockArgs19(IRubyObject value2, Arity arity2, Block.Type type2, boolean needsSplat, boolean alreadyArray) {
        if (!type2.checkArity && arity2 == Arity.NO_ARGUMENTS) {
            return IRubyObject.NULL_ARRAY;
        }
        if (value2 != null && !(value2 instanceof RubyArray) && needsSplat) {
            value2 = Helpers.aryToAry(value2);
        }
        IRubyObject[] parameters2 = value2 == null ? IRubyObject.NULL_ARRAY : (value2 instanceof RubyArray && (alreadyArray || needsSplat) ? ((RubyArray)value2).toJavaArray() : new IRubyObject[]{value2});
        return parameters2;
    }

    public static boolean BEQ(ThreadContext context, IRubyObject value1, IRubyObject value2) {
        return value1.op_equal(context, value2).isTrue();
    }

    public static boolean BNE(ThreadContext context, IRubyObject value1, IRubyObject value2) {
        boolean eql2 = value2 == context.nil || value2 == UndefinedValue.UNDEFINED ? value1 == value2 : value1.op_equal(context, value2).isTrue();
        return !eql2;
    }

    public static RubyModule checkIsRubyModule(ThreadContext context, Object object) {
        if (!(object instanceof RubyModule)) {
            throw context.runtime.newTypeError("no outer class/module");
        }
        return (RubyModule)object;
    }

    public static IRubyObject invokeModuleBody(ThreadContext context, CompiledIRMethod method2) {
        RubyModule implClass = method2.getImplementationClass();
        return method2.call(context, implClass, implClass, "");
    }

    public static RubyClass newClassForIR(ThreadContext context, String name2, IRubyObject self2, RubyModule classContainer, Object superClass, boolean meta) {
        if (meta) {
            return classContainer.getMetaClass();
        }
        RubyClass sc = null;
        if (superClass != null) {
            if (!(superClass instanceof RubyClass)) {
                throw context.runtime.newTypeError("superclass must be Class (" + superClass + " given)");
            }
            sc = (RubyClass)superClass;
        }
        return classContainer.defineOrGetClassUnder(name2, sc);
    }

    public static RubyString appendByteList(RubyString target, ByteList source2) {
        target.getByteList().append(source2);
        return target;
    }

    public static RubyString appendByteList19(RubyString target, ByteList source2, int codeRange) {
        target.cat19(source2, codeRange);
        return target;
    }

    public static RubyString shortcutAppend18(RubyString string2, IRubyObject object) {
        if (object instanceof RubyFixnum || object instanceof RubyFloat || object instanceof RubySymbol) {
            return string2.append(object);
        }
        return string2.append(object.asString());
    }

    public static RubyString shortcutAppend(RubyString string2, IRubyObject object) {
        if (object instanceof RubyFixnum || object instanceof RubyFloat || object instanceof RubySymbol) {
            return string2.append19(object);
        }
        return string2.append19(object.asString());
    }

    public static void irCheckArgsArrayArity(ThreadContext context, RubyArray args2, int required, int opt, int rest2) {
        int numArgs = args2.size();
        if (numArgs < required || rest2 == -1 && numArgs > required + opt) {
            Arity.raiseArgumentError(context.runtime, numArgs, required, required + opt);
        }
    }

    public static RubyArray irSplat(ThreadContext context, IRubyObject maybeAry) {
        return context.is19 ? Helpers.splatValue19(maybeAry) : Helpers.splatValue(maybeAry);
    }

    public static IRubyObject irToAry(ThreadContext context, IRubyObject receiver2, boolean dontToAryArrays) {
        if (dontToAryArrays && receiver2 instanceof RubyArray) {
            return receiver2;
        }
        IRubyObject ary = Helpers.aryToAry(receiver2);
        if (ary instanceof RubyArray) {
            return ary;
        }
        String receiverType = receiver2.getType().getName();
        throw context.runtime.newTypeError("can't convert " + receiverType + " to Array (" + receiverType + "#to_ary gives " + ary.getType().getName() + ")");
    }

    public static IRubyObject irReqdArgMultipleAsgn(ThreadContext context, RubyArray rubyArray, int preArgsCount, int index2, int postArgsCount) {
        int n = rubyArray.getLength();
        if (preArgsCount == -1) {
            return rubyArray.entry(index2);
        }
        int remaining = n - preArgsCount;
        if (remaining <= index2) {
            return context.nil;
        }
        return remaining > postArgsCount ? rubyArray.entry(n - postArgsCount + index2) : rubyArray.entry(preArgsCount + index2);
    }

    public static IRubyObject irNot(ThreadContext context, IRubyObject obj) {
        return context.runtime.newBoolean(!obj.isTrue());
    }

    public static IRubyObject irLoadOptArg(int minReqd, int argIndex, IRubyObject[] args2) {
        int kwArgHashCount = 0;
        if (minReqd + kwArgHashCount < args2.length) {
            return args2[argIndex];
        }
        return UndefinedValue.UNDEFINED;
    }

    public static IRubyObject irPostReqdArg(int argIndex, int preReqdArgsCount, int postReqdArgsCount, IRubyObject[] args2) {
        int n = args2.length;
        int kwArgHashCount = 0;
        int remaining = n - preReqdArgsCount - kwArgHashCount;
        if (remaining <= argIndex) {
            return null;
        }
        return remaining > postReqdArgsCount ? args2[n - postReqdArgsCount - kwArgHashCount + argIndex] : args2[preReqdArgsCount + argIndex];
    }

    public static IRubyObject irLoadRestArg(ThreadContext context, int minReqd, int argIndex, IRubyObject[] args2) {
        IRubyObject[] ret;
        int kwArgHashCount = 0;
        int numAvailable = args2.length - minReqd - kwArgHashCount;
        if (numAvailable <= 0) {
            ret = NO_PARAMS;
        } else {
            ret = new IRubyObject[numAvailable];
            System.arraycopy(args2, argIndex, ret, 0, numAvailable);
        }
        return context.getRuntime().newArray(ret);
    }

    @Deprecated
    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self2, int index2) {
        return Helpers.invokedynamic(context, self2, MethodNames.values()[index2]);
    }

    @Deprecated
    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self2, int index2, IRubyObject arg0) {
        return Helpers.invokedynamic(context, self2, MethodNames.values()[index2], arg0);
    }

    public static void throwException(Throwable e) {
        Helpers.throwsUnchecked(e);
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable t) throws T {
        throw t;
    }

    public static String symbolBytesToString(ByteList value2) {
        Encoding encoding2 = value2.getEncoding();
        if (encoding2 == USASCIIEncoding.INSTANCE || encoding2 == ASCIIEncoding.INSTANCE) {
            return value2.toString();
        }
        if (encoding2 instanceof UnicodeEncoding) {
            return new String(value2.getUnsafeBytes(), value2.getBegin(), value2.getRealSize(), value2.getEncoding().getCharset());
        }
        return value2.toString();
    }

    public static String decodeByteList(Ruby runtime, ByteList value2) {
        byte[] unsafeBytes = value2.getUnsafeBytes();
        int begin2 = value2.getBegin();
        int length2 = value2.length();
        if (runtime.is1_9()) {
            Encoding encoding2 = value2.getEncoding();
            if (encoding2 == UTF8Encoding.INSTANCE) {
                return RubyEncoding.decodeUTF8(unsafeBytes, begin2, length2);
            }
            Charset charset = runtime.getEncodingService().charsetForEncoding(encoding2);
            if (charset == null) {
                try {
                    return new String(unsafeBytes, begin2, length2, encoding2.toString());
                }
                catch (UnsupportedEncodingException uee) {
                    return value2.toString();
                }
            }
            return RubyEncoding.decode(unsafeBytes, begin2, length2, charset);
        }
        return RubyEncoding.decodeUTF8(unsafeBytes, begin2, length2);
    }

    public static String byteListToString(ByteList byteList) {
        if (byteList.getEncoding().getCharset() != null) {
            return new String(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize(), byteList.getEncoding().getCharset());
        }
        return byteList.toString();
    }

    public static IRubyObject rewriteStackTraceAndThrow(Throwable t, Ruby runtime) {
        StackTraceElement[] javaTrace = t.getStackTrace();
        BacktraceData backtraceData = runtime.getInstanceConfig().getTraceType().getIntegratedBacktrace(runtime.getCurrentContext(), javaTrace);
        t.setStackTrace(RaiseException.javaTraceFromRubyTrace(backtraceData.getBacktrace(runtime)));
        Helpers.throwException(t);
        return null;
    }

    private static class MethodMissingMethod
    extends DynamicMethod {
        private final DynamicMethod delegate;
        private final CallType lastCallStatus;

        public MethodMissingMethod(DynamicMethod delegate2, CallType lastCallStatus) {
            this.delegate = delegate2;
            this.lastCallStatus = lastCallStatus;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            context.setLastCallStatus(this.lastCallStatus);
            return this.delegate.call(context, self2, clazz, "method_missing", Helpers.prepareMethodMissingArgs(args2, context, name2), block);
        }

        @Override
        public DynamicMethod dup() {
            return this;
        }
    }
}

