/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.nio.ByteBuffer;
import jnr.ffi.Pointer;
import jnr.posix.CmsgHdr;
import jnr.posix.NativePOSIX;

abstract class BaseCmsgHdr
implements CmsgHdr {
    protected final NativePOSIX posix;
    final Pointer memory;

    protected BaseCmsgHdr(NativePOSIX posix, Pointer memory) {
        this.posix = posix;
        this.memory = memory;
    }

    protected BaseCmsgHdr(NativePOSIX posix, Pointer memory, int totalLen) {
        this.posix = posix;
        this.memory = memory;
        this.setLen(totalLen);
    }

    @Override
    public void setData(ByteBuffer data2) {
        byte[] bytes2 = new byte[data2.capacity() - data2.position()];
        data2.get(bytes2);
        this.posix.socketMacros().CMSG_DATA(this.memory).put(0L, bytes2, 0, bytes2.length);
    }

    @Override
    public ByteBuffer getData() {
        int dataLen = this.getLen() - this.posix.socketMacros().CMSG_LEN(0);
        if (dataLen == 0) {
            return null;
        }
        byte[] bytes2 = new byte[dataLen];
        this.posix.socketMacros().CMSG_DATA(this.memory).get(0L, bytes2, 0, bytes2.length);
        ByteBuffer buf = ByteBuffer.allocate(bytes2.length);
        buf.put(bytes2);
        buf.flip();
        return buf;
    }

    abstract void setLen(int var1);
}

