/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.util.stream.Collectors;
import org.owasp.dependencycheck.data.nvd.json.CpeMatchStreamCollector;
import org.owasp.dependencycheck.data.nvd.json.DefCveItem;
import org.owasp.dependencycheck.data.nvd.json.NodeFlatteningCollector;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;

public class CveItemOperator {
    private final String cpeStartsWithFilter;

    public CveItemOperator(String cpeStartsWithFilter) {
        this.cpeStartsWithFilter = cpeStartsWithFilter;
    }

    public String extractDescription(DefCveItem cve) {
        return cve.getCve().getDescription().getDescriptionData().stream().filter(desc -> "en".equals(desc.getLang())).map(d -> d.getValue()).collect(Collectors.joining(" "));
    }

    private String extractEcosystem(String baseEcosystem, String vendor, String product, String targetSw) {
        if ("mysql".equals(vendor) && "mysql".equals(product) || "postgresql".equals(vendor) && "postgresql".equals(product) || "picketlink".equals(vendor) && "picketlink".equals(product) || "libxl_project".equals(vendor) && "libxl".equals(product) || "ocaml".equals(vendor) && "postgresql-ocaml".equals(product) || "curses_project".equals(vendor) && "curses".equals(product) || "dalekjs".equals(vendor) && "dalekjs".equals(product) || "microsoft".equals(vendor) && "internet_explorer".equals(product) || "jenkins".equals(vendor) && "ssh_credentials".equals(product) || "kubernetes".equals(vendor) && "kubernetes".equals(product) || "gnome".equals(vendor) && "nautilus-python".equals(product) || "apache".equals(vendor) && "qpid_proton".equals(product) || "mysql-ocaml".equals(vendor) && "mysql-ocaml".equals(product) || "google".equals(vendor) && "chrome".equals(product) || "canonical".equals(vendor) && "ltsp_display_manager".equals(product) || "gnome".equals(vendor) && "vala".equals(product) || "apple".equals(vendor) && "safari".equals(product) || "mapbox".equals(vendor) && "npm-test-sqlite3-trunk".equals(product) || "apple".equals(vendor) && "webkit".equals(product) || "mozilla".equals(vendor) && "firefox".equals(product) || "apache".equals(vendor) && "thrift".equals(product) || "apache".equals(vendor) && "qpid".equals(product) || "mozilla".equals(vendor) && "thunderbird".equals(product) || "mozilla".equals(vendor) && "firefox_esr".equals(product) || "redhat".equals(vendor) && "jboss_amq_clients_2".equals(product) || "node-opencv_project".equals(vendor) && "node-opencv".equals(product) || "mozilla".equals(vendor) && "seamonkey".equals(product) || "mozilla".equals(vendor) && "thunderbird_esr".equals(product) || "mnet_soft_factory".equals(vendor) && "nodemanager_professional".equals(product) || "mozilla".equals(vendor) && "mozilla_suite".equals(product) || "theforeman".equals(vendor) && "hammer_cli".equals(product) || "ibm".equals(vendor) && "websphere_application_server".equals(product) || "sap".equals(vendor) && "hana_extend_application_services".equals(product) || "apache".equals(vendor) && "zookeeper".equals(product)) {
            return null;
        }
        if ("ibm".equals(vendor) && "java".equals(product)) {
            return "native";
        }
        if ("oracle".equals(vendor) && "vm".equals(product)) {
            return "native";
        }
        switch (targetSw) {
            case "asp.net": 
            case "c#": 
            case ".net": 
            case "dotnetnuke": {
                return "dotnet";
            }
            case "android": 
            case "java": {
                return "java";
            }
            case "c/c++": 
            case "borland_c++": 
            case "visual_c++": 
            case "gnu_c++": 
            case "linux_kernel": 
            case "linux": 
            case "unix": 
            case "suse_linux": 
            case "redhat_enterprise_linux": 
            case "debian": {
                return "native";
            }
            case "coldfusion": {
                return "coldfusion";
            }
            case "ios": 
            case "iphone": 
            case "ipad": 
            case "iphone_os": {
                return "ios";
            }
            case "jquery": {
                return "js";
            }
            case "node.js": 
            case "nodejs": {
                return "nodejs";
            }
            case "perl": {
                return "perl";
            }
            case "joomla!": 
            case "joomla": 
            case "mybb": 
            case "simplesamlphp": 
            case "craft_cms": 
            case "moodle": 
            case "phpcms": 
            case "buddypress": 
            case "typo3": 
            case "php": 
            case "wordpress": 
            case "drupal": 
            case "mediawiki": 
            case "symfony": 
            case "openpne": 
            case "vbulletin3": 
            case "vbulletin4": {
                return "php";
            }
            case "python": {
                return "python";
            }
            case "ruby": {
                return "ruby";
            }
        }
        return baseEcosystem;
    }

    public String extractEcosystem(String baseEcosystem, VulnerableSoftware parsedCpe) {
        return this.extractEcosystem(baseEcosystem, parsedCpe.getVendor(), parsedCpe.getProduct(), parsedCpe.getTargetSw());
    }

    public boolean isRejected(String description) {
        return description.startsWith("** REJECT **");
    }

    protected boolean testCveCpeStartWithFilter(DefCveItem cve) {
        return cve.getConfigurations().getNodes().stream().collect(NodeFlatteningCollector.getInstance()).collect(CpeMatchStreamCollector.getInstance()).anyMatch(cpe -> cpe.getCpe23Uri().startsWith(this.cpeStartsWithFilter));
    }
}

