/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.toolchain.ToolchainManager;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.api.Utils;
import org.sonarsource.scanner.maven.TimestampLogger;
import org.sonarsource.scanner.maven.bootstrap.LogHandler;
import org.sonarsource.scanner.maven.bootstrap.MavenCompilerResolver;
import org.sonarsource.scanner.maven.bootstrap.MavenProjectConverter;
import org.sonarsource.scanner.maven.bootstrap.PropertyDecryptor;
import org.sonarsource.scanner.maven.bootstrap.ScannerBootstrapper;
import org.sonarsource.scanner.maven.bootstrap.ScannerFactory;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

@Mojo(name="sonar", requiresDependencyResolution=ResolutionScope.TEST, aggregator=true)
public class SonarQubeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(alias="sonar.skip", property="sonar.skip", defaultValue="false")
    private boolean skip;
    @Component
    private LifecycleExecutor lifecycleExecutor;
    @Component(hint="mng-4384")
    private SecDispatcher securityDispatcher;
    @Component
    private RuntimeInformation runtimeInformation;
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    private MojoExecution mojoExecution;
    @Component
    private ToolchainManager toolchainManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getLog().isDebugEnabled()) {
            this.setLog(new TimestampLogger(this.getLog()));
        }
        if (this.shouldDelayExecution()) {
            this.getLog().info((CharSequence)"Delaying SonarQube Scanner to the end of multi-module project");
            return;
        }
        Properties envProps = Utils.loadEnvironmentProperties(System.getenv());
        MavenCompilerResolver mavenCompilerResolver = new MavenCompilerResolver(this.session, this.lifecycleExecutor, this.getLog(), this.toolchainManager);
        MavenProjectConverter mavenProjectConverter = new MavenProjectConverter(this.getLog(), mavenCompilerResolver, envProps);
        LogHandler logHandler = new LogHandler(this.getLog());
        PropertyDecryptor propertyDecryptor = new PropertyDecryptor(this.getLog(), this.securityDispatcher);
        ScannerFactory runnerFactory = new ScannerFactory(logHandler, this.getLog(), this.runtimeInformation, this.mojoExecution, this.session, envProps, propertyDecryptor);
        if (this.isSkip(runnerFactory.createGlobalProperties())) {
            return;
        }
        EmbeddedScanner runner = runnerFactory.create();
        new ScannerBootstrapper(this.getLog(), this.session, runner, mavenProjectConverter, propertyDecryptor).execute();
    }

    private boolean shouldDelayExecution() {
        return !this.isDetachedGoal() && !this.isLastProjectInReactor();
    }

    private boolean isDetachedGoal() {
        return "default-cli".equals(this.mojoExecution.getExecutionId());
    }

    private boolean isLastProjectInReactor() {
        MavenProject lastProject;
        List sortedProjects = this.session.getProjectDependencyGraph().getSortedProjects();
        MavenProject mavenProject = lastProject = sortedProjects.isEmpty() ? this.session.getCurrentProject() : (MavenProject)sortedProjects.get(sortedProjects.size() - 1);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Current project: '" + this.session.getCurrentProject().getName() + "', Last project to execute based on dependency graph: '" + lastProject.getName() + "'"));
        }
        return this.session.getCurrentProject().equals((Object)lastProject);
    }

    private boolean isSkip(Map<String, String> properties) {
        if (this.skip) {
            this.getLog().info((CharSequence)"sonar.skip = true: Skipping analysis");
            return true;
        }
        if ("true".equalsIgnoreCase(properties.get("sonar.scanner.skip"))) {
            this.getLog().info((CharSequence)"SonarQube Scanner analysis skipped");
            return true;
        }
        return false;
    }

    MavenSession getSession() {
        return this.session;
    }
}

