/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveGeoCommands {
    default public Mono<Long> geoAdd(ByteBuffer key, Point point, ByteBuffer member) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)point, (String)"Point must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        return this.geoAdd(key, new RedisGeoCommands.GeoLocation<ByteBuffer>(member, point));
    }

    default public Mono<Long> geoAdd(ByteBuffer key, RedisGeoCommands.GeoLocation<ByteBuffer> location) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(location, (String)"Location must not be null!");
        return this.geoAdd(key, Collections.singletonList(location));
    }

    default public Mono<Long> geoAdd(ByteBuffer key, Collection<RedisGeoCommands.GeoLocation<ByteBuffer>> locations) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(locations, (String)"Locations must not be null!");
        return this.geoAdd((Publisher<GeoAddCommand>)Mono.just((Object)GeoAddCommand.locations(locations).to(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<GeoAddCommand, Long>> geoAdd(Publisher<GeoAddCommand> var1);

    default public Mono<Distance> geoDist(ByteBuffer key, ByteBuffer from, ByteBuffer to) {
        return this.geoDist(key, from, to, RedisGeoCommands.DistanceUnit.METERS);
    }

    default public Mono<Distance> geoDist(ByteBuffer key, ByteBuffer from, ByteBuffer to, Metric metric) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)from, (String)"From must not be null!");
        Assert.notNull((Object)to, (String)"To must not be null!");
        Assert.notNull((Object)metric, (String)"Metric must not be null!");
        return this.geoDist((Publisher<GeoDistCommand>)Mono.just((Object)GeoDistCommand.units(metric).between(from).and(to).forKey(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<GeoDistCommand, Distance>> geoDist(Publisher<GeoDistCommand> var1);

    default public Mono<String> geoHash(ByteBuffer key, ByteBuffer member) {
        Assert.notNull((Object)member, (String)"Member must not be null!");
        return this.geoHash(key, Collections.singletonList(member)).flatMap(vals -> vals.isEmpty() ? Mono.empty() : Mono.justOrEmpty(vals.iterator().next()));
    }

    default public Mono<List<String>> geoHash(ByteBuffer key, Collection<ByteBuffer> members) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(members, (String)"Members must not be null!");
        return this.geoHash((Publisher<GeoHashCommand>)Mono.just((Object)GeoHashCommand.members(members).of(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<GeoHashCommand, String>> geoHash(Publisher<GeoHashCommand> var1);

    default public Mono<Point> geoPos(ByteBuffer key, ByteBuffer member) {
        Assert.notNull((Object)member, (String)"Member must not be null!");
        return this.geoPos(key, Collections.singletonList(member)).flatMap(vals -> vals.isEmpty() ? Mono.empty() : Mono.justOrEmpty(vals.iterator().next()));
    }

    default public Mono<List<Point>> geoPos(ByteBuffer key, Collection<ByteBuffer> members) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(members, (String)"Members must not be null!");
        return this.geoPos((Publisher<GeoPosCommand>)Mono.just((Object)GeoPosCommand.members(members).of(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<GeoPosCommand, Point>> geoPos(Publisher<GeoPosCommand> var1);

    default public Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>> geoRadius(ByteBuffer key, Circle circle) {
        return this.geoRadius(key, circle, RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs());
    }

    default public Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>> geoRadius(ByteBuffer key, Circle circle, RedisGeoCommands.GeoRadiusCommandArgs geoRadiusArgs) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)circle, (String)"Circle must not be null!");
        Assert.notNull((Object)geoRadiusArgs, (String)"GeoRadiusArgs must not be null!");
        return this.geoRadius((Publisher<GeoRadiusCommand>)Mono.just((Object)GeoRadiusCommand.within(circle).withArgs(geoRadiusArgs).forKey(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<GeoRadiusCommand, Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>>>> geoRadius(Publisher<GeoRadiusCommand> var1);

    default public Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>> geoRadiusByMember(ByteBuffer key, ByteBuffer member, Distance distance) {
        return this.geoRadiusByMember(key, member, distance, RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs());
    }

    default public Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>> geoRadiusByMember(ByteBuffer key, ByteBuffer member, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs geoRadiusArgs) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        Assert.notNull((Object)distance, (String)"Distance must not be null!");
        Assert.notNull((Object)geoRadiusArgs, (String)"GeoRadiusArgs must not be null!");
        return this.geoRadiusByMember((Publisher<GeoRadiusByMemberCommand>)Mono.just((Object)GeoRadiusByMemberCommand.within(distance).from(member).forKey(key).withArgs(geoRadiusArgs))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<GeoRadiusByMemberCommand, Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>>>> geoRadiusByMember(Publisher<GeoRadiusByMemberCommand> var1);

    default public Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>> geoSearch(ByteBuffer key, GeoReference<ByteBuffer> reference, GeoShape shape, RedisGeoCommands.GeoSearchCommandArgs args) {
        return this.geoSearch((Publisher<GeoSearchCommand>)Mono.just((Object)GeoSearchCommand.within(shape).in(key).at(reference).with(args))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<GeoSearchCommand, Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>>>> geoSearch(Publisher<GeoSearchCommand> var1);

    default public Mono<Long> geoSearchStore(ByteBuffer destKey, ByteBuffer key, GeoReference<ByteBuffer> reference, GeoShape shape, RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        return this.geoSearchStore((Publisher<GeoSearchStoreCommand>)Mono.just((Object)GeoSearchStoreCommand.within(shape).in(key).storeAt(destKey).at(reference).with(args))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<GeoSearchStoreCommand, Long>> geoSearchStore(Publisher<GeoSearchStoreCommand> var1);

    public static class GeoSearchStoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private final ByteBuffer destKey;
        @Nullable
        private final GeoReference<ByteBuffer> reference;
        @Nullable
        private final GeoShape shape;
        @Nullable
        private final RedisGeoCommands.GeoSearchStoreCommandArgs args;

        private GeoSearchStoreCommand(@Nullable ByteBuffer key, @Nullable ByteBuffer destKey, @Nullable GeoReference<ByteBuffer> reference, @Nullable GeoShape shape, @Nullable RedisGeoCommands.GeoSearchStoreCommandArgs args) {
            super(key);
            this.destKey = destKey;
            this.reference = reference;
            this.shape = shape;
            this.args = args;
        }

        public static GeoSearchStoreCommand within(GeoShape shape) {
            Assert.notNull((Object)shape, (String)"GeoShape must not be null!");
            return new GeoSearchStoreCommand(null, null, null, shape, null);
        }

        public GeoSearchStoreCommand at(GeoReference<ByteBuffer> reference) {
            Assert.notNull(reference, (String)"GeoReference must not be null!");
            return new GeoSearchStoreCommand(this.getKey(), this.getDestKey(), reference, this.getShape(), this.args);
        }

        public GeoSearchStoreCommand in(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new GeoSearchStoreCommand(key, this.getDestKey(), this.getReference(), this.getShape(), this.args);
        }

        public GeoSearchStoreCommand storeAt(ByteBuffer destKey) {
            Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
            return new GeoSearchStoreCommand(this.getKey(), destKey, this.getReference(), this.getShape(), this.args);
        }

        public GeoSearchStoreCommand with(RedisGeoCommands.GeoSearchStoreCommandArgs args) {
            Assert.notNull((Object)args, (String)"Args must not be null!");
            return new GeoSearchStoreCommand(this.getKey(), this.getDestKey(), this.getReference(), this.getShape(), args);
        }

        @Nullable
        public ByteBuffer getDestKey() {
            return this.destKey;
        }

        public Optional<RedisGeoCommands.GeoSearchStoreCommandArgs> getArgs() {
            return Optional.ofNullable(this.args);
        }

        @Nullable
        public GeoReference<ByteBuffer> getReference() {
            return this.reference;
        }

        @Nullable
        public GeoShape getShape() {
            return this.shape;
        }
    }

    public static class GeoSearchCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private final GeoReference<ByteBuffer> reference;
        @Nullable
        private final GeoShape shape;
        @Nullable
        private final RedisGeoCommands.GeoSearchCommandArgs args;

        private GeoSearchCommand(@Nullable ByteBuffer key, @Nullable GeoReference<ByteBuffer> reference, @Nullable GeoShape shape, @Nullable RedisGeoCommands.GeoSearchCommandArgs args) {
            super(key);
            this.reference = reference;
            this.shape = shape;
            this.args = args;
        }

        public static GeoSearchCommand within(GeoShape shape) {
            Assert.notNull((Object)shape, (String)"GeoShape must not be null!");
            return new GeoSearchCommand(null, null, shape, null);
        }

        public GeoSearchCommand at(GeoReference<ByteBuffer> reference) {
            Assert.notNull(reference, (String)"GeoReference must not be null!");
            return new GeoSearchCommand(this.getKey(), reference, this.getShape(), this.args);
        }

        public GeoSearchCommand in(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new GeoSearchCommand(key, this.getReference(), this.getShape(), this.args);
        }

        public GeoSearchCommand with(RedisGeoCommands.GeoSearchCommandArgs args) {
            Assert.notNull((Object)args, (String)"Args must not be null!");
            return new GeoSearchCommand(this.getKey(), this.getReference(), this.getShape(), args);
        }

        public Optional<RedisGeoCommands.GeoSearchCommandArgs> getArgs() {
            return Optional.ofNullable(this.args);
        }

        @Nullable
        public GeoReference<ByteBuffer> getReference() {
            return this.reference;
        }

        @Nullable
        public GeoShape getShape() {
            return this.shape;
        }
    }

    public static class GeoRadiusByMemberCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Distance distance;
        @Nullable
        private final ByteBuffer member;
        private final RedisGeoCommands.GeoRadiusCommandArgs args;
        @Nullable
        private final ByteBuffer store;
        @Nullable
        private final ByteBuffer storeDist;

        private GeoRadiusByMemberCommand(@Nullable ByteBuffer key, @Nullable ByteBuffer member, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs args, @Nullable ByteBuffer store, @Nullable ByteBuffer storeDist) {
            super(key);
            this.distance = distance;
            this.member = member;
            this.args = args;
            this.store = store;
            this.storeDist = storeDist;
        }

        public static GeoRadiusByMemberCommand within(Distance distance) {
            Assert.notNull((Object)distance, (String)"Distance must not be null!");
            return new GeoRadiusByMemberCommand(null, null, distance, RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs(), null, null);
        }

        public static GeoRadiusByMemberCommand withinMeters(double distance) {
            return GeoRadiusByMemberCommand.within(new Distance(distance, (Metric)RedisGeoCommands.DistanceUnit.METERS));
        }

        public static GeoRadiusByMemberCommand withinKiometers(double distance) {
            return GeoRadiusByMemberCommand.within(new Distance(distance, (Metric)RedisGeoCommands.DistanceUnit.KILOMETERS));
        }

        public static GeoRadiusByMemberCommand withinMiles(double distance) {
            return GeoRadiusByMemberCommand.within(new Distance(distance, (Metric)RedisGeoCommands.DistanceUnit.MILES));
        }

        public static GeoRadiusByMemberCommand withinFeet(double distance) {
            return GeoRadiusByMemberCommand.within(new Distance(distance, (Metric)RedisGeoCommands.DistanceUnit.FEET));
        }

        public GeoRadiusByMemberCommand from(ByteBuffer member) {
            Assert.notNull((Object)member, (String)"Member must not be null!");
            return new GeoRadiusByMemberCommand(this.getKey(), member, this.distance, this.args, this.store, this.storeDist);
        }

        public GeoRadiusByMemberCommand withFlag(RedisGeoCommands.GeoRadiusCommandArgs.Flag flag) {
            Assert.notNull((Object)flag, (String)"Flag must not be null!");
            RedisGeoCommands.GeoRadiusCommandArgs args = this.cloneArgs();
            args.getFlags().add(flag);
            return new GeoRadiusByMemberCommand(this.getKey(), this.member, this.distance, args, this.store, this.storeDist);
        }

        public GeoRadiusByMemberCommand withCoord() {
            return this.withFlag(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD);
        }

        public GeoRadiusByMemberCommand withDist() {
            return this.withFlag(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHDIST);
        }

        public GeoRadiusByMemberCommand withArgs(RedisGeoCommands.GeoRadiusCommandArgs args) {
            Assert.notNull((Object)args, (String)"Args must not be null!");
            return new GeoRadiusByMemberCommand(this.getKey(), this.member, this.distance, args, this.store, this.storeDist);
        }

        public GeoRadiusByMemberCommand limitTo(long limit) {
            RedisGeoCommands.GeoRadiusCommandArgs args = this.cloneArgs();
            args.limit(limit);
            return new GeoRadiusByMemberCommand(this.getKey(), this.member, this.distance, args, this.store, this.storeDist);
        }

        public GeoRadiusByMemberCommand sort(Sort.Direction direction) {
            Assert.notNull((Object)direction, (String)"Direction must not be null!");
            RedisGeoCommands.GeoRadiusCommandArgs args = this.cloneArgs();
            args.sort(direction);
            return new GeoRadiusByMemberCommand(this.getKey(), this.member, this.distance, args, this.store, this.storeDist);
        }

        public GeoRadiusByMemberCommand orderByDistanceAsc() {
            return this.sort(Sort.Direction.ASC);
        }

        public GeoRadiusByMemberCommand orderByDistanceDesc() {
            return this.sort(Sort.Direction.DESC);
        }

        public GeoRadiusByMemberCommand forKey(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new GeoRadiusByMemberCommand(key, this.member, this.distance, this.args, this.store, this.storeDist);
        }

        public GeoRadiusByMemberCommand storeAt(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new GeoRadiusByMemberCommand(this.getKey(), this.member, this.distance, this.args, key, this.storeDist);
        }

        public GeoRadiusByMemberCommand storeDistAt(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new GeoRadiusByMemberCommand(this.getKey(), this.member, this.distance, this.args, this.store, key);
        }

        public Optional<Sort.Direction> getDirection() {
            return Optional.ofNullable(this.args.getSortDirection());
        }

        public Distance getDistance() {
            return this.distance;
        }

        public Set<RedisGeoCommands.GeoRadiusCommandArgs.Flag> getFlags() {
            return this.args.getFlags();
        }

        public Optional<Long> getLimit() {
            return Optional.ofNullable(this.args.getLimit());
        }

        @Nullable
        public ByteBuffer getMember() {
            return this.member;
        }

        public Optional<ByteBuffer> getStore() {
            return Optional.ofNullable(this.store);
        }

        public Optional<ByteBuffer> getStoreDist() {
            return Optional.ofNullable(this.storeDist);
        }

        public Optional<RedisGeoCommands.GeoRadiusCommandArgs> getArgs() {
            return Optional.ofNullable(this.args);
        }

        private RedisGeoCommands.GeoRadiusCommandArgs cloneArgs() {
            if (this.args == null) {
                return RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs();
            }
            return this.args.clone();
        }
    }

    public static class GeoRadiusCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Distance distance;
        @Nullable
        private final Point point;
        private final RedisGeoCommands.GeoRadiusCommandArgs args;
        @Nullable
        private final ByteBuffer store;
        @Nullable
        private final ByteBuffer storeDist;

        private GeoRadiusCommand(@Nullable ByteBuffer key, @Nullable Point point, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs args, @Nullable ByteBuffer store, @Nullable ByteBuffer storeDist) {
            super(key);
            this.distance = distance;
            this.point = point;
            this.args = args;
            this.store = store;
            this.storeDist = storeDist;
        }

        public static GeoRadiusCommand within(Distance distance) {
            Assert.notNull((Object)distance, (String)"Distance must not be null!");
            return new GeoRadiusCommand(null, null, distance, RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs(), null, null);
        }

        public static GeoRadiusCommand withinMeters(double distance) {
            return GeoRadiusCommand.within(new Distance(distance, (Metric)RedisGeoCommands.DistanceUnit.METERS));
        }

        public static GeoRadiusCommand withinKilometers(double distance) {
            return GeoRadiusCommand.within(new Distance(distance, (Metric)RedisGeoCommands.DistanceUnit.KILOMETERS));
        }

        public static GeoRadiusCommand withinMiles(double distance) {
            return GeoRadiusCommand.within(new Distance(distance, (Metric)RedisGeoCommands.DistanceUnit.MILES));
        }

        public static GeoRadiusCommand withinFeet(double distance) {
            return GeoRadiusCommand.within(new Distance(distance, (Metric)RedisGeoCommands.DistanceUnit.FEET));
        }

        public static GeoRadiusCommand within(Circle circle) {
            Assert.notNull((Object)circle, (String)"Circle must not be null!");
            return GeoRadiusCommand.within(circle.getRadius()).from(circle.getCenter());
        }

        public GeoRadiusCommand from(Point center) {
            Assert.notNull((Object)center, (String)"Center point must not be null!");
            return new GeoRadiusCommand(this.getKey(), center, this.distance, this.args, this.store, this.storeDist);
        }

        public GeoRadiusCommand withFlag(RedisGeoCommands.GeoRadiusCommandArgs.Flag flag) {
            Assert.notNull((Object)flag, (String)"Flag must not be null!");
            RedisGeoCommands.GeoRadiusCommandArgs args = this.cloneArgs();
            args.getFlags().add(flag);
            return new GeoRadiusCommand(this.getKey(), this.point, this.distance, args, this.store, this.storeDist);
        }

        public GeoRadiusCommand withCoord() {
            return this.withFlag(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD);
        }

        public GeoRadiusCommand withDist() {
            return this.withFlag(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHDIST);
        }

        public GeoRadiusCommand withArgs(RedisGeoCommands.GeoRadiusCommandArgs args) {
            Assert.notNull((Object)args, (String)"Args must not be null!");
            return new GeoRadiusCommand(this.getKey(), this.point, this.distance, args == null ? RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs() : args, this.store, this.storeDist);
        }

        public GeoRadiusCommand limitTo(long limit) {
            RedisGeoCommands.GeoRadiusCommandArgs args = this.cloneArgs();
            args = args.limit(limit);
            return new GeoRadiusCommand(this.getKey(), this.point, this.distance, args, this.store, this.storeDist);
        }

        public GeoRadiusCommand sort(Sort.Direction direction) {
            Assert.notNull((Object)direction, (String)"Direction must not be null!");
            RedisGeoCommands.GeoRadiusCommandArgs args = this.cloneArgs();
            args.sort(direction);
            return new GeoRadiusCommand(this.getKey(), this.point, this.distance, args, this.store, this.storeDist);
        }

        public GeoRadiusCommand orderByDistanceAsc() {
            return this.sort(Sort.Direction.ASC);
        }

        public GeoRadiusCommand orderByDistanceDesc() {
            return this.sort(Sort.Direction.DESC);
        }

        public GeoRadiusCommand forKey(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new GeoRadiusCommand(key, this.point, this.distance, this.args, this.store, this.storeDist);
        }

        public GeoRadiusCommand storeAt(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new GeoRadiusCommand(this.getKey(), this.point, this.distance, this.args, key, this.storeDist);
        }

        public GeoRadiusCommand storeDistAt(@Nullable ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new GeoRadiusCommand(this.getKey(), this.point, this.distance, this.args, this.store, key);
        }

        public Optional<Sort.Direction> getDirection() {
            return Optional.ofNullable(this.args.getSortDirection());
        }

        public Distance getDistance() {
            return this.distance;
        }

        public Set<RedisGeoCommands.GeoRadiusCommandArgs.Flag> getFlags() {
            return this.args.getFlags();
        }

        public Optional<Long> getLimit() {
            return Optional.ofNullable(this.args.getLimit());
        }

        @Nullable
        public Point getPoint() {
            return this.point;
        }

        public Optional<ByteBuffer> getStore() {
            return Optional.ofNullable(this.store);
        }

        public Optional<ByteBuffer> getStoreDist() {
            return Optional.ofNullable(this.storeDist);
        }

        public Optional<RedisGeoCommands.GeoRadiusCommandArgs> getArgs() {
            return Optional.ofNullable(this.args);
        }

        private RedisGeoCommands.GeoRadiusCommandArgs cloneArgs() {
            if (this.args == null) {
                return RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs();
            }
            return this.args.clone();
        }
    }

    public static class GeoPosCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> members;

        private GeoPosCommand(@Nullable ByteBuffer key, List<ByteBuffer> members) {
            super(key);
            this.members = members;
        }

        public static GeoPosCommand member(ByteBuffer member) {
            Assert.notNull((Object)member, (String)"Member must not be null!");
            return new GeoPosCommand(null, Collections.singletonList(member));
        }

        public static GeoPosCommand members(Collection<ByteBuffer> members) {
            Assert.notNull(members, (String)"Members must not be null!");
            return new GeoPosCommand(null, new ArrayList<ByteBuffer>(members));
        }

        public GeoPosCommand of(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new GeoPosCommand(key, this.members);
        }

        public List<ByteBuffer> getMembers() {
            return this.members;
        }
    }

    public static class GeoHashCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> members;

        private GeoHashCommand(@Nullable ByteBuffer key, List<ByteBuffer> members) {
            super(key);
            this.members = members;
        }

        public static GeoHashCommand member(ByteBuffer member) {
            Assert.notNull((Object)member, (String)"Member must not be null!");
            return new GeoHashCommand(null, Collections.singletonList(member));
        }

        public static GeoHashCommand members(Collection<ByteBuffer> members) {
            Assert.notNull(members, (String)"Members must not be null!");
            return new GeoHashCommand(null, new ArrayList<ByteBuffer>(members));
        }

        public GeoHashCommand of(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new GeoHashCommand(key, this.members);
        }

        public List<ByteBuffer> getMembers() {
            return this.members;
        }
    }

    public static class GeoDistCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBuffer from;
        private final ByteBuffer to;
        private final Metric metric;

        private GeoDistCommand(@Nullable ByteBuffer key, @Nullable ByteBuffer from, @Nullable ByteBuffer to, Metric metric) {
            super(key);
            this.from = from;
            this.to = to;
            this.metric = metric;
        }

        static GeoDistCommand units(Metric unit) {
            return new GeoDistCommand(null, null, null, unit);
        }

        public static GeoDistCommand meters() {
            return GeoDistCommand.units(RedisGeoCommands.DistanceUnit.METERS);
        }

        public static GeoDistCommand kilometers() {
            return GeoDistCommand.units(RedisGeoCommands.DistanceUnit.KILOMETERS);
        }

        public static GeoDistCommand miles() {
            return GeoDistCommand.units(RedisGeoCommands.DistanceUnit.MILES);
        }

        public static GeoDistCommand feet() {
            return GeoDistCommand.units(RedisGeoCommands.DistanceUnit.FEET);
        }

        public GeoDistCommand between(ByteBuffer from) {
            Assert.notNull((Object)from, (String)"From member must not be null!");
            return new GeoDistCommand(this.getKey(), from, this.to, this.metric);
        }

        public GeoDistCommand and(ByteBuffer to) {
            Assert.notNull((Object)to, (String)"To member must not be null");
            return new GeoDistCommand(this.getKey(), this.from, to, this.metric);
        }

        public GeoDistCommand forKey(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new GeoDistCommand(key, this.from, this.to, this.metric);
        }

        @Nullable
        public ByteBuffer getFrom() {
            return this.from;
        }

        @Nullable
        public ByteBuffer getTo() {
            return this.to;
        }

        public Optional<Metric> getMetric() {
            return Optional.ofNullable(this.metric);
        }
    }

    public static class GeoAddCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<RedisGeoCommands.GeoLocation<ByteBuffer>> geoLocations;

        private GeoAddCommand(@Nullable ByteBuffer key, List<RedisGeoCommands.GeoLocation<ByteBuffer>> geoLocations) {
            super(key);
            this.geoLocations = geoLocations;
        }

        public static GeoAddCommand location(RedisGeoCommands.GeoLocation<ByteBuffer> geoLocation) {
            Assert.notNull(geoLocation, (String)"GeoLocation must not be null!");
            return new GeoAddCommand(null, Collections.singletonList(geoLocation));
        }

        public static GeoAddCommand locations(Collection<RedisGeoCommands.GeoLocation<ByteBuffer>> geoLocations) {
            Assert.notNull(geoLocations, (String)"GeoLocations must not be null!");
            return new GeoAddCommand(null, new ArrayList<RedisGeoCommands.GeoLocation<ByteBuffer>>(geoLocations));
        }

        public GeoAddCommand to(ByteBuffer key) {
            return new GeoAddCommand(key, this.geoLocations);
        }

        public List<RedisGeoCommands.GeoLocation<ByteBuffer>> getGeoLocations() {
            return this.geoLocations;
        }
    }
}

