/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.AutowiredWebSecurityConfigurersIgnoreParents;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.crypto.RsaKeyConversionServicePostProcessor;
import org.springframework.security.context.DelegatingApplicationListener;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.security.web.debug.DebugFilter;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.RequestRejectedHandler;
import org.springframework.web.filter.CompositeFilter;
import org.springframework.web.filter.ServletRequestPathFilter;

@Configuration(proxyBeanMethods=false)
public class WebSecurityConfiguration
implements ImportAware {
    private WebSecurity webSecurity;
    private Boolean debugEnabled;
    private List<SecurityFilterChain> securityFilterChains = Collections.emptyList();
    private List<WebSecurityCustomizer> webSecurityCustomizers = Collections.emptyList();

    @Bean
    public static DelegatingApplicationListener delegatingApplicationListener() {
        return new DelegatingApplicationListener();
    }

    @Bean
    @DependsOn(value={"springSecurityFilterChain"})
    public SecurityExpressionHandler<FilterInvocation> webSecurityExpressionHandler() {
        return this.webSecurity.getExpressionHandler();
    }

    @Bean(name={"springSecurityFilterChain"})
    public Filter springSecurityFilterChain(ObjectProvider<HttpSecurity> provider) throws Exception {
        boolean hasFilterChain;
        boolean bl = hasFilterChain = !this.securityFilterChains.isEmpty();
        if (!hasFilterChain) {
            this.webSecurity.addSecurityFilterChainBuilder(() -> {
                HttpSecurity httpSecurity = (HttpSecurity)provider.getObject();
                httpSecurity.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).authenticated());
                httpSecurity.formLogin(Customizer.withDefaults());
                httpSecurity.httpBasic(Customizer.withDefaults());
                return (SecurityFilterChain)httpSecurity.build();
            });
        }
        for (SecurityFilterChain securityFilterChain : this.securityFilterChains) {
            this.webSecurity.addSecurityFilterChainBuilder(() -> securityFilterChain);
        }
        for (WebSecurityCustomizer customizer : this.webSecurityCustomizers) {
            customizer.customize(this.webSecurity);
        }
        return (Filter)this.webSecurity.build();
    }

    @Bean
    @DependsOn(value={"springSecurityFilterChain"})
    public WebInvocationPrivilegeEvaluator privilegeEvaluator() {
        return this.webSecurity.getPrivilegeEvaluator();
    }

    @Autowired(required=false)
    public void setFilterChainProxySecurityConfigurer(ObjectPostProcessor<Object> objectPostProcessor, ConfigurableListableBeanFactory beanFactory) throws Exception {
        this.webSecurity = objectPostProcessor.postProcess(new WebSecurity(objectPostProcessor));
        if (this.debugEnabled != null) {
            this.webSecurity.debug(this.debugEnabled);
        }
        List<SecurityConfigurer<Filter, WebSecurity>> webSecurityConfigurers = new AutowiredWebSecurityConfigurersIgnoreParents(beanFactory).getWebSecurityConfigurers();
        webSecurityConfigurers.sort((Comparator<SecurityConfigurer<Filter, WebSecurity>>)((Object)AnnotationAwareOrderComparator.INSTANCE));
        Integer previousOrder = null;
        SecurityConfigurer<Filter, WebSecurity> previousConfig = null;
        for (SecurityConfigurer<Filter, WebSecurity> config : webSecurityConfigurers) {
            Integer order = AnnotationAwareOrderComparator.lookupOrder(config);
            if (previousOrder != null && previousOrder.equals(order)) {
                throw new IllegalStateException("@Order on WebSecurityConfigurers must be unique. Order of " + order + " was already used on " + String.valueOf(previousConfig) + ", so it cannot be used on " + String.valueOf(config) + " too.");
            }
            previousOrder = order;
            previousConfig = config;
        }
        for (SecurityConfigurer<Filter, WebSecurity> webSecurityConfigurer : webSecurityConfigurers) {
            this.webSecurity.apply(webSecurityConfigurer);
        }
    }

    @Autowired(required=false)
    void setFilterChains(List<SecurityFilterChain> securityFilterChains) {
        this.securityFilterChains = securityFilterChains;
    }

    @Autowired(required=false)
    void setWebSecurityCustomizers(List<WebSecurityCustomizer> webSecurityCustomizers) {
        this.webSecurityCustomizers = webSecurityCustomizers;
    }

    @Bean
    public static RsaKeyConversionServicePostProcessor conversionServicePostProcessor() {
        return new RsaKeyConversionServicePostProcessor();
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map enableWebSecurityAttrMap = importMetadata.getAnnotationAttributes(EnableWebSecurity.class.getName());
        AnnotationAttributes enableWebSecurityAttrs = AnnotationAttributes.fromMap((Map)enableWebSecurityAttrMap);
        this.debugEnabled = enableWebSecurityAttrs.getBoolean("debug");
        if (this.webSecurity != null) {
            this.webSecurity.debug(this.debugEnabled);
        }
    }

    @Bean
    static BeanDefinitionRegistryPostProcessor springSecurityPathPatternParserBeanDefinitionRegistryPostProcessor() {
        return new BeanDefinitionRegistryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            }

            public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
                BeanDefinition filterChainProxy = registry.getBeanDefinition("springSecurityFilterChain");
                if (filterChainProxy.getResolvableType().isInstance(CompositeFilterChainProxy.class)) {
                    return;
                }
                BeanDefinitionBuilder pppCacheFilterBldr = BeanDefinitionBuilder.rootBeanDefinition(ServletRequestPathFilter.class).setRole(2);
                ManagedList filters = new ManagedList();
                filters.add((Object)pppCacheFilterBldr.getBeanDefinition());
                filters.add((Object)filterChainProxy);
                BeanDefinitionBuilder compositeSpringSecurityFilterChainBldr = BeanDefinitionBuilder.rootBeanDefinition(CompositeFilterChainProxy.class).addConstructorArgValue((Object)filters);
                registry.removeBeanDefinition("springSecurityFilterChain");
                registry.registerBeanDefinition("springSecurityFilterChain", (BeanDefinition)compositeSpringSecurityFilterChainBldr.getBeanDefinition());
            }
        };
    }

    private static class AnnotationAwareOrderComparator
    extends OrderComparator {
        private static final AnnotationAwareOrderComparator INSTANCE = new AnnotationAwareOrderComparator();

        private AnnotationAwareOrderComparator() {
        }

        protected int getOrder(Object obj) {
            return AnnotationAwareOrderComparator.lookupOrder(obj);
        }

        private static int lookupOrder(Object obj) {
            Class<?> clazz;
            Order order;
            if (obj instanceof Ordered) {
                return ((Ordered)obj).getOrder();
            }
            if (obj != null && (order = (Order)AnnotationUtils.findAnnotation(clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass(), Order.class)) != null) {
                return order.value();
            }
            return Integer.MAX_VALUE;
        }
    }

    static class CompositeFilterChainProxy
    extends FilterChainProxy {
        private final Filter doFilterDelegate;
        private final FilterChainProxy springSecurityFilterChain;

        CompositeFilterChainProxy(List<? extends Filter> filters) {
            this.doFilterDelegate = CompositeFilterChainProxy.createDoFilterDelegate(filters);
            this.springSecurityFilterChain = CompositeFilterChainProxy.findFilterChainProxy(filters);
        }

        public void afterPropertiesSet() {
            this.springSecurityFilterChain.afterPropertiesSet();
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.doFilterDelegate.doFilter(request, response, chain);
        }

        public List<Filter> getFilters(String url) {
            return this.springSecurityFilterChain.getFilters(url);
        }

        public List<SecurityFilterChain> getFilterChains() {
            return this.springSecurityFilterChain.getFilterChains();
        }

        public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
            this.springSecurityFilterChain.setSecurityContextHolderStrategy(securityContextHolderStrategy);
        }

        public void setFilterChainValidator(FilterChainProxy.FilterChainValidator filterChainValidator) {
            this.springSecurityFilterChain.setFilterChainValidator(filterChainValidator);
        }

        public void setFilterChainDecorator(FilterChainProxy.FilterChainDecorator filterChainDecorator) {
            this.springSecurityFilterChain.setFilterChainDecorator(filterChainDecorator);
        }

        public void setFirewall(HttpFirewall firewall) {
            this.springSecurityFilterChain.setFirewall(firewall);
        }

        public void setRequestRejectedHandler(RequestRejectedHandler requestRejectedHandler) {
            this.springSecurityFilterChain.setRequestRejectedHandler(requestRejectedHandler);
        }

        private List<? extends Filter> getFilters(HttpServletRequest request) {
            List filterChains = this.springSecurityFilterChain.getFilterChains();
            for (SecurityFilterChain chain : filterChains) {
                if (!chain.matches(request)) continue;
                return chain.getFilters();
            }
            return null;
        }

        private static Filter createDoFilterDelegate(List<? extends Filter> filters) {
            CompositeFilter delegate = new CompositeFilter();
            delegate.setFilters(filters);
            return delegate;
        }

        private static FilterChainProxy findFilterChainProxy(List<? extends Filter> filters) {
            for (Filter filter : filters) {
                if (filter instanceof FilterChainProxy) {
                    FilterChainProxy fcp = (FilterChainProxy)filter;
                    return fcp;
                }
                if (!(filter instanceof DebugFilter)) continue;
                DebugFilter debugFilter = (DebugFilter)filter;
                return debugFilter.getFilterChainProxy();
            }
            throw new IllegalStateException("Couldn't find FilterChainProxy in " + String.valueOf(filters));
        }
    }
}

