/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import jakarta.persistence.PersistenceUnitTransactionType;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.orm.jpa.persistenceunit.ClassFileTransformerAdapter;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.SmartPersistenceUnitInfo;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class SpringPersistenceUnitInfo
extends MutablePersistenceUnitInfo {
    private @Nullable LoadTimeWeaver loadTimeWeaver;
    private @Nullable ClassLoader classLoader;

    public SpringPersistenceUnitInfo(LoadTimeWeaver loadTimeWeaver) {
        this.init(loadTimeWeaver);
    }

    public SpringPersistenceUnitInfo(ClassLoader classLoader) {
        this.init(classLoader);
    }

    SpringPersistenceUnitInfo() {
    }

    void init(LoadTimeWeaver loadTimeWeaver) {
        Assert.notNull((Object)loadTimeWeaver, (String)"LoadTimeWeaver must not be null");
        this.loadTimeWeaver = loadTimeWeaver;
        this.classLoader = loadTimeWeaver.getInstrumentableClassLoader();
    }

    void init(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public @Nullable ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addTransformer(ClassTransformer classTransformer) {
        if (this.loadTimeWeaver != null) {
            this.loadTimeWeaver.addTransformer((ClassFileTransformer)new ClassFileTransformerAdapter(classTransformer));
        } else {
            LogFactory.getLog(this.getClass()).info((Object)"No LoadTimeWeaver setup: ignoring JPA class transformer");
        }
    }

    public ClassLoader getNewTempClassLoader() {
        Object tcl = this.loadTimeWeaver != null ? this.loadTimeWeaver.getThrowawayClassLoader() : new SimpleThrowawayClassLoader(this.classLoader);
        String packageToExclude = this.getPersistenceProviderPackageName();
        if (packageToExclude != null && tcl instanceof DecoratingClassLoader) {
            DecoratingClassLoader dcl = (DecoratingClassLoader)tcl;
            dcl.excludePackage(packageToExclude);
        }
        return tcl;
    }

    public PersistenceUnitInfo asStandardPersistenceUnitInfo() {
        return (PersistenceUnitInfo)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{SmartPersistenceUnitInfo.class}, (InvocationHandler)new SmartPersistenceUnitInfoInvocationHandler());
    }

    private class SmartPersistenceUnitInfoInvocationHandler
    implements InvocationHandler {
        private SmartPersistenceUnitInfoInvocationHandler() {
        }

        @Override
        public @Nullable Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("isConfiguredForJta")) {
                return SpringPersistenceUnitInfo.this.getTransactionType() == PersistenceUnitTransactionType.JTA;
            }
            Method targetMethod = SpringPersistenceUnitInfo.class.getMethod(method.getName(), method.getParameterTypes());
            Object returnValue = ReflectionUtils.invokeMethod((Method)targetMethod, (Object)SpringPersistenceUnitInfo.this, (Object[])args);
            Class<?> returnType = method.getReturnType();
            if (returnType.isEnum() && returnValue != null && !returnType.isInstance(returnValue)) {
                return Enum.valueOf(returnType, returnValue.toString());
            }
            return returnValue;
        }
    }
}

