/*
 * Decompiled with CFR 0.152.
 */
package fr.dutra.tools.maven.deptree.extras;

import fr.dutra.tools.maven.deptree.core.Node;
import fr.dutra.tools.maven.deptree.core.VisitException;
import fr.dutra.tools.maven.deptree.core.Visitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;

public abstract class VelocityRenderer
implements Visitor {
    private static final String STATIC_RESOURCES_BASE = "/static";
    protected final File staticDir;
    protected File outputDir;
    protected String fileName;
    protected String encoding;

    public VelocityRenderer() {
        File staticDir = null;
        try {
            staticDir = new File(this.getClass().getResource(STATIC_RESOURCES_BASE).toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.staticDir = staticDir;
        this.fileName = "index.html";
        this.encoding = "UTF-8";
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void visit(Node tree) throws VisitException {
        try {
            this.generateMainFile(tree);
            this.copyResources();
        }
        catch (UnsupportedEncodingException e) {
            throw new VisitException();
        }
        catch (IOException e) {
            throw new VisitException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateMainFile(Node tree) throws IOException, UnsupportedEncodingException {
        VelocityContext vc = this.createVelocityContext(tree);
        Template t = this.createVelocityTemplate();
        File mainFile = new File(this.getOutputDir(), this.getFileName());
        FileOutputStream fos = new FileOutputStream(mainFile);
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)fos, this.getEncoding()));
        try {
            t.merge((Context)vc, (Writer)p);
        }
        finally {
            p.close();
            fos.close();
        }
    }

    protected Template createVelocityTemplate() throws IOException, VelocityException {
        Template t;
        VelocityEngine engine = this.createVelocityEngine();
        try {
            t = engine.getTemplate(this.getTemplatePath());
        }
        catch (IOException e) {
            throw e;
        }
        catch (VelocityException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VelocityException((Throwable)e);
        }
        return t;
    }

    protected abstract String getTemplatePath();

    protected VelocityContext createVelocityContext(Node tree) {
        VelocityContext vc = new VelocityContext();
        vc.put("tree", (Object)tree);
        return vc;
    }

    protected VelocityEngine createVelocityEngine() throws IOException, VelocityException {
        VelocityEngine velocityEngine = new VelocityEngine();
        Properties props = this.getVelocityProperties();
        try {
            velocityEngine.init(props);
        }
        catch (IOException e) {
            throw e;
        }
        catch (VelocityException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VelocityException((Throwable)e);
        }
        return velocityEngine;
    }

    protected Properties getVelocityProperties() throws IOException {
        Properties props = new Properties();
        InputStream is = this.getClass().getResourceAsStream(this.getVelocityPropertiesPath());
        props.load(is);
        return props;
    }

    protected abstract String getVelocityPropertiesPath();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyResources() throws IOException {
        String staticPath = this.staticDir.getAbsolutePath();
        Collection<File> files = this.getFilesToCopy();
        byte[] data = new byte[2048];
        for (File src : files) {
            FileInputStream is = null;
            FileOutputStream fos = null;
            try {
                int count;
                is = new FileInputStream(src);
                String relativePath = StringUtils.substringAfter((String)src.getAbsolutePath(), (String)staticPath);
                File dest = new File(this.getOutputDir(), relativePath);
                File parentFile = dest.getParentFile();
                parentFile.mkdirs();
                fos = new FileOutputStream(dest);
                while ((count = ((InputStream)is).read(data, 0, 2048)) != -1) {
                    fos.write(data, 0, count);
                }
                fos.flush();
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
                if (is == null) continue;
                ((InputStream)is).close();
            }
        }
    }

    protected Collection<File> getFilesToCopy() {
        return FileUtils.listFiles((File)this.staticDir, null, (boolean)true);
    }

    protected final class PathContainsFilter
    implements IOFileFilter {
        private String search;

        public PathContainsFilter(String search) {
            this.search = search;
        }

        public boolean accept(File file) {
            return file.getAbsolutePath().contains(this.search);
        }

        public boolean accept(File dir, String name) {
            return this.accept(new File(dir, name));
        }
    }
}

