/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.utils.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CollectionUtils {
    public static <C, E> Map<C, List<E>> makeListMapImmutable(Map<C, List<E>> listMap) {
        for (C key : listMap.keySet()) {
            listMap.put(key, Collections.unmodifiableList(listMap.get(key)));
        }
        return Collections.unmodifiableMap(listMap);
    }

    public static <T, E extends T> void filterCollectionByType(Collection<T> source, Collection<E> destination, Class<E> clazz) {
        for (T element : source) {
            if (!clazz.isInstance(element)) continue;
            destination.add(element);
        }
    }
}

