/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.retroweaver.runtime.java.lang.Boolean_;
import net.sourceforge.retroweaver.runtime.java.util.Collections_;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonAbstractRule
implements Rule {
    private static final boolean IN_OLD_PROPERTY_MODE = true;
    private String name = this.getClass().getName();
    private String since;
    private String ruleClass = this.getClass().getName();
    private String ruleSetName;
    private String message;
    private String description;
    private List<String> examples = new ArrayList<String>();
    private String externalInfoUrl;
    private int priority = 5;
    private boolean include;
    private Properties properties = new Properties();
    private boolean usesDFA;
    private boolean usesTypeResolution;
    private List<String> ruleChainVisits = new ArrayList<String>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSince() {
        return this.since;
    }

    @Override
    public void setSince(String since) {
        this.since = since;
    }

    @Override
    public String getRuleClass() {
        return this.ruleClass;
    }

    @Override
    public void setRuleClass(String ruleClass) {
        this.ruleClass = ruleClass;
    }

    @Override
    public String getRuleSetName() {
        return this.ruleSetName;
    }

    @Override
    public void setRuleSetName(String ruleSetName) {
        this.ruleSetName = ruleSetName;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<String> getExamples() {
        return this.examples;
    }

    @Override
    public String getExample() {
        if (this.examples.isEmpty()) {
            return null;
        }
        return this.examples.get(this.examples.size() - 1);
    }

    @Override
    public void addExample(String example) {
        this.examples.add(example);
    }

    @Override
    public String getExternalInfoUrl() {
        return this.externalInfoUrl;
    }

    @Override
    public void setExternalInfoUrl(String externalInfoUrl) {
        this.externalInfoUrl = externalInfoUrl;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public String getPriorityName() {
        return PRIORITIES[this.getPriority() - 1];
    }

    @Override
    public boolean include() {
        return this.include;
    }

    @Override
    public void setInclude(boolean include) {
        this.include = include;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void addProperty(String name, String value) {
        this.getProperties().setProperty(name, value);
    }

    @Override
    public void addProperties(Properties properties) {
        this.getProperties().putAll((Map<?, ?>)properties);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.getProperties().containsKey(name);
    }

    @Override
    public boolean getBooleanProperty(String name) {
        return Boolean_.parseBoolean((String)this.getProperties().getProperty(name));
    }

    public boolean getBooleanProperty(PropertyDescriptor descriptor) {
        return (Boolean)this.getProperty(descriptor);
    }

    public boolean[] getBooleanProperties(PropertyDescriptor descriptor) {
        Boolean[] values = (Boolean[])this.getProperties(descriptor);
        boolean[] bools = new boolean[values.length];
        for (int i = 0; i < bools.length; ++i) {
            bools[i] = values[i];
        }
        return bools;
    }

    @Override
    public int getIntProperty(String name) {
        return Integer.parseInt(this.getProperties().getProperty(name));
    }

    public int getIntProperty(PropertyDescriptor descriptor) {
        return ((Number)this.getProperty(descriptor)).intValue();
    }

    public int[] getIntProperties(PropertyDescriptor descriptor) {
        Number[] values = (Number[])this.getProperties(descriptor);
        int[] ints = new int[values.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = values[i].intValue();
        }
        return ints;
    }

    @Override
    public double getDoubleProperty(String name) {
        return Double.parseDouble(this.getProperties().getProperty(name));
    }

    public double getDoubleProperty(PropertyDescriptor descriptor) {
        return ((Number)this.getProperty(descriptor)).doubleValue();
    }

    public double[] getDoubleProperties(PropertyDescriptor descriptor) {
        Number[] values = (Number[])this.getProperties(descriptor);
        double[] doubles = new double[values.length];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = values[i].doubleValue();
        }
        return doubles;
    }

    @Override
    public String getStringProperty(String name) {
        return this.getProperties().getProperty(name);
    }

    public String getStringProperty(PropertyDescriptor descriptor) {
        return (String)this.getProperty(descriptor);
    }

    public String[] getStringProperties(PropertyDescriptor descriptor) {
        return (String[])this.getProperties(descriptor);
    }

    public Class[] getTypeProperties(PropertyDescriptor descriptor) {
        return (Class[])this.getProperties(descriptor);
    }

    public Class getTypeProperty(PropertyDescriptor descriptor) {
        return (Class)this.getProperty(descriptor);
    }

    private Object getProperty(PropertyDescriptor descriptor) {
        String rawValue;
        if (descriptor.maxValueCount() > 1) {
            this.propertyGetError(descriptor, true);
        }
        return (rawValue = this.getProperties().getProperty(descriptor.name())) == null || rawValue.length() == 0 ? descriptor.defaultValue() : descriptor.valueFrom(rawValue);
    }

    public void setProperty(PropertyDescriptor descriptor, Object value) {
        if (descriptor.maxValueCount() > 1) {
            this.propertySetError(descriptor, true);
        }
        this.getProperties().setProperty(descriptor.name(), descriptor.asDelimitedString(value));
    }

    private Object[] getProperties(PropertyDescriptor descriptor) {
        String rawValue;
        if (descriptor.maxValueCount() == 1) {
            this.propertyGetError(descriptor, false);
        }
        return (rawValue = this.getProperties().getProperty(descriptor.name())) == null || rawValue.length() == 0 ? (Object[])descriptor.defaultValue() : (Object[])descriptor.valueFrom(rawValue);
    }

    public void setProperties(PropertyDescriptor descriptor, Object[] values) {
        if (descriptor.maxValueCount() == 1) {
            this.propertySetError(descriptor, false);
        }
        this.getProperties().setProperty(descriptor.name(), descriptor.asDelimitedString(values));
    }

    protected Map<String, PropertyDescriptor> propertiesByName() {
        return Collections_.emptyMap();
    }

    @Override
    public PropertyDescriptor propertyDescriptorFor(String name) {
        PropertyDescriptor descriptor = this.propertiesByName().get(name);
        if (descriptor == null) {
            throw new IllegalArgumentException(new StringBuffer().append("Unknown property: ").append(name).toString());
        }
        return descriptor;
    }

    private void propertyGetError(PropertyDescriptor descriptor, boolean requestedSingleValue) {
        if (requestedSingleValue) {
            throw new RuntimeException("Cannot retrieve a single value from a multi-value property field");
        }
        throw new RuntimeException("Cannot retrieve multiple values from a single-value property field");
    }

    private void propertySetError(PropertyDescriptor descriptor, boolean setSingleValue) {
        if (setSingleValue) {
            throw new RuntimeException("Cannot set a single value within a multi-value property field");
        }
        throw new RuntimeException("Cannot set multiple values within a single-value property field");
    }

    @Override
    public void setUsesDFA() {
        this.usesDFA = true;
    }

    @Override
    public boolean usesDFA() {
        return this.usesDFA;
    }

    @Override
    public void setUsesTypeResolution() {
        this.usesTypeResolution = true;
    }

    @Override
    public boolean usesTypeResolution() {
        return this.usesTypeResolution;
    }

    @Override
    public boolean usesRuleChain() {
        return !this.getRuleChainVisits().isEmpty();
    }

    @Override
    public List<String> getRuleChainVisits() {
        return this.ruleChainVisits;
    }

    @Override
    public void addRuleChainVisit(String astNodeName) {
        if (!this.ruleChainVisits.contains(astNodeName)) {
            this.ruleChainVisits.add(astNodeName);
        }
    }

    @Override
    public void start(RuleContext ctx) {
    }

    @Override
    public void end(RuleContext ctx) {
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        boolean equality = this.getClass().getName().equals(o.getClass().getName());
        if (equality) {
            Rule that = (Rule)o;
            equality = this.getName().equals(that.getName()) && this.getPriority() == that.getPriority() && this.getProperties().equals(that.getProperties());
        }
        return equality;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + (this.getName() != null ? this.getName().hashCode() : 0) + this.getPriority() + (this.getProperties() != null ? this.getProperties().hashCode() : 0);
    }

    protected static Map<String, PropertyDescriptor> asFixedMap(PropertyDescriptor[] descriptors) {
        HashMap<String, PropertyDescriptor> descriptorsByName = new HashMap<String, PropertyDescriptor>(descriptors.length);
        for (PropertyDescriptor descriptor : descriptors) {
            descriptorsByName.put(descriptor.name(), descriptor);
        }
        return Collections.unmodifiableMap(descriptorsByName);
    }

    protected static Map<String, PropertyDescriptor> asFixedMap(PropertyDescriptor descriptor) {
        return CommonAbstractRule.asFixedMap(new PropertyDescriptor[]{descriptor});
    }
}

