/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import net.sourceforge.pmd.properties.AbstractPMDProperty;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringProperty
extends AbstractPMDProperty {
    private int preferredRowCount;
    public static final char defaultDelimiter = '|';
    private static final /* synthetic */ Class class$java$lang$String;

    public StringProperty(String theName, String theDescription, String theDefaultValue, float theUIOrder) {
        this(theName, theDescription, theDefaultValue, theUIOrder, '|');
        this.maxValueCount(1);
    }

    public StringProperty(String theName, String theDescription, String[] theValues, float theUIOrder, char aMultiValueDelimiter) {
        super(theName, theDescription, theValues, theUIOrder);
        this.maxValueCount(Integer.MAX_VALUE);
        this.multiValueDelimiter(aMultiValueDelimiter);
    }

    protected StringProperty(String theName, String theDescription, Object theDefaultValue, float theUIOrder, char aMultiValueDelimiter) {
        super(theName, theDescription, theDefaultValue, theUIOrder);
        this.maxValueCount(Integer.MAX_VALUE);
        this.multiValueDelimiter(aMultiValueDelimiter);
    }

    @Override
    public Class<?> type() {
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        return clazz;
    }

    @Override
    public Object valueFrom(String valueString) {
        if (this.maxValueCount() == 1) {
            return valueString;
        }
        return StringUtil.substringsOf(valueString, this.multiValueDelimiter);
    }

    private boolean containsDelimiter(String value) {
        return value.indexOf(this.multiValueDelimiter) >= 0;
    }

    private final String illegalCharMsg() {
        return new StringBuffer().append("Value cannot contain the \"").append(this.multiValueDelimiter).append("\" character").toString();
    }

    @Override
    protected String valueErrorFor(Object value) {
        if (this.maxValueCount() == 1) {
            String testValue = (String)value;
            if (!this.containsDelimiter(testValue)) {
                return null;
            }
            return this.illegalCharMsg();
        }
        String[] values = (String[])value;
        for (int i = 0; i < values.length; ++i) {
            if (!this.containsDelimiter(values[i])) continue;
            return this.illegalCharMsg();
        }
        return null;
    }

    @Override
    public int preferredRowCount() {
        return this.preferredRowCount;
    }
}

