/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.ast.ASTPrimitiveType;
import net.sourceforge.pmd.ast.ASTResultType;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.properties.StringProperty;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMembersShouldSerializeRule
extends AbstractRule {
    private String prefixProperty;
    private static final PropertyDescriptor prefixDescriptor = new StringProperty("prefix", "Prefix somethingorother?", "", 1.0f);
    private static final Map<String, PropertyDescriptor> propertyDescriptorsByName = BeanMembersShouldSerializeRule.asFixedMap(prefixDescriptor);
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimitiveType;

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.prefixProperty = this.getStringProperty(prefixDescriptor);
        super.visit(node, data);
        return data;
    }

    private static String[] imagesOf(List<? extends SimpleNode> simpleNodes) {
        String[] imageArray = new String[simpleNodes.size()];
        for (int i = 0; i < simpleNodes.size(); ++i) {
            imageArray[i] = simpleNodes.get(i).getImage();
        }
        return imageArray;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        Map<MethodNameDeclaration, List<NameOccurrence>> methods = node.getScope().getEnclosingClassScope().getMethodDeclarations();
        ArrayList<ASTMethodDeclarator> getSetMethList = new ArrayList<ASTMethodDeclarator>(methods.size());
        for (MethodNameDeclaration d : methods.keySet()) {
            ASTMethodDeclarator mnd = d.getMethodNameDeclaratorNode();
            if (!this.isBeanAccessor(mnd)) continue;
            getSetMethList.add(mnd);
        }
        Object[] methNameArray = BeanMembersShouldSerializeRule.imagesOf(getSetMethList);
        Arrays.sort(methNameArray);
        Map<VariableNameDeclaration, List<NameOccurrence>> vars = node.getScope().getVariableDeclarations();
        for (VariableNameDeclaration decl : vars.keySet()) {
            boolean hasSetMethod;
            if (vars.get(decl).isEmpty() || decl.getAccessNodeParent().isTransient() || decl.getAccessNodeParent().isStatic()) continue;
            String varName = this.trimIfPrefix(decl.getImage());
            varName = new StringBuffer().append(varName.substring(0, 1).toUpperCase()).append(varName.substring(1, varName.length())).toString();
            boolean hasGetMethod = Arrays.binarySearch(methNameArray, new StringBuffer().append("get").append(varName).toString()) >= 0 || Arrays.binarySearch(methNameArray, new StringBuffer().append("is").append(varName).toString()) >= 0;
            boolean bl = hasSetMethod = Arrays.binarySearch(methNameArray, new StringBuffer().append("set").append(varName).toString()) >= 0;
            if (hasGetMethod && hasSetMethod) continue;
            this.addViolation(data, decl.getNode(), decl.getImage());
        }
        return super.visit(node, data);
    }

    private String trimIfPrefix(String img) {
        if (this.prefixProperty != null && img.startsWith(this.prefixProperty)) {
            return img.substring(this.prefixProperty.length());
        }
        return img;
    }

    private boolean isBeanAccessor(ASTMethodDeclarator meth) {
        String methodName = meth.getImage();
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            return true;
        }
        if (methodName.startsWith("is")) {
            List primitives;
            ASTResultType ret = (ASTResultType)meth.jjtGetParent().jjtGetChild(0);
            Class<?> clazz = class$net$sourceforge$pmd$ast$ASTPrimitiveType;
            if (clazz == null) {
                clazz = class$net$sourceforge$pmd$ast$ASTPrimitiveType = new ASTPrimitiveType[0].getClass().getComponentType();
            }
            if (!(primitives = ret.findChildrenOfType(clazz)).isEmpty() && ((ASTPrimitiveType)primitives.get(0)).isBoolean()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Map<String, PropertyDescriptor> propertiesByName() {
        return propertyDescriptorsByName;
    }
}

