/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.pmd.ast.ASTArguments;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameFinder {
    private LinkedList<NameOccurrence> names = new LinkedList();

    public NameFinder(ASTPrimaryExpression node) {
        ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)node.jjtGetChild(0);
        if (prefix.usesSuperModifier()) {
            this.add(new NameOccurrence(prefix, "super"));
        } else if (prefix.usesThisModifier()) {
            this.add(new NameOccurrence(prefix, "this"));
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            this.checkForNameChild((SimpleNode)node.jjtGetChild(i));
        }
    }

    public List<NameOccurrence> getNames() {
        return this.names;
    }

    private void checkForNameChild(SimpleNode node) {
        if (node.getImage() != null) {
            this.add(new NameOccurrence(node, node.getImage()));
        }
        if (node.jjtGetNumChildren() > 0 && node.jjtGetChild(0) instanceof ASTName) {
            ASTName grandchild = (ASTName)node.jjtGetChild(0);
            StringTokenizer st = new StringTokenizer(grandchild.getImage(), ".");
            while (st.hasMoreTokens()) {
                this.add(new NameOccurrence(grandchild, st.nextToken()));
            }
        }
        if (node instanceof ASTPrimarySuffix && ((ASTPrimarySuffix)node).isArguments()) {
            NameOccurrence occurrence = this.names.getLast();
            occurrence.setIsMethodOrConstructorInvocation();
            ASTArguments args = (ASTArguments)((ASTPrimarySuffix)node).jjtGetChild(0);
            occurrence.setArgumentCount(args.getArgumentCount());
        }
    }

    private void add(NameOccurrence name) {
        this.names.add(name);
        if (this.names.size() > 1) {
            NameOccurrence qualifiedName = this.names.get(this.names.size() - 2);
            qualifiedName.setNameWhichThisQualifies(name);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (NameOccurrence occ : this.names) {
            result.append(occ.getImage());
        }
        return result.toString();
    }
}

