/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.typeresolution;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.typeresolution.visitors.PMDASMVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMDASMClassLoader
extends ClassLoader {
    private Set<String> dontBother = new HashSet<String>();

    public PMDASMClassLoader(ClassLoader parent) {
        super(parent);
    }

    public synchronized Map<String, String> getImportedClasses(String name) throws ClassNotFoundException {
        if (this.dontBother.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        try {
            ClassReader reader = new ClassReader(this.getResourceAsStream(new StringBuffer().append(name.replace('.', '/')).append(".class").toString()));
            PMDASMVisitor asmVisitor = new PMDASMVisitor();
            reader.accept((ClassVisitor)asmVisitor, 0);
            List<String> inner = asmVisitor.getInnerClasses();
            if (inner != null && !inner.isEmpty()) {
                inner = new LinkedList<String>(inner);
                for (String str : inner) {
                    reader = new ClassReader(this.getResourceAsStream(new StringBuffer().append(str.replace('.', '/')).append(".class").toString()));
                    reader.accept((ClassVisitor)asmVisitor, 0);
                }
            }
            return asmVisitor.getPackages();
        }
        catch (IOException e) {
            this.dontBother.add(name);
            throw new ClassNotFoundException(name);
        }
    }
}

