/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import net.sourceforge.pmd.util.TypeMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtil {
    public static final TypeMap collectionInterfacesByNames;
    public static final TypeMap collectionClassesByNames;
    private static final /* synthetic */ Class class$java$util$List;
    private static final /* synthetic */ Class class$java$util$Collection;
    private static final /* synthetic */ Class class$java$util$LinkedHashSet;
    private static final /* synthetic */ Class class$java$util$Map;
    private static final /* synthetic */ Class class$java$util$LinkedList;
    private static final /* synthetic */ Class class$java$util$LinkedHashMap;
    private static final /* synthetic */ Class class$java$util$Set;
    private static final /* synthetic */ Class class$java$util$HashMap;
    private static final /* synthetic */ Class class$java$util$TreeMap;
    private static final /* synthetic */ Class class$java$util$Vector;
    private static final /* synthetic */ Class class$java$util$TreeSet;
    private static final /* synthetic */ Class class$java$util$ArrayList;
    private static final /* synthetic */ Class class$java$util$HashSet;

    private CollectionUtil() {
    }

    public static Class getCollectionTypeFor(String shortName) {
        Class cls = collectionClassesByNames.typeFor(shortName);
        if (cls != null) {
            return cls;
        }
        return collectionInterfacesByNames.typeFor(shortName);
    }

    public static boolean isCollectionType(String typeName, boolean includeInterfaces) {
        if (collectionClassesByNames.contains(typeName)) {
            return true;
        }
        return includeInterfaces && collectionInterfacesByNames.contains(typeName);
    }

    public static boolean isCollectionType(Class clazzType, boolean includeInterfaces) {
        if (collectionClassesByNames.contains(clazzType)) {
            return true;
        }
        return includeInterfaces && collectionInterfacesByNames.contains(clazzType);
    }

    public static <T> Set<T> asSet(T[] items) {
        HashSet<T> set = new HashSet<T>(items.length);
        for (int i = 0; i < items.length; ++i) {
            set.add(items[i]);
        }
        return set;
    }

    public static <K, V> Map<K, V> mapFrom(K[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new RuntimeException("mapFrom keys and values arrays have different sizes");
        }
        HashMap<K, V> map = new HashMap<K, V>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <K, V> Map<V, K> invertedMapFrom(Map<K, V> source) {
        HashMap<V, K> map = new HashMap<V, K>(source.size());
        for (Map.Entry<K, V> entry : source.entrySet()) {
            map.put(entry.getValue(), entry.getKey());
        }
        return map;
    }

    public static final boolean arraysAreEqual(Object value, Object otherValue) {
        if (value instanceof Object[]) {
            if (otherValue instanceof Object[]) {
                return CollectionUtil.valuesAreTransitivelyEqual((Object[])value, (Object[])otherValue);
            }
            return false;
        }
        return false;
    }

    public static final boolean valuesAreTransitivelyEqual(Object[] thisArray, Object[] thatArray) {
        if (thisArray == thatArray) {
            return true;
        }
        if (thisArray == null || thatArray == null) {
            return false;
        }
        if (thisArray.length != thatArray.length) {
            return false;
        }
        for (int i = 0; i < thisArray.length; ++i) {
            if (CollectionUtil.areEqual(thisArray[i], thatArray[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean areEqual(Object value, Object otherValue) {
        if (value == otherValue) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (otherValue == null) {
            return false;
        }
        if (value.getClass().getComponentType() != null) {
            return CollectionUtil.arraysAreEqual(value, otherValue);
        }
        return value.equals(otherValue);
    }

    static {
        Class<?> clazz;
        Class clazz2;
        Class clazz3;
        Class clazz4;
        Class clazz5;
        Class clazz6;
        Class clazz7;
        Class clazz8;
        Class<?> clazz9;
        Class clazz10;
        Class clazz11;
        Class[] classArray = new Class[4];
        Class clazz12 = class$java$util$List;
        if (clazz12 == null) {
            clazz12 = classArray[0] = (class$java$util$List = new List[0].getClass().getComponentType());
        }
        if ((clazz11 = class$java$util$Collection) == null) {
            clazz11 = classArray[1] = (class$java$util$Collection = new Collection[0].getClass().getComponentType());
        }
        if ((clazz10 = class$java$util$Map) == null) {
            clazz10 = classArray[2] = (class$java$util$Map = new Map[0].getClass().getComponentType());
        }
        if ((clazz9 = class$java$util$Set) == null) {
            clazz9 = class$java$util$Set = new Set[0].getClass().getComponentType();
        }
        classArray[3] = clazz9;
        collectionInterfacesByNames = new TypeMap(classArray);
        Class[] classArray2 = new Class[9];
        Class clazz13 = class$java$util$ArrayList;
        if (clazz13 == null) {
            clazz13 = classArray2[0] = (class$java$util$ArrayList = new ArrayList[0].getClass().getComponentType());
        }
        if ((clazz8 = class$java$util$LinkedList) == null) {
            clazz8 = classArray2[1] = (class$java$util$LinkedList = new LinkedList[0].getClass().getComponentType());
        }
        if ((clazz7 = class$java$util$Vector) == null) {
            clazz7 = classArray2[2] = (class$java$util$Vector = new Vector[0].getClass().getComponentType());
        }
        if ((clazz6 = class$java$util$HashMap) == null) {
            clazz6 = classArray2[3] = (class$java$util$HashMap = new HashMap[0].getClass().getComponentType());
        }
        if ((clazz5 = class$java$util$LinkedHashMap) == null) {
            clazz5 = classArray2[4] = (class$java$util$LinkedHashMap = new LinkedHashMap[0].getClass().getComponentType());
        }
        if ((clazz4 = class$java$util$TreeMap) == null) {
            clazz4 = classArray2[5] = (class$java$util$TreeMap = new TreeMap[0].getClass().getComponentType());
        }
        if ((clazz3 = class$java$util$TreeSet) == null) {
            clazz3 = classArray2[6] = (class$java$util$TreeSet = new TreeSet[0].getClass().getComponentType());
        }
        if ((clazz2 = class$java$util$HashSet) == null) {
            clazz2 = classArray2[7] = (class$java$util$HashSet = new HashSet[0].getClass().getComponentType());
        }
        if ((clazz = class$java$util$LinkedHashSet) == null) {
            clazz = class$java$util$LinkedHashSet = new LinkedHashSet[0].getClass().getComponentType();
        }
        classArray2[8] = clazz;
        collectionClassesByNames = new TypeMap(classArray2);
    }
}

